/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.panels;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.movie.MovieComparator;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.ITmmTabItem;
import org.tinymediamanager.ui.ITmmUIModule;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TablePopupListener;
import org.tinymediamanager.ui.components.EnhancedTextField;
import org.tinymediamanager.ui.components.TmmListPanel;
import org.tinymediamanager.ui.components.table.MouseKeyboardSortingStrategy;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.movies.MovieFilterator;
import org.tinymediamanager.ui.movies.MovieMatcherEditor;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.movies.MovieTableFormat;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.actions.MovieEditAction;
import org.tinymediamanager.ui.movies.filters.IMovieUIFilter;

public class MovieListPanel
extends TmmListPanel
implements ITmmTabItem {
    private static final long serialVersionUID = -1681460428331929420L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    MovieSelectionModel selectionModel;
    private MovieList movieList;
    private JTextField searchField;
    private TmmTable movieTable;
    private JLabel lblMovieCountFiltered;
    private JLabel lblMovieCountTotal;
    private JButton btnExtendedFilter;

    public MovieListPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setOpaque(false);
        this.movieList = MovieList.getInstance();
        SortedList sortedMovies = new SortedList((EventList)GlazedListsSwing.swingThreadProxyList((EventList)((ObservableElementList)this.movieList.getMovies())), (Comparator)new MovieComparator());
        sortedMovies.setMode(1);
        this.setLayout((LayoutManager)new MigLayout("insets n n 0 n", "[200lp:n,grow][100lp:n,fill]", "[][200lp:300lp,grow]0[][]"));
        this.searchField = EnhancedTextField.createSearchTextField();
        this.add((Component)this.searchField, "cell 0 0,growx");
        TextComponentMatcherEditor textMatcherEditor = new TextComponentMatcherEditor((JTextComponent)this.searchField, (TextFilterator)new MovieFilterator());
        MovieMatcherEditor movieMatcherEditor = new MovieMatcherEditor();
        FilterList extendedFilteredMovies = new FilterList((EventList)sortedMovies, (MatcherEditor)movieMatcherEditor);
        FilterList textFilteredMovies = new FilterList((EventList)extendedFilteredMovies, (MatcherEditor)textMatcherEditor);
        this.selectionModel = new MovieSelectionModel((SortedList<Movie>)sortedMovies, (EventList<Movie>)textFilteredMovies, movieMatcherEditor);
        TmmTableModel<Movie> movieTableModel = new TmmTableModel<Movie>((EventList<Movie>)textFilteredMovies, new MovieTableFormat());
        this.movieTable = new TmmTable((TableModel)((Object)movieTableModel));
        TableComparatorChooser.install((JTable)this.movieTable, (SortedList)sortedMovies, (Object)new MouseKeyboardSortingStrategy()).appendComparator(0, 0, false);
        this.movieTable.readHiddenColumns(MovieModuleManager.SETTINGS.getMovieTableHiddenColumns());
        this.movieTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                this.writeSettings();
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                this.writeSettings();
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            private void writeSettings() {
                MovieListPanel.this.movieTable.writeHiddenColumns(cols -> {
                    MovieModuleManager.SETTINGS.setMovieTableHiddenColumns((List<String>)cols);
                    MovieModuleManager.SETTINGS.saveSettings();
                });
            }
        });
        this.movieTable.adjustColumnPreferredWidths(3);
        movieTableModel.addTableModelListener(arg0 -> {
            this.lblMovieCountFiltered.setText(String.valueOf(movieTableModel.getRowCount()));
            ListSelectionModel selectionModel1 = this.movieTable.getSelectionModel();
            if (selectionModel1.isSelectionEmpty() && movieTableModel.getRowCount() > 0) {
                selectionModel1.setSelectionInterval(0, 0);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.movieTable);
        this.movieTable.configureScrollPane(scrollPane, new int[]{0});
        this.add((Component)scrollPane, "cell 0 1 2 1,grow");
        this.btnExtendedFilter = new JButton(BUNDLE.getString("movieextendedsearch.filter"));
        this.btnExtendedFilter.setToolTipText(BUNDLE.getString("movieextendedsearch.options"));
        this.btnExtendedFilter.addActionListener(e -> MovieUIModule.getInstance().setFilterDialogVisible(true));
        this.selectionModel.addPropertyChangeListener("filterChanged", evt -> this.updateFilterIndicator());
        this.add((Component)this.btnExtendedFilter, "cell 1 0");
        JSeparator separator = new JSeparator();
        this.add((Component)separator, "cell 0 2 2 1, growx");
        JLabel lblMovieCount = new JLabel(BUNDLE.getString("tmm.movies") + ":");
        this.add((Component)lblMovieCount, "flowx,cell 0 3 2 1");
        this.lblMovieCountFiltered = new JLabel("");
        this.add((Component)this.lblMovieCountFiltered, "cell 0 3 2 1");
        JLabel lblMovieCountOf = new JLabel(BUNDLE.getString("tmm.of"));
        this.add((Component)lblMovieCountOf, "cell 0 3 2 1");
        this.lblMovieCountTotal = new JLabel("");
        this.add((Component)this.lblMovieCountTotal, "cell 0 3 2 1");
        this.initDataBindings();
        this.lblMovieCountFiltered.setText(String.valueOf(movieTableModel.getRowCount()));
    }

    private void updateFilterIndicator() {
        boolean active = false;
        for (IMovieUIFilter filter : this.selectionModel.getMatcherEditor().getFilters()) {
            switch (filter.getFilterState()) {
                case ACTIVE: 
                case ACTIVE_NEGATIVE: {
                    active = true;
                    break;
                }
            }
            if (!active) continue;
            break;
        }
        if (active) {
            this.btnExtendedFilter.setIcon(IconManager.FILTER_ACTIVE);
        } else {
            this.btnExtendedFilter.setIcon(null);
        }
    }

    public void init() {
        ListSelectionModel selectionModel;
        this.updateFilterIndicator();
        this.movieTable.setSelectionModel((ListSelectionModel)this.selectionModel.getSelectionModel());
        if (MovieList.getInstance().getMovies() != null && !MovieList.getInstance().getMovies().isEmpty() && (selectionModel = this.movieTable.getSelectionModel()).isSelectionEmpty()) {
            int selectionIndex = this.movieTable.convertRowIndexToModel(0);
            selectionModel.setSelectionInterval(selectionIndex, selectionIndex);
        }
        this.addKeyListener();
        SwingUtilities.invokeLater(() -> this.movieTable.requestFocus());
    }

    private void addKeyListener() {
        this.movieTable.addKeyListener(new KeyListener(){
            private long lastKeypress = 0L;
            private String searchTerm = "";

            @Override
            public void keyTyped(KeyEvent arg0) {
                long now = System.currentTimeMillis();
                if (now - this.lastKeypress > 500L) {
                    this.searchTerm = "";
                }
                this.lastKeypress = now;
                if (arg0.getKeyChar() != '\uffff') {
                    this.searchTerm = this.searchTerm + arg0.getKeyChar();
                    this.searchTerm = this.searchTerm.toLowerCase();
                }
                if (StringUtils.isNotBlank((CharSequence)this.searchTerm)) {
                    boolean titleColumn = true;
                    TableColumn tableColumn = MovieListPanel.this.movieTable.getColumnModel().getColumn(0);
                    if ("originalTitle".equals(tableColumn.getIdentifier())) {
                        titleColumn = false;
                    }
                    TableModel model = MovieListPanel.this.movieTable.getModel();
                    for (int i = 0; i < model.getRowCount(); ++i) {
                        if (!(model.getValueAt(i, 0) instanceof Movie)) continue;
                        Movie movie = (Movie)model.getValueAt(i, 0);
                        String title = titleColumn ? movie.getTitleSortable().toLowerCase(Locale.ROOT) : movie.getOriginalTitleSortable().toLowerCase(Locale.ROOT);
                        if (!title.startsWith(this.searchTerm)) continue;
                        MovieListPanel.this.movieTable.getSelectionModel().setSelectionInterval(i, i);
                        MovieListPanel.this.movieTable.scrollRectToVisible(new Rectangle(MovieListPanel.this.movieTable.getCellRect(i, 0, true)));
                        break;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }
        });
    }

    public MovieSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public ITmmUIModule getUIModule() {
        return MovieUIModule.getInstance();
    }

    @Override
    public void setPopupMenu(JPopupMenu popupMenu) {
        this.movieTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && !e.isConsumed() && e.getButton() == 1) {
                    MovieEditAction editAction = new MovieEditAction();
                    editAction.actionPerformed(null);
                }
            }
        });
        this.movieTable.addMouseListener(new TablePopupListener(popupMenu, this.movieTable));
    }

    protected void initDataBindings() {
        BeanProperty movieListBeanProperty = BeanProperty.create((String)"movieCount");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieList, (Property)movieListBeanProperty, (Object)this.lblMovieCountTotal, (Property)jLabelBeanProperty);
        autoBinding.bind();
    }
}

