/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.ScrollingEventDelegator;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.EnhancedTextField;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.SettingsPanelFactory;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;

public class MovieRenamerSettingsPanel
extends JPanel
implements HierarchyListener {
    private static final long serialVersionUID = 5039498266207230875L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieRenamerSettingsPanel.class);
    private MovieSettings settings = MovieModuleManager.SETTINGS;
    private List<String> spaceReplacement = new ArrayList<String>(Arrays.asList("_", ".", "-"));
    private List<String> colonReplacement = new ArrayList<String>(Arrays.asList(" ", "-", "_"));
    private EventList<MovieRenamerExample> exampleEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(MovieRenamerExample.class)));
    private EnhancedTextField tfMoviePath;
    private EnhancedTextField tfMovieFilename;
    private JLabel lblExample;
    private JCheckBox chckbxAsciiReplacement;
    private JCheckBox chckbxFoldernameSpaceReplacement;
    private JComboBox cbFoldernameSpaceReplacement;
    private JCheckBox chckbxFilenameSpaceReplacement;
    private JComboBox cbFilenameSpaceReplacement;
    private JComboBox cbMovieForPreview;
    private JCheckBox chckbxRemoveOtherNfos;
    private JCheckBox chckbxMoviesetSingleMovie;
    private TmmTable tableExamples;
    private ReadOnlyTextArea taWarning;
    private JComboBox cbColonReplacement;

    public MovieRenamerSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.tfMoviePath.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }
        });
        this.tfMovieFilename.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                MovieRenamerSettingsPanel.this.createRenamerExample();
            }
        });
        String replacement = this.settings.getRenamerPathnameSpaceReplacement();
        int index = this.spaceReplacement.indexOf(replacement);
        if (index >= 0) {
            this.cbFoldernameSpaceReplacement.setSelectedIndex(index);
        }
        if ((index = this.spaceReplacement.indexOf(replacement = this.settings.getRenamerFilenameSpaceReplacement())) >= 0) {
            this.cbFilenameSpaceReplacement.setSelectedIndex(index);
        }
        if ((index = this.colonReplacement.indexOf(replacement = this.settings.getRenamerColonReplacement())) >= 0) {
            this.cbColonReplacement.setSelectedIndex(index);
        }
        this.cbFoldernameSpaceReplacement.addActionListener(arg0 -> {
            this.checkChanges();
            this.createRenamerExample();
        });
        this.cbFilenameSpaceReplacement.addActionListener(arg0 -> {
            this.checkChanges();
            this.createRenamerExample();
        });
        this.cbColonReplacement.addActionListener(arg0 -> {
            this.checkChanges();
            this.createRenamerExample();
        });
        this.lblExample.putClientProperty("clipPosition", 2);
        this.exampleEventList.add((Object)new MovieRenamerExample("${title}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${originalTitle}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${title[0]}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${title;first}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${title[0,2]}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${titleSortable}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${year}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${movieSet.title}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${movieSet.titleSortable}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${rating}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${imdb}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${certification}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${directors[0].name}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${genres[0]}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${genres[0].name}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${genresAsString}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${tags[0]}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${language}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${videoResolution}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${videoCodec}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${videoFormat}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${videoBitDepth}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${audioCodec}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${audioCodecList}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${audioCodecsAsString}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${audioChannels}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${audioChannelList}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${audioChannelsAsString}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${audioLanguage}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${audioLanguageList}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${audioLanguagesAsString}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${subtitleLanguageList}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${subtitleLanguagesAsString}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${mediaSource}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${3Dformat}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${hdr}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${filesize}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${edition}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${parent}"));
        this.exampleEventList.add((Object)new MovieRenamerExample("${note}"));
        ActionListener actionCreateRenamerExample = e -> this.createRenamerExample();
        this.cbMovieForPreview.addActionListener(actionCreateRenamerExample);
        this.chckbxMoviesetSingleMovie.addActionListener(actionCreateRenamerExample);
        this.chckbxAsciiReplacement.addActionListener(actionCreateRenamerExample);
        this.chckbxFilenameSpaceReplacement.addActionListener(actionCreateRenamerExample);
        this.chckbxFoldernameSpaceReplacement.addActionListener(actionCreateRenamerExample);
        this.tableExamples.setPreferredScrollableViewportSize(this.tableExamples.getPreferredSize());
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 1", "[grow]", "[][15lp!][][15lp!][]"));
        JPanel panelPatterns = new JPanel((LayoutManager)new MigLayout("insets 0, hidemode 1", "[20lp!][15lp][][300lp,grow]", "[][][][][][]"));
        TmmLabel lblPatternsT = new TmmLabel(BUNDLE.getString("Settings.movie.renamer.title"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelPatterns, lblPatternsT, true);
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        JLabel lblMoviePath = new JLabel(BUNDLE.getString("Settings.renamer.folder"));
        panelPatterns.add((Component)lblMoviePath, "cell 1 0 2 1,alignx right");
        this.tfMoviePath = new EnhancedTextField(IconManager.UNDO_GREY);
        this.tfMoviePath.setIconToolTipText(BUNDLE.getString("Settings.renamer.reverttodefault"));
        this.tfMoviePath.addIconMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MovieRenamerSettingsPanel.this.tfMoviePath.setText("${title} ${- ,edition,} (${year})");
            }
        });
        panelPatterns.add((Component)this.tfMoviePath, "cell 3 0,growx");
        JLabel lblDefault = new JLabel(BUNDLE.getString("Settings.default"));
        panelPatterns.add((Component)lblDefault, "cell 1 1 2 1,alignx right");
        TmmFontHelper.changeFont((JComponent)lblDefault, TmmFontHelper.L2);
        ReadOnlyTextArea tpDefaultFolderPattern = new ReadOnlyTextArea("${title} ${- ,edition,} (${year})");
        panelPatterns.add((Component)tpDefaultFolderPattern, "cell 3 1,growx,wmin 0");
        TmmFontHelper.changeFont((JComponent)tpDefaultFolderPattern, TmmFontHelper.L2);
        JLabel lblMovieFilename = new JLabel(BUNDLE.getString("Settings.renamer.file"));
        panelPatterns.add((Component)lblMovieFilename, "cell 1 2 2 1,alignx right");
        this.tfMovieFilename = new EnhancedTextField(IconManager.UNDO_GREY);
        this.tfMovieFilename.setIconToolTipText(BUNDLE.getString("Settings.renamer.reverttodefault"));
        this.tfMovieFilename.addIconMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MovieRenamerSettingsPanel.this.tfMovieFilename.setText("${title} ${- ,edition,} (${year}) ${videoFormat} ${audioCodec}");
            }
        });
        panelPatterns.add((Component)this.tfMovieFilename, "cell 3 2,growx");
        lblDefault = new JLabel(BUNDLE.getString("Settings.default"));
        panelPatterns.add((Component)lblDefault, "cell 1 3 2 1,alignx right");
        TmmFontHelper.changeFont((JComponent)lblDefault, TmmFontHelper.L2);
        ReadOnlyTextArea tpDefaultFilePattern = new ReadOnlyTextArea("${title} ${- ,edition,} (${year}) ${videoFormat} ${audioCodec}");
        panelPatterns.add((Component)tpDefaultFilePattern, "cell 3 3,growx,wmin 0");
        TmmFontHelper.changeFont((JComponent)tpDefaultFilePattern, TmmFontHelper.L2);
        JLabel lblRenamerHintT = new JLabel(BUNDLE.getString("Settings.movie.renamer.example"));
        panelPatterns.add((Component)lblRenamerHintT, "cell 1 4 3 1");
        JButton btnHelp = new JButton(BUNDLE.getString("tmm.help"));
        btnHelp.addActionListener(e -> {
            String url = StringEscapeUtils.unescapeHtml4((String)"https://gitlab.com/tinyMediaManager/tinyMediaManager/wikis/Movie-Settings#renamer");
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e1) {
                LOGGER.error("Wiki", (Throwable)e1);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e1.getLocalizedMessage()}));
            }
        });
        panelPatterns.add((Component)btnHelp, "cell 1 4 3 1");
        this.taWarning = new ReadOnlyTextArea();
        this.taWarning.setForeground(Color.red);
        panelPatterns.add((Component)this.taWarning, "cell 3 5,growx,wmin 0");
        JPanel panelAdvancedOptions = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblAdvancedOptions = new TmmLabel(BUNDLE.getString("Settings.advancedoptions"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelAdvancedOptions, lblAdvancedOptions, true);
        this.add((Component)collapsiblePanel, "cell 0 2,growx, wmin 0");
        this.chckbxFoldernameSpaceReplacement = new JCheckBox(BUNDLE.getString("Settings.renamer.folderspacereplacement"));
        this.chckbxFoldernameSpaceReplacement.setToolTipText(BUNDLE.getString("Settings.renamer.folderspacereplacement.hint"));
        panelAdvancedOptions.add((Component)this.chckbxFoldernameSpaceReplacement, "cell 1 0 2 1");
        this.cbFoldernameSpaceReplacement = new JComboBox<Object>(this.spaceReplacement.toArray());
        panelAdvancedOptions.add((Component)this.cbFoldernameSpaceReplacement, "cell 1 0");
        this.chckbxFilenameSpaceReplacement = new JCheckBox(BUNDLE.getString("Settings.renamer.spacereplacement"));
        this.chckbxFilenameSpaceReplacement.setToolTipText(BUNDLE.getString("Settings.renamer.spacereplacement.hint"));
        panelAdvancedOptions.add((Component)this.chckbxFilenameSpaceReplacement, "cell 1 1 2 1");
        this.cbFilenameSpaceReplacement = new JComboBox<Object>(this.spaceReplacement.toArray());
        panelAdvancedOptions.add((Component)this.cbFilenameSpaceReplacement, "cell 1 1");
        JLabel lblColonReplacement = new JLabel(BUNDLE.getString("Settings.renamer.colonreplacement"));
        panelAdvancedOptions.add((Component)lblColonReplacement, "cell 2 2");
        lblColonReplacement.setToolTipText(BUNDLE.getString("Settings.renamer.colonreplacement.hint"));
        this.cbColonReplacement = new JComboBox<Object>(this.colonReplacement.toArray());
        panelAdvancedOptions.add((Component)this.cbColonReplacement, "cell 2 2");
        this.chckbxAsciiReplacement = new JCheckBox(BUNDLE.getString("Settings.renamer.asciireplacement"));
        panelAdvancedOptions.add((Component)this.chckbxAsciiReplacement, "cell 1 3 2 1");
        JLabel lblAsciiHint = new JLabel(BUNDLE.getString("Settings.renamer.asciireplacement.hint"));
        panelAdvancedOptions.add((Component)lblAsciiHint, "cell 2 4");
        TmmFontHelper.changeFont((JComponent)lblAsciiHint, TmmFontHelper.L2);
        this.chckbxMoviesetSingleMovie = new JCheckBox(BUNDLE.getString("Settings.renamer.moviesetsinglemovie"));
        panelAdvancedOptions.add((Component)this.chckbxMoviesetSingleMovie, "cell 1 5 2 1");
        this.chckbxRemoveOtherNfos = new JCheckBox(BUNDLE.getString("Settings.renamer.removenfo"));
        panelAdvancedOptions.add((Component)this.chckbxRemoveOtherNfos, "cell 1 6 2 1");
        JPanel panelExample = new JPanel();
        panelExample.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][300lp,grow]", ""));
        TmmLabel lblExampleHeader = new TmmLabel(BUNDLE.getString("Settings.example"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelExample, lblExampleHeader, true);
        this.add((Component)collapsiblePanel, "cell 0 4, growx, wmin 0");
        JLabel lblExampleT = new JLabel(BUNDLE.getString("tmm.movie"));
        panelExample.add((Component)lblExampleT, "cell 1 0");
        this.cbMovieForPreview = new JComboBox();
        panelExample.add((Component)this.cbMovieForPreview, "cell 1 0");
        this.lblExample = new TmmLabel("", TmmFontHelper.L1);
        panelExample.add((Component)this.lblExample, "cell 1 1, wmin 0");
        DefaultEventTableModel exampleTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.exampleEventList), (TableFormat)new MovieRenamerExampleTableFormat());
        this.tableExamples = new TmmTable((TableModel)exampleTableModel);
        JScrollPane scrollPaneExamples = new JScrollPane(this.tableExamples);
        this.tableExamples.configureScrollPane(scrollPaneExamples);
        scrollPaneExamples.setVerticalScrollBarPolicy(21);
        ScrollingEventDelegator.install(scrollPaneExamples);
        panelExample.add((Component)scrollPaneExamples, "cell 1 2,grow");
        this.tableExamples.setRowHeight(35);
    }

    private void buildAndInstallMovieArray() {
        this.cbMovieForPreview.removeAllItems();
        ArrayList<Movie> allMovies = new ArrayList<Movie>(MovieList.getInstance().getMovies());
        allMovies.sort(new MovieComparator());
        for (Movie movie : allMovies) {
            MoviePreviewContainer container = new MoviePreviewContainer();
            container.movie = movie;
            this.cbMovieForPreview.addItem(container);
        }
    }

    private void createRenamerExample() {
        Movie movie = null;
        String warning = "";
        if (!this.tfMoviePath.getText().isEmpty() && !MovieRenamer.isFolderPatternUnique(this.tfMoviePath.getText())) {
            warning = BUNDLE.getString("Settings.renamer.folder.warning");
        }
        if (!warning.isEmpty()) {
            this.taWarning.setVisible(true);
            this.taWarning.setText(warning);
        } else {
            this.taWarning.setVisible(false);
        }
        if (this.cbMovieForPreview.getSelectedItem() instanceof MoviePreviewContainer) {
            MoviePreviewContainer container = (MoviePreviewContainer)this.cbMovieForPreview.getSelectedItem();
            movie = container.movie;
        }
        if (movie != null) {
            String path = "";
            String filename = "";
            if (StringUtils.isNotBlank((CharSequence)this.tfMoviePath.getText())) {
                path = MovieRenamer.createDestinationForFoldername(this.tfMoviePath.getText(), movie);
                path = Paths.get(movie.getDataSource(), path).toString();
            } else {
                path = movie.getPathNIO().toString();
            }
            if (StringUtils.isNotBlank((CharSequence)this.tfMovieFilename.getText())) {
                List<MediaFile> mediaFiles = movie.getMediaFiles(MediaFileType.VIDEO);
                if (!mediaFiles.isEmpty()) {
                    String extension = FilenameUtils.getExtension((String)mediaFiles.get(0).getFilename());
                    filename = MovieRenamer.createDestinationForFilename(this.tfMovieFilename.getText(), movie) + "." + extension;
                }
            } else {
                filename = movie.getMediaFiles(MediaFileType.VIDEO).get(0).getFilename();
            }
            try {
                this.lblExample.setText(Paths.get(path, filename).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (MovieRenamerExample example : this.exampleEventList) {
                example.createExample(movie);
            }
            TableColumnResizer.adjustColumnPreferredWidths(this.tableExamples, 7);
        } else {
            this.lblExample.setText(BUNDLE.getString("Settings.movie.renamer.nomovie"));
        }
    }

    private void checkChanges() {
        String replacement = (String)this.cbFoldernameSpaceReplacement.getSelectedItem();
        this.settings.setRenamerPathnameSpaceReplacement(replacement);
        replacement = (String)this.cbFilenameSpaceReplacement.getSelectedItem();
        this.settings.setRenamerFilenameSpaceReplacement(replacement);
        replacement = (String)this.cbColonReplacement.getSelectedItem();
        this.settings.setRenamerColonReplacement(replacement);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent arg0) {
        if (this.isShowing()) {
            this.buildAndInstallMovieArray();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addHierarchyListener(this);
    }

    @Override
    public void removeNotify() {
        this.removeHierarchyListener(this);
        super.removeNotify();
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_11 = BeanProperty.create((String)"renamerPathname");
        BeanProperty jTextFieldBeanProperty_3 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_11, (Object)this.tfMoviePath, (Property)jTextFieldBeanProperty_3);
        autoBinding_10.bind();
        BeanProperty settingsBeanProperty_12 = BeanProperty.create((String)"renamerFilename");
        BeanProperty jTextFieldBeanProperty_4 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_12, (Object)this.tfMovieFilename, (Property)jTextFieldBeanProperty_4);
        autoBinding_11.bind();
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"renamerPathnameSpaceSubstitution");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.chckbxFoldernameSpaceReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"renamerFilenameSpaceSubstitution");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, (Object)this.chckbxFilenameSpaceReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"renamerNfoCleanup");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.chckbxRemoveOtherNfos, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_5 = BeanProperty.create((String)"renamerCreateMoviesetForSingleMovie");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_5, (Object)this.chckbxMoviesetSingleMovie, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty settingsBeanProperty_7 = BeanProperty.create((String)"asciiReplacement");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_7, (Object)this.chckbxAsciiReplacement, (Property)jCheckBoxBeanProperty);
        autoBinding_5.bind();
    }

    private static class MovieRenamerExampleTableFormat
    implements TableFormat<MovieRenamerExample> {
        private MovieRenamerExampleTableFormat() {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return BUNDLE.getString("Settings.renamer.token.name");
                }
                case 1: {
                    return BUNDLE.getString("Settings.renamer.token");
                }
                case 2: {
                    return BUNDLE.getString("Settings.renamer.value");
                }
            }
            return null;
        }

        public Object getColumnValue(MovieRenamerExample baseObject, int column) {
            switch (column) {
                case 0: {
                    return baseObject.completeToken;
                }
                case 1: {
                    return baseObject.description;
                }
                case 2: {
                    return baseObject.example;
                }
            }
            return null;
        }
    }

    private static class MovieRenamerExample
    extends AbstractModelObject {
        private static final Pattern TOKEN_PATTERN = Pattern.compile("^\\$\\{(.*?)([\\}\\[;\\.]+.*)");
        private String token;
        private String completeToken;
        private String description;
        private String example = "";

        private MovieRenamerExample(String token) {
            this.token = token;
            this.completeToken = this.createCompleteToken();
            try {
                this.description = BUNDLE.getString("Settings.movie.renamer." + token);
            }
            catch (Exception e) {
                this.description = "";
            }
        }

        private String createCompleteToken() {
            String alias;
            String sourceToken;
            String result = this.token;
            Matcher matcher = TOKEN_PATTERN.matcher(this.token);
            if (matcher.find() && matcher.groupCount() > 1 && StringUtils.isNotBlank((CharSequence)(sourceToken = MovieRenamer.TOKEN_MAP.get(alias = matcher.group(1))))) {
                result = "<html>" + this.token + "<br>${" + sourceToken + matcher.group(2) + "</html>";
            }
            return result;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getExample() {
            return this.example;
        }

        public void setExample(String example) {
            this.example = example;
        }

        private void createExample(Movie movie) {
            String oldValue = this.example;
            this.example = movie == null ? "" : MovieRenamer.createDestination(this.token, movie, true);
            this.firePropertyChange("example", oldValue, this.example);
        }
    }

    private static class MovieComparator
    implements Comparator<Movie> {
        private MovieComparator() {
        }

        @Override
        public int compare(Movie arg0, Movie arg1) {
            return arg0.getTitle().compareTo(arg1.getTitle());
        }
    }

    private static class MoviePreviewContainer {
        Movie movie;

        private MoviePreviewContainer() {
        }

        public String toString() {
            return this.movie.getTitle();
        }
    }
}

