/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.DateField;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.MediaCertification;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.connector.MovieConnectors;
import org.tinymediamanager.core.movie.filenaming.MovieNfoNaming;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.JHintCheckBox;
import org.tinymediamanager.ui.components.SettingsPanelFactory;
import org.tinymediamanager.ui.components.TmmLabel;

class MovieScraperNfoSettingsPanel
extends JPanel {
    private static final long serialVersionUID = -299825914193235308L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieSettings settings = MovieModuleManager.SETTINGS;
    private JComboBox<MovieConnectors> cbNfoFormat;
    private JCheckBox cbMovieNfoFilename1;
    private JCheckBox cbMovieNfoFilename2;
    private JComboBox<CertificationStyleWrapper> cbCertificationStyle;
    private JCheckBox chckbxWriteCleanNfo;
    private JComboBox<MediaLanguages> cbNfoLanguage;
    private JComboBox<DateField> cbDatefield;
    private JHintCheckBox chckbxCreateOutline;
    private JCheckBox chckbxOutlineFirstSentence;
    private ItemListener checkBoxListener = e -> this.checkChanges();
    private ItemListener comboBoxListener = e -> this.checkChanges();

    MovieScraperNfoSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.cbNfoFormat.addItemListener(e -> {
            block2: {
                block3: {
                    if (this.cbNfoFormat.getSelectedItem() != MovieConnectors.MP) break block3;
                    for (int i = 0; i < this.cbCertificationStyle.getItemCount(); ++i) {
                        CertificationStyleWrapper wrapper = this.cbCertificationStyle.getItemAt(i);
                        if (wrapper.style != CertificationStyle.TECHNICAL) continue;
                        this.cbCertificationStyle.setSelectedItem(wrapper);
                        break block2;
                    }
                    break block2;
                }
                if (this.cbNfoFormat.getSelectedItem() != MovieConnectors.XBMC) break block2;
                for (int i = 0; i < this.cbCertificationStyle.getItemCount(); ++i) {
                    CertificationStyleWrapper wrapper = this.cbCertificationStyle.getItemAt(i);
                    if (wrapper.style != CertificationStyle.LARGE) continue;
                    this.cbCertificationStyle.setSelectedItem(wrapper);
                    break;
                }
            }
        });
        this.settings.addPropertyChangeListener(evt -> {
            if ("preset".equals(evt.getPropertyName())) {
                this.buildCheckBoxes();
                this.buildComboBoxes();
            }
        });
        this.buildCheckBoxes();
        this.buildComboBoxes();
    }

    private void buildCheckBoxes() {
        this.cbMovieNfoFilename1.removeItemListener(this.checkBoxListener);
        this.cbMovieNfoFilename2.removeItemListener(this.checkBoxListener);
        this.clearSelection(this.cbMovieNfoFilename1, this.cbMovieNfoFilename2);
        List<MovieNfoNaming> movieNfoFilenames = this.settings.getNfoFilenames();
        if (movieNfoFilenames.contains((Object)MovieNfoNaming.FILENAME_NFO)) {
            this.cbMovieNfoFilename1.setSelected(true);
        }
        if (movieNfoFilenames.contains((Object)MovieNfoNaming.MOVIE_NFO)) {
            this.cbMovieNfoFilename2.setSelected(true);
        }
        this.cbMovieNfoFilename1.addItemListener(this.checkBoxListener);
        this.cbMovieNfoFilename2.addItemListener(this.checkBoxListener);
    }

    private void clearSelection(JCheckBox ... checkBoxes) {
        for (JCheckBox checkBox : checkBoxes) {
            checkBox.setSelected(false);
        }
    }

    private void buildComboBoxes() {
        this.cbCertificationStyle.removeItemListener(this.comboBoxListener);
        this.cbCertificationStyle.removeAllItems();
        for (CertificationStyle style : CertificationStyle.values()) {
            CertificationStyleWrapper wrapper = new CertificationStyleWrapper();
            wrapper.style = style;
            this.cbCertificationStyle.addItem(wrapper);
            if (style != this.settings.getCertificationStyle()) continue;
            this.cbCertificationStyle.setSelectedItem(wrapper);
        }
        this.cbCertificationStyle.addItemListener(this.comboBoxListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[]"));
        JPanel panelNfo = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblNfoT = new TmmLabel(BUNDLE.getString("Settings.nfo"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelNfo, lblNfoT, true);
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        JLabel lblNfoFormat = new JLabel(BUNDLE.getString("Settings.nfoFormat"));
        panelNfo.add((Component)lblNfoFormat, "cell 1 0 2 1");
        this.cbNfoFormat = new JComboBox<MovieConnectors>(MovieConnectors.values());
        panelNfo.add(this.cbNfoFormat, "cell 1 0");
        JPanel panelNfoFormat = new JPanel();
        panelNfo.add((Component)panelNfoFormat, "cell 1 1 2 1");
        panelNfoFormat.setLayout((LayoutManager)new MigLayout("insets 0", "[][]", "[][]"));
        JLabel lblNfoFileNaming = new JLabel(BUNDLE.getString("Settings.nofFileNaming"));
        panelNfoFormat.add((Component)lblNfoFileNaming, "cell 0 0");
        this.cbMovieNfoFilename1 = new JCheckBox(BUNDLE.getString("Settings.moviefilename") + ".nfo");
        panelNfoFormat.add((Component)this.cbMovieNfoFilename1, "cell 1 0");
        this.cbMovieNfoFilename2 = new JCheckBox("movie.nfo");
        panelNfoFormat.add((Component)this.cbMovieNfoFilename2, "cell 1 1");
        this.chckbxWriteCleanNfo = new JCheckBox(BUNDLE.getString("Settings.writecleannfo"));
        panelNfo.add((Component)this.chckbxWriteCleanNfo, "cell 1 2 2 1");
        JLabel lblNfoDatefield = new JLabel(BUNDLE.getString("Settings.dateadded"));
        panelNfo.add((Component)lblNfoDatefield, "cell 1 4 2 1");
        this.cbDatefield = new JComboBox<DateField>(DateField.values());
        panelNfo.add(this.cbDatefield, "cell 1 4");
        JLabel lblNfoLanguage = new JLabel(BUNDLE.getString("Settings.nfolanguage"));
        panelNfo.add((Component)lblNfoLanguage, "cell 1 5 2 1");
        this.cbNfoLanguage = new JComboBox<MediaLanguages>(MediaLanguages.valuesSorted());
        panelNfo.add(this.cbNfoLanguage, "cell 1 5");
        JLabel lblNfoLanguageDesc = new JLabel(BUNDLE.getString("Settings.nfolanguage.desc"));
        panelNfo.add((Component)lblNfoLanguageDesc, "cell 2 6");
        JLabel lblCertificationStyle = new JLabel(BUNDLE.getString("Settings.certificationformat"));
        panelNfo.add((Component)lblCertificationStyle, "flowx,cell 1 7 2 1");
        this.cbCertificationStyle = new JComboBox();
        panelNfo.add(this.cbCertificationStyle, "cell 1 7");
        this.chckbxCreateOutline = new JHintCheckBox(BUNDLE.getString("Settings.createoutline"));
        this.chckbxCreateOutline.setToolTipText(BUNDLE.getString("Settings.createoutline.hint"));
        this.chckbxCreateOutline.setHintIcon(IconManager.HINT);
        panelNfo.add((Component)this.chckbxCreateOutline, "cell 1 8 2 1");
        this.chckbxOutlineFirstSentence = new JCheckBox(BUNDLE.getString("Settings.outlinefirstsentence"));
        panelNfo.add((Component)this.chckbxOutlineFirstSentence, "cell 2 9");
    }

    private void checkChanges() {
        CertificationStyleWrapper wrapper;
        this.settings.clearNfoFilenames();
        if (this.cbMovieNfoFilename1.isSelected()) {
            this.settings.addNfoFilename(MovieNfoNaming.FILENAME_NFO);
        }
        if (this.cbMovieNfoFilename2.isSelected()) {
            this.settings.addNfoFilename(MovieNfoNaming.MOVIE_NFO);
        }
        if ((wrapper = (CertificationStyleWrapper)this.cbCertificationStyle.getSelectedItem()) != null && this.settings.getCertificationStyle() != wrapper.style) {
            this.settings.setCertificationStyle(wrapper.style);
        }
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_11 = BeanProperty.create((String)"movieConnector");
        BeanProperty jComboBoxBeanProperty_1 = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_11, this.cbNfoFormat, (Property)jComboBoxBeanProperty_1);
        autoBinding_9.bind();
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"writeCleanNfo");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, (Object)this.chckbxWriteCleanNfo, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty movieSettingsBeanProperty_1 = BeanProperty.create((String)"nfoLanguage");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_1, this.cbNfoLanguage, (Property)jComboBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSettingsBeanProperty_2 = BeanProperty.create((String)"createOutline");
        BeanProperty jHintCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_2, (Object)this.chckbxCreateOutline, (Property)jHintCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty movieSettingsBeanProperty_3 = BeanProperty.create((String)"outlineFirstSentence");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_3, (Object)this.chckbxOutlineFirstSentence, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxCreateOutline, (Property)jHintCheckBoxBeanProperty, (Object)this.chckbxOutlineFirstSentence, (Property)jCheckBoxBeanProperty_1);
        autoBinding_4.bind();
        BeanProperty movieSettingsBeanProperty_4 = BeanProperty.create((String)"nfoDateAddedField");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_4, this.cbDatefield, (Property)jComboBoxBeanProperty);
        autoBinding_5.bind();
    }

    private class CertificationStyleWrapper {
        private CertificationStyle style;

        private CertificationStyleWrapper() {
        }

        public String toString() {
            String bundleTag = BUNDLE.getString("Settings.certification." + this.style.name().toLowerCase(Locale.ROOT));
            return bundleTag.replace("{}", CertificationStyle.formatCertification(MediaCertification.DE_FSK16, this.style));
        }
    }
}

