/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.observablecollections.ObservableCollections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSetSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieSetMetadataProvider;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class MovieSetChooserModel
extends AbstractModelObject {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetChooserModel.class);
    public static final MovieSetChooserModel emptyResult = new MovieSetChooserModel();
    private String name = "";
    private String posterUrl = "";
    private String fanartUrl = "";
    private String overview = "";
    private int tmdbId = 0;
    private MediaSearchResult result = null;
    private MediaMetadata metadata = null;
    private List<MovieInSet> movies = ObservableCollections.observableList(new ArrayList());
    private MediaScraper scraper;
    private boolean scraped;

    public MovieSetChooserModel(MediaSearchResult result) {
        this.result = result;
        this.setName(result.getTitle());
        this.setTmdbId(result.getIdAsInt(result.getProviderId()));
        this.setPosterUrl(result.getPosterUrl());
        try {
            List<MediaScraper> sets = MediaScraper.getMediaScrapers(ScraperType.MOVIE_SET);
            if (!sets.isEmpty()) {
                this.scraper = sets.get(0);
            }
        }
        catch (Exception e) {
            this.scraper = null;
        }
    }

    private MovieSetChooserModel() {
        this.setName(BUNDLE.getString("chooser.nothingfound"));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.firePropertyChange("name", "", name);
    }

    public void setOverview(String overview) {
        this.overview = overview;
        this.firePropertyChange("overview", "", overview);
    }

    public int getTmdbId() {
        return this.tmdbId;
    }

    public void setTmdbId(int tmdbId) {
        this.tmdbId = tmdbId;
    }

    public void setPosterUrl(String posterUrl) {
        this.posterUrl = posterUrl;
        this.firePropertyChange("posterUrl", "", posterUrl);
    }

    public void setFanartUrl(String fanartUrl) {
        this.fanartUrl = fanartUrl;
        this.firePropertyChange("fanartUrl", "", fanartUrl);
    }

    public boolean isScraped() {
        return this.scraped;
    }

    public String getPosterUrl() {
        return this.posterUrl;
    }

    public String getFanartUrl() {
        return this.fanartUrl;
    }

    public void matchWithExistingMovies() {
        List<Movie> moviesFromMovieList = MovieList.getInstance().getMovies();
        block3: for (MovieInSet mis : this.movies) {
            if (mis.tmdbId > 0) {
                for (Movie movie : moviesFromMovieList) {
                    if (movie.getTmdbId() != mis.tmdbId) continue;
                    mis.setMovie(movie);
                    break;
                }
            }
            if (mis.movie != null) continue;
            if (!MetadataUtil.isValidImdbId(mis.imdbId) && this.scraper.getMediaProvider() != null) {
                MovieSearchAndScrapeOptions options = new MovieSearchAndScrapeOptions();
                options.setTmdbId(mis.tmdbId);
                options.setLanguage(MovieModuleManager.SETTINGS.getScraperLanguage());
                try {
                    MediaScraper movieScraper = MediaScraper.getMediaScraperById("tmdb", ScraperType.MOVIE);
                    MediaMetadata md = ((IMovieMetadataProvider)movieScraper.getMediaProvider()).getMetadata(options);
                    mis.imdbId = String.valueOf(md.getId("imdb"));
                }
                catch (ScrapeException e) {
                    LOGGER.error("getMovieSet", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mis.name, "message.scrape.metadatamoviesetfailed", new String[]{":", e.getLocalizedMessage()}));
                }
                catch (MissingIdException | NothingFoundException e) {
                    LOGGER.debug("could not scrape: {}", (Object)e.getMessage());
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)mis.imdbId)) continue;
            for (Movie movie : moviesFromMovieList) {
                if (!mis.imdbId.equals(movie.getImdbId())) continue;
                mis.setMovie(movie);
                continue block3;
            }
        }
    }

    public void scrapeMetadata() {
        block10: {
            try {
                if (this.scraper.getMediaProvider() == null) break block10;
                MovieSetSearchAndScrapeOptions options = new MovieSetSearchAndScrapeOptions();
                options.setSearchResult(this.result);
                options.setTmdbId(this.result.getIdAsInt(this.result.getProviderId()));
                options.setLanguage(MovieModuleManager.SETTINGS.getScraperLanguage());
                MediaMetadata info = null;
                try {
                    info = ((IMovieSetMetadataProvider)this.scraper.getMediaProvider()).getMetadata(options);
                }
                catch (ScrapeException e) {
                    LOGGER.error("getMetadata", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieSetChooser", "message.scrape.metadatamoviesetfailed", new String[]{":", e.getLocalizedMessage()}));
                    return;
                }
                catch (MissingIdException e) {
                    LOGGER.warn("missing id for scrape");
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "MovieSetChooser", "scraper.error.missingid"));
                    return;
                }
                if (info == null) break block10;
                this.metadata = info;
                if (!info.getMediaArt(MediaArtwork.MediaArtworkType.BACKGROUND).isEmpty()) {
                    this.setFanartUrl(info.getMediaArt(MediaArtwork.MediaArtworkType.BACKGROUND).get(0).getDefaultUrl());
                }
                this.setName(info.getTitle());
                this.setOverview(info.getPlot());
                for (MediaMetadata item : info.getSubItems()) {
                    MovieInSet movie = new MovieInSet(item.getTitle());
                    try {
                        movie.setTmdbId(Integer.parseInt(item.getId("tmdb").toString()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (item.getReleaseDate() != null) {
                        movie.setReleaseDate(new SimpleDateFormat("yyyy-MM-dd").format(item.getReleaseDate()));
                    }
                    this.movies.add(movie);
                }
                Collections.sort(this.movies);
                this.matchWithExistingMovies();
                this.scraped = true;
            }
            catch (Exception e) {
                LOGGER.error("scrapeMedia", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieSetChooser", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }

    public String getOverview() {
        if (this.metadata == null) {
            return "";
        }
        return this.metadata.getPlot();
    }

    public List<MovieInSet> getMovies() {
        return this.movies;
    }

    public void startArtworkScrapeTask(MovieSet movieSet, List<MovieSetScraperMetadataConfig> config) {
        TmmTaskManager.getInstance().addUnnamedTask(new ArtworkScrapeTask(movieSet, config));
    }

    public MediaMetadata getMetadata() {
        return this.metadata;
    }

    public static class MovieInSet
    extends AbstractModelObject
    implements Comparable<MovieInSet> {
        private String name = "";
        private int tmdbId = 0;
        private String imdbId = "";
        private String releaseDate = "";
        private Movie movie = null;

        public MovieInSet(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getTmdbId() {
            return this.tmdbId;
        }

        public String getImdbId() {
            return this.imdbId;
        }

        public String getReleaseDate() {
            return this.releaseDate;
        }

        public Movie getMovie() {
            return this.movie;
        }

        public void setTmdbId(int tmdbId) {
            this.tmdbId = tmdbId;
        }

        public void setImdbId(String imdbId) {
            this.imdbId = imdbId;
        }

        public void setReleaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
        }

        public void setMovie(Movie movie) {
            this.movie = movie;
            this.firePropertyChange("movie", null, movie);
        }

        @Override
        public int compareTo(MovieInSet o) {
            return this.releaseDate.compareTo(o.releaseDate);
        }
    }

    private class ArtworkScrapeTask
    extends TmmTask {
        private MovieSet movieSetToScrape;
        private List<MovieSetScraperMetadataConfig> config;

        public ArtworkScrapeTask(MovieSet movieSet, List<MovieSetScraperMetadataConfig> config) {
            super(BUNDLE.getString("message.scrape.artwork") + " " + movieSet.getTitle(), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
            this.movieSetToScrape = movieSet;
            this.config = config;
        }

        @Override
        protected void doInBackground() {
            if (!MovieSetChooserModel.this.scraped) {
                return;
            }
            ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
            ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(MediaType.MOVIE_SET);
            options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            options.setMetadata(MovieSetChooserModel.this.metadata);
            options.setId("imdb", String.valueOf(MovieSetChooserModel.this.metadata.getId("imdb")));
            try {
                options.setTmdbId(Integer.parseInt(String.valueOf(MovieSetChooserModel.this.metadata.getId("tmdbSet"))));
            }
            catch (Exception e) {
                options.setTmdbId(0);
            }
            options.setLanguage(MovieModuleManager.SETTINGS.getImageScraperLanguage());
            options.setFanartSize(MovieModuleManager.SETTINGS.getImageFanartSize());
            options.setPosterSize(MovieModuleManager.SETTINGS.getImagePosterSize());
            for (MediaScraper artworkScraper : MovieList.getInstance().getDefaultArtworkScrapers()) {
                IMovieArtworkProvider artworkProvider = (IMovieArtworkProvider)artworkScraper.getMediaProvider();
                try {
                    artwork.addAll(artworkProvider.getArtwork(options));
                }
                catch (ScrapeException e) {
                    LOGGER.error("getArtwork", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movieSetToScrape, "message.scrape.movieartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                }
                catch (MissingIdException e) {
                    LOGGER.debug("could not get artwork: {}", (Object)e.getMessage());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)MovieSetChooserModel.this.getPosterUrl())) {
                MediaArtwork ma = new MediaArtwork(MovieSetChooserModel.this.result.getProviderId(), MediaArtwork.MediaArtworkType.POSTER);
                ma.setDefaultUrl(MovieSetChooserModel.this.getPosterUrl());
                ma.setPreviewUrl(MovieSetChooserModel.this.getPosterUrl());
                artwork.add(ma);
            }
            this.movieSetToScrape.setArtwork(artwork, this.config);
        }
    }
}

