/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import java.beans.PropertyChangeListener;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.components.tree.TmmTreeDataProvider;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;

public class MovieSetTreeDataProvider
extends TmmTreeDataProvider<TmmTreeNode> {
    private TmmTreeNode root = new TmmTreeNode(new Object(), this);
    private RuleBasedCollator stringCollator = (RuleBasedCollator)RuleBasedCollator.getInstance();
    private final PropertyChangeListener movielistPropertyChangeListener;
    private final PropertyChangeListener movieSetPropertyChangeListener;
    private final PropertyChangeListener moviePropertyChangeListener;
    private final MovieList movieList = MovieList.getInstance();

    public MovieSetTreeDataProvider() {
        this.movielistPropertyChangeListener = evt -> {
            switch (evt.getPropertyName()) {
                case "addedMovieSet": {
                    MovieSet movieSet = (MovieSet)evt.getNewValue();
                    this.addMovieSet(movieSet);
                    break;
                }
                case "removedMovieSet": {
                    MovieSet movieSet = (MovieSet)evt.getNewValue();
                    this.removeMovieSet(movieSet);
                    break;
                }
                default: {
                    this.nodeChanged(evt.getSource());
                }
            }
        };
        this.movieList.addPropertyChangeListener(this.movielistPropertyChangeListener);
        this.movieSetPropertyChangeListener = evt -> {
            switch (evt.getPropertyName()) {
                case "addedMovie": {
                    Movie movie = (Movie)evt.getNewValue();
                    this.addMovie(movie);
                    break;
                }
                case "removedMovie": {
                    Movie movie = (Movie)evt.getNewValue();
                    this.removeMovie(movie);
                    break;
                }
                default: {
                    this.nodeChanged(evt.getSource());
                }
            }
        };
        this.moviePropertyChangeListener = evt -> {
            switch (evt.getPropertyName()) {
                default: 
            }
            this.nodeChanged(evt.getSource());
        };
        this.setTreeComparator(new MovieSetComparator());
    }

    private void nodeChanged(Object source) {
        TmmTreeNode node = this.getNodeFromCache(source);
        if (node != null) {
            this.firePropertyChange("nodeChanged", null, node);
        }
    }

    @Override
    public TmmTreeNode getRoot() {
        return this.root;
    }

    @Override
    public TmmTreeNode getParent(TmmTreeNode child) {
        if (child.getUserObject() instanceof MovieSet) {
            return this.root;
        }
        if (child.getUserObject() instanceof Movie) {
            Movie movie = (Movie)child.getUserObject();
            TmmTreeNode node = this.getNodeFromCache(movie.getMovieSet());
            if (node == null && movie.getMovieSet() != null) {
                node = this.addMovieSet(movie.getMovieSet());
            }
            return node;
        }
        return null;
    }

    @Override
    public List<TmmTreeNode> getChildren(TmmTreeNode parent) {
        if (parent == this.root) {
            ArrayList<TmmTreeNode> nodes = new ArrayList<TmmTreeNode>();
            for (MovieSet movieSet : new ArrayList<MovieSet>(this.movieList.getMovieSetList())) {
                MovieSetTreeNode node = new MovieSetTreeNode((Object)movieSet, this);
                this.putNodeToCache(movieSet, node);
                nodes.add(node);
                movieSet.addPropertyChangeListener(this.movieSetPropertyChangeListener);
            }
            return nodes;
        }
        if (parent.getUserObject() instanceof MovieSet) {
            MovieSet movieSet = (MovieSet)parent.getUserObject();
            ArrayList<TmmTreeNode> nodes = new ArrayList<TmmTreeNode>();
            for (Movie movie : movieSet.getMovies()) {
                if (movie.getMovieSet() != movieSet) continue;
                MovieTreeNode node = new MovieTreeNode((Object)movie, this);
                this.putNodeToCache(movie, node);
                nodes.add(node);
            }
            return nodes;
        }
        return null;
    }

    @Override
    public boolean isLeaf(TmmTreeNode node) {
        return node.getUserObject() instanceof Movie;
    }

    @Override
    public Comparator<TmmTreeNode> getTreeComparator() {
        return super.getTreeComparator();
    }

    private TmmTreeNode addMovieSet(MovieSet movieSet) {
        TmmTreeNode cachedNode = this.getNodeFromCache(movieSet);
        if (cachedNode != null) {
            return cachedNode;
        }
        MovieSetTreeNode node = new MovieSetTreeNode((Object)movieSet, this);
        this.putNodeToCache(movieSet, node);
        this.firePropertyChange("nodeInserted", null, node);
        movieSet.addPropertyChangeListener(this.movieSetPropertyChangeListener);
        return node;
    }

    private void removeMovieSet(MovieSet movieSet) {
        TmmTreeNode cachedNode = this.removeNodeFromCache(movieSet);
        if (cachedNode == null) {
            return;
        }
        for (Movie movie : movieSet.getMovies()) {
            this.removeNodeFromCache(movie);
        }
        movieSet.removePropertyChangeListener(this.movieSetPropertyChangeListener);
        this.firePropertyChange("nodeRemoved", null, cachedNode);
    }

    private TmmTreeNode addMovie(Movie movie) {
        TmmTreeNode cachedNode = this.getNodeFromCache(movie);
        if (cachedNode != null) {
            return cachedNode;
        }
        MovieTreeNode node = new MovieTreeNode((Object)movie, this);
        this.putNodeToCache(movie, node);
        this.firePropertyChange("nodeInserted", null, node);
        movie.addPropertyChangeListener(this.moviePropertyChangeListener);
        return node;
    }

    private void removeMovie(Movie movie) {
        TmmTreeNode cachedNode = this.removeNodeFromCache(movie);
        if (cachedNode == null) {
            return;
        }
        movie.removePropertyChangeListener(this.moviePropertyChangeListener);
        this.firePropertyChange("nodeRemoved", null, cachedNode);
    }

    static class MovieTreeNode
    extends TmmTreeNode {
        private static final long serialVersionUID = -5734830011018805194L;

        public MovieTreeNode(Object userObject, TmmTreeDataProvider dataProvider) {
            super(userObject, dataProvider);
        }

        @Override
        public String toString() {
            if (this.getUserObject() instanceof Movie) {
                Movie movie = (Movie)this.getUserObject();
                return movie.getTitleSortable();
            }
            return super.toString();
        }
    }

    static class MovieSetTreeNode
    extends TmmTreeNode {
        private static final long serialVersionUID = -1316609340104597133L;

        public MovieSetTreeNode(Object userObject, TmmTreeDataProvider dataProvider) {
            super(userObject, dataProvider);
        }

        @Override
        public String toString() {
            if (this.getUserObject() instanceof MovieSet) {
                MovieSet MovieSet2 = (MovieSet)this.getUserObject();
                return MovieSet2.getTitleSortable();
            }
            return super.toString();
        }
    }

    class MovieSetComparator
    implements Comparator<TmmTreeNode> {
        MovieSetComparator() {
        }

        @Override
        public int compare(TmmTreeNode o1, TmmTreeNode o2) {
            Object userObject1 = o1.getUserObject();
            Object userObject2 = o2.getUserObject();
            if (userObject1 instanceof MovieSet && userObject2 instanceof MovieSet) {
                MovieSet movieSet1 = (MovieSet)userObject1;
                MovieSet movieSet2 = (MovieSet)userObject2;
                if (MovieSetTreeDataProvider.this.stringCollator != null) {
                    return MovieSetTreeDataProvider.this.stringCollator.compare(movieSet1.getTitleSortable().toLowerCase(Locale.ROOT), movieSet2.getTitleSortable().toLowerCase(Locale.ROOT));
                }
                return movieSet1.getTitleSortable().compareToIgnoreCase(movieSet2.getTitleSortable());
            }
            if (userObject1 instanceof Movie && userObject2 instanceof Movie) {
                Movie movie1 = (Movie)userObject1;
                Movie movie2 = (Movie)userObject2;
                if (movie1.getMovieSet() != null && movie1.getMovieSet() == movie2.getMovieSet()) {
                    List<Movie> moviesInSet = movie1.getMovieSet().getMovies();
                    return moviesInSet.indexOf(movie1) - moviesInSet.indexOf(movie2);
                }
            }
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    }
}

