/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.movie.MovieSetArtworkHelper;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;

public class MovieSetCleanupArtworkAction
extends TmmAction {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieSetCleanupArtworkAction() {
        this.putValue("Name", BUNDLE.getString("movieset.cleanupartwork"));
        this.putValue("ShortDescription", BUNDLE.getString("movieset.cleanupartwork.desc"));
        this.putValue("SmallIcon", IconManager.IMAGE);
        this.putValue("SwingLargeIconKey", IconManager.IMAGE);
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<MovieSet> selectedMovieSets = new ArrayList<MovieSet>(MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovieSets());
        if (selectedMovieSets.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        for (MovieSet movieSet : selectedMovieSets) {
            MovieSetArtworkHelper.cleanupArtwork(movieSet);
        }
    }
}

