/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.dialogs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.MainTabbedPane;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class MovieSetEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = -4446433759280691976L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetEditorDialog.class);
    private static final String ORIGINAL_IMAGE_SIZE = "originalImageSize";
    private static final String SPACER = "        ";
    private MovieList movieList = MovieList.getInstance();
    private MovieSet movieSetToEdit;
    private List<Movie> moviesInSet = ObservableCollections.observableList(new ArrayList());
    private List<Movie> removedMovies = new ArrayList<Movie>();
    private List<MediaScraper> artworkScrapers = new ArrayList<MediaScraper>();
    private boolean continueQueue = true;
    private boolean navigateBack = false;
    private int queueIndex;
    private int queueSize;
    private JTextField tfName;
    private JTable tableMovies;
    private ImageLabel lblPoster;
    private ImageLabel lblFanart;
    private JTextPane tpOverview;
    private JTextField tfTmdbId;
    private ImageLabel lblLogo;
    private ImageLabel lblClearlogo;
    private ImageLabel lblBanner;
    private ImageLabel lblClearart;
    private ImageLabel lblDisc;
    private ImageLabel lblThumb;
    private JTextField tfPoster;
    private JTextField tfFanart;
    private JTextField tfLogo;
    private JTextField tfClearLogo;
    private JTextField tfBanner;
    private JTextField tfClearArt;
    private JTextField tfThumb;
    private JTextField tfDisc;

    public MovieSetEditorDialog(MovieSet movieSet, int queueIndex, int queueSize) {
        super(BUNDLE.getString("movieset.edit") + (queueSize > 1 ? " " + (queueIndex + 1) + "/" + queueSize : ""), "movieSetEditor");
        this.movieSetToEdit = movieSet;
        this.queueIndex = queueIndex;
        this.queueSize = queueSize;
        try {
            ArrayList<String> enabledScrapers = new ArrayList<String>();
            if (MovieModuleManager.SETTINGS.getArtworkScrapers().contains("tmdb")) {
                enabledScrapers.add("tmdb");
            }
            if (MovieModuleManager.SETTINGS.getArtworkScrapers().contains("fanarttv")) {
                enabledScrapers.add("fanarttv");
            }
            this.artworkScrapers.addAll(this.movieList.getArtworkScrapers(enabledScrapers));
        }
        catch (Exception e2) {
            LOGGER.warn("error getting IMediaArtworkProvider - {}", (Object)e2.getMessage());
        }
        MainTabbedPane tabbedPane = new MainTabbedPane(){
            private static final long serialVersionUID = 71548865608767532L;

            @Override
            public void updateUI() {
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        this.getContentPane().add((Component)tabbedPane, "Center");
        JPanel panelContent = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.details"), panelContent);
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][400lp,grow 200][150lp:200lp,grow 50]", "[][][150lp:200lp,grow][20lp:n][][][50lp:100lp,grow]"));
        TmmLabel lblName = new TmmLabel(BUNDLE.getString("movieset.title"));
        panelContent.add((Component)lblName, "cell 0 0,alignx right");
        this.tfName = new JTextField();
        panelContent.add((Component)this.tfName, "cell 1 0,growx,aligny top");
        this.tfName.setColumns(10);
        this.lblPoster = new ImageLabel();
        this.lblPoster.setCursor(Cursor.getPredefinedCursor(12));
        this.lblPoster.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, MovieSetEditorDialog.this.extractIds(), ImageChooserDialog.ImageType.POSTER, MovieSetEditorDialog.this.artworkScrapers, MovieSetEditorDialog.this.lblPoster, null, null, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                MovieSetEditorDialog.this.updateArtworkUrl(MovieSetEditorDialog.this.lblPoster, MovieSetEditorDialog.this.tfPoster);
            }
        });
        panelContent.add((Component)new TmmLabel(BUNDLE.getString("mediafiletype.poster")), "cell 2 0");
        LinkLabel lblPosterSize = new LinkLabel();
        panelContent.add((Component)lblPosterSize, "cell 2 0");
        FlatButton btnDeletePoster = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeletePoster.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeletePoster.addActionListener(e -> {
            this.lblPoster.clearImage();
            this.tfPoster.setText("");
        });
        panelContent.add((Component)btnDeletePoster, "cell 2 0");
        panelContent.add((Component)this.lblPoster, "cell 2 1 1 4,grow");
        this.lblPoster.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblPosterSize, this.lblPoster, MediaFileType.POSTER));
        TmmLabel lblTmdbid = new TmmLabel(BUNDLE.getString("metatag.tmdb"));
        panelContent.add((Component)lblTmdbid, "cell 0 1,alignx right");
        this.tfTmdbId = new JTextField();
        panelContent.add((Component)this.tfTmdbId, "flowx,cell 1 1,aligny center");
        this.tfTmdbId.setColumns(10);
        TmmLabel lblOverview = new TmmLabel(BUNDLE.getString("metatag.plot"));
        panelContent.add((Component)lblOverview, "cell 0 2,alignx right,aligny top");
        JScrollPane scrollPaneOverview = new JScrollPane();
        panelContent.add((Component)scrollPaneOverview, "cell 1 2,grow");
        this.tpOverview = new JTextPane();
        this.tpOverview.setForeground(UIManager.getColor("TextField.foreground"));
        scrollPaneOverview.setViewportView(this.tpOverview);
        TmmLabel lblMovies = new TmmLabel(BUNDLE.getString("tmm.movies"));
        panelContent.add((Component)lblMovies, "flowy,cell 0 4,alignx right,aligny top");
        JScrollPane scrollPaneMovies = new JScrollPane();
        panelContent.add((Component)scrollPaneMovies, "cell 1 4 1 3,grow");
        this.tableMovies = new TmmTable();
        scrollPaneMovies.setViewportView(this.tableMovies);
        this.lblFanart = new ImageLabel();
        this.lblFanart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblFanart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, MovieSetEditorDialog.this.extractIds(), ImageChooserDialog.ImageType.FANART, MovieSetEditorDialog.this.artworkScrapers, MovieSetEditorDialog.this.lblFanart, null, null, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                MovieSetEditorDialog.this.updateArtworkUrl(MovieSetEditorDialog.this.lblFanart, MovieSetEditorDialog.this.tfFanart);
            }
        });
        panelContent.add((Component)new TmmLabel(BUNDLE.getString("mediafiletype.fanart")), "cell 2 5");
        LinkLabel lblFanartSize = new LinkLabel();
        panelContent.add((Component)lblFanartSize, "cell 2 5");
        FlatButton btnDeleteFanart = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteFanart.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeleteFanart.addActionListener(e -> {
            this.lblFanart.clearImage();
            this.tfFanart.setText("");
        });
        panelContent.add((Component)btnDeleteFanart, "cell 2 5");
        panelContent.add((Component)this.lblFanart, "cell 2 6,grow");
        this.lblFanart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblFanartSize, this.lblFanart, MediaFileType.FANART));
        JButton btnSearchTmdbId = new JButton("");
        btnSearchTmdbId.setAction(new SearchIdAction());
        panelContent.add((Component)btnSearchTmdbId, "cell 1 1");
        JButton btnRemoveMovie = new JButton("");
        btnRemoveMovie.setAction(new RemoveMovieAction());
        panelContent.add((Component)btnRemoveMovie, "cell 0 4,alignx right,aligny top");
        JPanel artworkPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.extraartwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[200lp:300lp,grow][20lp:n][200lp:300lp,grow][20lp:n][100lp:200lp,grow]", "[][100lp:125lp,grow][20lp:n][][100lp:125lp,grow][20lp:n][][100lp:150lp,grow]"));
        TmmLabel lblLogoT = new TmmLabel(BUNDLE.getString("mediafiletype.logo"));
        artworkPanel.add((Component)lblLogoT, "cell 0 0");
        LinkLabel lblLogoSize = new LinkLabel();
        artworkPanel.add((Component)lblLogoSize, "cell 0 0");
        FlatButton btnDeleteLogo = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteLogo.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeleteLogo.addActionListener(e -> {
            this.lblLogo.clearImage();
            this.tfLogo.setText("");
        });
        artworkPanel.add((Component)btnDeleteLogo, "cell 0 0");
        this.lblLogo = new ImageLabel();
        this.lblLogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, MovieSetEditorDialog.this.extractIds(), ImageChooserDialog.ImageType.LOGO, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblLogo, null, null, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                MovieSetEditorDialog.this.updateArtworkUrl(MovieSetEditorDialog.this.lblLogo, MovieSetEditorDialog.this.tfLogo);
            }
        });
        this.lblLogo.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblLogo, "cell 0 1,grow");
        this.lblLogo.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblLogoSize, this.lblLogo, MediaFileType.LOGO));
        TmmLabel lblClearlogoT = new TmmLabel(BUNDLE.getString("mediafiletype.clearlogo"));
        artworkPanel.add((Component)lblClearlogoT, "cell 2 0");
        LinkLabel lblClearlogoSize = new LinkLabel();
        artworkPanel.add((Component)lblClearlogoSize, "cell 2 0");
        FlatButton btnDeleteClearLogo = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteClearLogo.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeleteClearLogo.addActionListener(e -> {
            this.lblClearlogo.clearImage();
            this.tfClearLogo.setText("");
        });
        artworkPanel.add((Component)btnDeleteClearLogo, "cell 2 0");
        this.lblClearlogo = new ImageLabel();
        this.lblClearlogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, MovieSetEditorDialog.this.extractIds(), ImageChooserDialog.ImageType.CLEARLOGO, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblClearlogo, null, null, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
            }
        });
        this.lblClearlogo.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblClearlogo, "cell 2 1,grow");
        this.lblClearlogo.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblClearlogoSize, this.lblClearlogo, MediaFileType.CLEARLOGO));
        TmmLabel lblBannerT = new TmmLabel(BUNDLE.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "cell 0 3");
        LinkLabel lblBannerSize = new LinkLabel();
        artworkPanel.add((Component)lblBannerSize, "cell 0 3");
        FlatButton btnDeleteBanner = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteBanner.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeleteBanner.addActionListener(e -> {
            this.lblBanner.clearImage();
            this.tfBanner.setText("");
        });
        artworkPanel.add((Component)btnDeleteBanner, "cell 0 3");
        this.lblBanner = new ImageLabel();
        this.lblBanner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, MovieSetEditorDialog.this.extractIds(), ImageChooserDialog.ImageType.BANNER, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblBanner, null, null, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                MovieSetEditorDialog.this.updateArtworkUrl(MovieSetEditorDialog.this.lblBanner, MovieSetEditorDialog.this.tfBanner);
            }
        });
        this.lblBanner.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblBanner, "cell 0 4 3 1,grow");
        this.lblBanner.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblBannerSize, this.lblBanner, MediaFileType.BANNER));
        TmmLabel lblClearartT = new TmmLabel(BUNDLE.getString("mediafiletype.clearart"));
        artworkPanel.add((Component)lblClearartT, "cell 0 6");
        LinkLabel lblClearartSize = new LinkLabel();
        artworkPanel.add((Component)lblClearartSize, "cell 0 6");
        FlatButton btnDeleteClearart = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteClearart.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeleteClearart.addActionListener(e -> {
            this.lblClearart.clearImage();
            this.tfClearArt.setText("");
        });
        artworkPanel.add((Component)btnDeleteClearart, "cell 0 6");
        this.lblClearart = new ImageLabel();
        this.lblClearart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, MovieSetEditorDialog.this.extractIds(), ImageChooserDialog.ImageType.CLEARART, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblClearart, null, null, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                MovieSetEditorDialog.this.updateArtworkUrl(MovieSetEditorDialog.this.lblClearart, MovieSetEditorDialog.this.tfClearArt);
            }
        });
        this.lblClearart.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblClearart, "cell 0 7,grow");
        this.lblClearart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblClearartSize, this.lblClearart, MediaFileType.CLEARART));
        TmmLabel lblThumbT = new TmmLabel("Thumb");
        artworkPanel.add((Component)lblThumbT, "cell 2 6");
        LinkLabel lblThumbSize = new LinkLabel();
        artworkPanel.add((Component)lblThumbSize, "cell 2 6");
        FlatButton btnDeleteThumb = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteThumb.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeleteThumb.addActionListener(e -> {
            this.lblThumb.clearImage();
            this.tfThumb.setText("");
        });
        artworkPanel.add((Component)btnDeleteThumb, "cell 2 6");
        this.lblThumb = new ImageLabel();
        this.lblThumb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, MovieSetEditorDialog.this.extractIds(), ImageChooserDialog.ImageType.THUMB, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblThumb, null, null, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                MovieSetEditorDialog.this.updateArtworkUrl(MovieSetEditorDialog.this.lblThumb, MovieSetEditorDialog.this.tfThumb);
            }
        });
        this.lblThumb.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblThumb, "cell 2 7,grow");
        this.lblThumb.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblThumbSize, this.lblThumb, MediaFileType.THUMB));
        TmmLabel lblDiscT = new TmmLabel("Disc");
        artworkPanel.add((Component)lblDiscT, "cell 4 6");
        LinkLabel lblDiscSize = new LinkLabel();
        artworkPanel.add((Component)lblDiscSize, "cell 4 6");
        FlatButton btnDeleteDisc = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteDisc.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeleteDisc.addActionListener(e -> {
            this.lblDisc.clearImage();
            this.tfDisc.setText("");
        });
        artworkPanel.add((Component)btnDeleteDisc, "cell 4 6");
        this.lblDisc = new ImageLabel();
        this.lblDisc.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieSetEditorDialog.this, MovieSetEditorDialog.this.extractIds(), ImageChooserDialog.ImageType.DISC, MovieSetEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieSetEditorDialog.this.lblDisc, null, null, MediaType.MOVIE_SET);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                MovieSetEditorDialog.this.updateArtworkUrl(MovieSetEditorDialog.this.lblDisc, MovieSetEditorDialog.this.tfDisc);
            }
        });
        this.lblDisc.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblDisc, "cell 4 7,grow");
        this.lblDisc.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblDiscSize, this.lblDisc, MediaFileType.DISC));
        JPanel artworkAndTrailerPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("edit.artwork"), null, artworkAndTrailerPanel, null);
        artworkAndTrailerPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][][][][][]"));
        TmmLabel lblPosterT = new TmmLabel(BUNDLE.getString("mediafiletype.poster"));
        artworkAndTrailerPanel.add((Component)lblPosterT, "cell 0 0,alignx right");
        this.tfPoster = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfPoster, "cell 1 0,growx");
        TmmLabel lblFanartT = new TmmLabel(BUNDLE.getString("mediafiletype.fanart"));
        artworkAndTrailerPanel.add((Component)lblFanartT, "cell 0 1,alignx right");
        this.tfFanart = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfFanart, "cell 1 1,growx");
        lblLogoT = new TmmLabel(BUNDLE.getString("mediafiletype.logo"));
        artworkAndTrailerPanel.add((Component)lblLogoT, "cell 0 2,alignx right");
        this.tfLogo = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfLogo, "cell 1 2,growx");
        TmmLabel lblClearLogoT = new TmmLabel(BUNDLE.getString("mediafiletype.clearlogo"));
        artworkAndTrailerPanel.add((Component)lblClearLogoT, "cell 0 3,alignx right");
        this.tfClearLogo = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfClearLogo, "cell 1 3,growx");
        lblBannerT = new TmmLabel(BUNDLE.getString("mediafiletype.banner"));
        artworkAndTrailerPanel.add((Component)lblBannerT, "cell 0 4,alignx right");
        this.tfBanner = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfBanner, "cell 1 4,growx");
        TmmLabel lblClearArtT = new TmmLabel(BUNDLE.getString("mediafiletype.clearart"));
        artworkAndTrailerPanel.add((Component)lblClearArtT, "cell 0 5,alignx right");
        this.tfClearArt = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfClearArt, "cell 1 5,growx");
        lblThumbT = new TmmLabel(BUNDLE.getString("mediafiletype.thumb"));
        artworkAndTrailerPanel.add((Component)lblThumbT, "cell 0 6,alignx right");
        this.tfThumb = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfThumb, "cell 1 6,growx");
        lblDiscT = new TmmLabel(BUNDLE.getString("mediafiletype.disc"));
        artworkAndTrailerPanel.add((Component)lblDiscT, "cell 0 7,alignx trailing");
        this.tfDisc = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfDisc, "cell 1 7,growx");
        if (queueSize > 1) {
            JButton btnAbort = new JButton(new AbortAction());
            this.addButton(btnAbort);
            if (queueIndex > 0) {
                JButton backButton = new JButton(new NavigateBackAction());
                this.addButton(backButton);
            }
        }
        JButton btnCancel = new JButton(new CancelAction());
        this.addButton(btnCancel);
        JButton btnOk = new JButton(new OkAction());
        this.addDefaultButton(btnOk);
        this.tfName.setText(this.movieSetToEdit.getTitle());
        this.tfTmdbId.setText(String.valueOf(this.movieSetToEdit.getTmdbId()));
        this.tpOverview.setText(this.movieSetToEdit.getPlot());
        this.moviesInSet.addAll(this.movieSetToEdit.getMovies());
        this.setArtworkPath(MediaFileType.POSTER, this.lblPoster);
        this.setArtworkPath(MediaFileType.FANART, this.lblFanart);
        this.setArtworkPath(MediaFileType.BANNER, this.lblBanner);
        this.setArtworkPath(MediaFileType.LOGO, this.lblLogo);
        this.setArtworkPath(MediaFileType.CLEARLOGO, this.lblClearlogo);
        this.setArtworkPath(MediaFileType.CLEARART, this.lblClearart);
        this.setArtworkPath(MediaFileType.THUMB, this.lblThumb);
        this.setArtworkPath(MediaFileType.DISC, this.lblDisc);
        this.tfPoster.setText(this.movieSetToEdit.getArtworkUrl(MediaFileType.POSTER));
        this.tfFanart.setText(this.movieSetToEdit.getArtworkUrl(MediaFileType.FANART));
        this.tfLogo.setText(this.movieSetToEdit.getArtworkUrl(MediaFileType.LOGO));
        this.tfClearLogo.setText(this.movieSetToEdit.getArtworkUrl(MediaFileType.CLEARLOGO));
        this.tfClearArt.setText(this.movieSetToEdit.getArtworkUrl(MediaFileType.CLEARART));
        this.tfThumb.setText(this.movieSetToEdit.getArtworkUrl(MediaFileType.THUMB));
        this.tfDisc.setText(this.movieSetToEdit.getArtworkUrl(MediaFileType.DISC));
        this.tfBanner.setText(this.movieSetToEdit.getArtworkUrl(MediaFileType.BANNER));
        this.bindingGroup = this.initDataBindings();
        this.tableMovies.getTableHeader().getColumnModel().getColumn(0).setHeaderValue(BUNDLE.getString("metatag.name"));
        int width = this.tableMovies.getFontMetrics(this.tableMovies.getFont()).stringWidth(" 2000");
        int titleWidth = this.tableMovies.getFontMetrics(this.tableMovies.getFont()).stringWidth(BUNDLE.getString("metatag.year"));
        if (titleWidth > width) {
            width = titleWidth;
        }
        this.tableMovies.getTableHeader().getColumnModel().getColumn(1).setPreferredWidth(width);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(1).setMinWidth(width);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(1).setMaxWidth((int)((double)width * 1.5));
        this.tableMovies.getTableHeader().getColumnModel().getColumn(1).setHeaderValue(BUNDLE.getString("metatag.year"));
        this.tableMovies.getTableHeader().getColumnModel().getColumn(2).setPreferredWidth(70);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(2).setMinWidth(70);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(2).setMaxWidth(85);
        this.tableMovies.getTableHeader().getColumnModel().getColumn(2).setHeaderValue(BUNDLE.getString("metatag.watched"));
    }

    private Map<String, Object> extractIds() {
        HashMap<String, Object> ids = new HashMap<String, Object>(this.movieSetToEdit.getIds());
        try {
            ids.put("tmdbSet", Integer.parseInt(this.tfTmdbId.getText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ids;
    }

    private void updateArtworkUrl(ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isNotBlank((CharSequence)imageLabel.getImageUrl())) {
            textField.setText(imageLabel.getImageUrl());
        }
    }

    private void setArtworkPath(MediaFileType type, ImageLabel imageLabel) {
        if (StringUtils.isNotBlank((CharSequence)this.movieSetToEdit.getArtworkFilename(type))) {
            imageLabel.setImagePath(this.movieSetToEdit.getArtworkFilename(type));
        } else {
            imageLabel.setImageUrl(this.movieSetToEdit.getArtworkUrl(type));
        }
    }

    private void processArtwork(MediaFileType type, ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{imageLabel.getImagePath(), imageLabel.getImageUrl()}) && StringUtils.isNotBlank((CharSequence)this.movieSetToEdit.getArtworkFilename(type))) {
            this.movieSetToEdit.removeArtworkUrl(type);
            this.movieSetToEdit.deleteMediaFiles(type);
        }
        if (StringUtils.isNotEmpty((CharSequence)textField.getText()) && !textField.getText().equals(this.movieSetToEdit.getArtworkUrl(type))) {
            this.movieSetToEdit.setArtworkUrl(textField.getText(), type);
        } else if (StringUtils.isEmpty((CharSequence)textField.getText())) {
            this.movieSetToEdit.removeArtworkUrl(type);
        }
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    public boolean isContinueQueue() {
        return this.continueQueue;
    }

    public boolean isNavigateBack() {
        return this.navigateBack;
    }

    protected BindingGroup initDataBindings() {
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.moviesInSet, (JTable)this.tableMovies);
        BeanProperty movieBeanProperty = BeanProperty.create((String)"title");
        jTableBinding.addColumnBinding((Property)movieBeanProperty).setEditable(false);
        BeanProperty movieBeanProperty_1 = BeanProperty.create((String)"year");
        jTableBinding.addColumnBinding((Property)movieBeanProperty_1).setEditable(false);
        BeanProperty movieBeanProperty_2 = BeanProperty.create((String)"watched");
        jTableBinding.addColumnBinding((Property)movieBeanProperty_2).setEditable(false).setColumnClass(Boolean.class);
        jTableBinding.setEditable(false);
        jTableBinding.bind();
        BindingGroup bindingGroup = new BindingGroup();
        bindingGroup.addBinding((Binding)jTableBinding);
        return bindingGroup;
    }

    private void setImageSizeAndCreateLink(LinkLabel lblSize, ImageLabel imageLabel, MediaFileType type) {
        TmmUIHelper.createLinkForImage(lblSize, imageLabel);
        if (imageLabel.getOriginalImageSize().width == 0 && imageLabel.getOriginalImageSize().height == 0) {
            lblSize.setText("");
            return;
        }
        Dimension dimension = this.movieSetToEdit.getArtworkDimension(type);
        if (dimension.width == 0 && dimension.height == 0) {
            lblSize.setText(imageLabel.getOriginalImageSize().width + "x" + imageLabel.getOriginalImageSize().height);
        } else {
            lblSize.setText(dimension.width + "x" + dimension.height);
        }
    }

    private class SearchIdAction
    extends AbstractAction {
        private static final long serialVersionUID = -8980803676368394987L;

        SearchIdAction() {
            this.putValue("Name", BUNDLE.getString("movieset.tmdb.find"));
            this.putValue("ShortDescription", BUNDLE.getString("movieset.tmdb.desc"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                MediaScraper scraper = MediaScraper.getMediaScraperById("tmdb", ScraperType.MOVIE);
                IMovieMetadataProvider mp = (IMovieMetadataProvider)scraper.getMediaProvider();
                for (Movie movie : MovieSetEditorDialog.this.moviesInSet) {
                    if (!Utils.isValidImdbId(movie.getImdbId()) && movie.getTmdbId() <= 0) continue;
                    MovieSearchAndScrapeOptions options = new MovieSearchAndScrapeOptions();
                    options.setTmdbId(movie.getTmdbId());
                    options.setImdbId(movie.getImdbId());
                    options.setLanguage(MovieModuleManager.SETTINGS.getScraperLanguage());
                    try {
                        MediaMetadata md = mp.getMetadata(options);
                        if ((Integer)md.getId("tmdbSet") <= 0) continue;
                        MovieSetEditorDialog.this.tfTmdbId.setText(String.valueOf(md.getId("tmdbSet")));
                        break;
                    }
                    catch (ScrapeException ex) {
                        LOGGER.error("getMetadata", (Throwable)ex);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieSetChooser", "message.scrape.metadatamoviesetfailed", new String[]{":", ex.getLocalizedMessage()}));
                    }
                    catch (MissingIdException ex) {
                        LOGGER.warn("missing id for scrape");
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "MovieSetChooser", "scraper.error.missingid"));
                    }
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, BUNDLE.getString("movieset.tmdb.error"));
            }
        }
    }

    private class NavigateBackAction
    extends AbstractAction {
        private static final long serialVersionUID = -1652218154720642310L;

        public NavigateBackAction() {
            this.putValue("Name", BUNDLE.getString("Button.back"));
            this.putValue("SmallIcon", IconManager.BACK_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieSetEditorDialog.this.navigateBack = true;
            MovieSetEditorDialog.this.setVisible(false);
        }
    }

    private class AbortAction
    extends AbstractAction {
        private static final long serialVersionUID = 1215596133205394653L;

        AbortAction() {
            this.putValue("Name", BUNDLE.getString("Button.abortqueue"));
            this.putValue("ShortDescription", BUNDLE.getString("Button.abortqueue"));
            this.putValue("SmallIcon", IconManager.STOP_INV);
            this.putValue("SwingLargeIconKey", IconManager.STOP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieSetEditorDialog.this.continueQueue = false;
            MovieSetEditorDialog.this.setVisible(false);
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -6214112833170817002L;

        CancelAction() {
            this.putValue("Name", BUNDLE.getString("Button.cancel"));
            this.putValue("ShortDescription", BUNDLE.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieSetEditorDialog.this.setVisible(false);
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = -7322270015667230646L;

        OkAction() {
            this.putValue("Name", BUNDLE.getString("Button.save"));
            this.putValue("ShortDescription", BUNDLE.getString("Button.save"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieSetEditorDialog.this.movieSetToEdit.setTitle(MovieSetEditorDialog.this.tfName.getText());
            MovieSetEditorDialog.this.movieSetToEdit.setPlot(MovieSetEditorDialog.this.tpOverview.getText());
            MovieSetEditorDialog.this.processArtwork(MediaFileType.POSTER, MovieSetEditorDialog.this.lblPoster, MovieSetEditorDialog.this.tfPoster);
            MovieSetEditorDialog.this.processArtwork(MediaFileType.FANART, MovieSetEditorDialog.this.lblFanart, MovieSetEditorDialog.this.tfFanart);
            MovieSetEditorDialog.this.processArtwork(MediaFileType.LOGO, MovieSetEditorDialog.this.lblLogo, MovieSetEditorDialog.this.tfLogo);
            MovieSetEditorDialog.this.processArtwork(MediaFileType.CLEARLOGO, MovieSetEditorDialog.this.lblClearlogo, MovieSetEditorDialog.this.tfClearLogo);
            MovieSetEditorDialog.this.processArtwork(MediaFileType.BANNER, MovieSetEditorDialog.this.lblBanner, MovieSetEditorDialog.this.tfBanner);
            MovieSetEditorDialog.this.processArtwork(MediaFileType.CLEARART, MovieSetEditorDialog.this.lblClearart, MovieSetEditorDialog.this.tfClearArt);
            MovieSetEditorDialog.this.processArtwork(MediaFileType.THUMB, MovieSetEditorDialog.this.lblThumb, MovieSetEditorDialog.this.tfThumb);
            MovieSetEditorDialog.this.processArtwork(MediaFileType.DISC, MovieSetEditorDialog.this.lblDisc, MovieSetEditorDialog.this.tfDisc);
            for (int i = MovieSetEditorDialog.this.movieSetToEdit.getMovies().size() - 1; i >= 0; --i) {
                Movie movie = MovieSetEditorDialog.this.movieSetToEdit.getMovies().get(i);
                if (MovieSetEditorDialog.this.moviesInSet.contains(movie)) continue;
                movie.setMovieSet(null);
                movie.writeNFO();
                movie.saveToDb();
                MovieSetEditorDialog.this.movieSetToEdit.removeMovie(movie, true);
            }
            for (Movie movie : MovieSetEditorDialog.this.moviesInSet) {
                movie.saveToDb();
            }
            for (Movie movie : MovieSetEditorDialog.this.removedMovies) {
                movie.removeFromMovieSet();
                movie.saveToDb();
                movie.writeNFO();
                MovieSetEditorDialog.this.movieSetToEdit.removeMovie(movie, true);
            }
            MovieList.getInstance().sortMoviesInMovieSet(MovieSetEditorDialog.this.movieSetToEdit);
            for (Movie movie : MovieSetEditorDialog.this.moviesInSet) {
                movie.writeNFO();
            }
            int tmdbId = 0;
            try {
                tmdbId = Integer.parseInt(MovieSetEditorDialog.this.tfTmdbId.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            MovieSetEditorDialog.this.movieSetToEdit.setTmdbId(tmdbId);
            MovieSetEditorDialog.this.movieSetToEdit.saveToDb();
            MovieSetEditorDialog.this.setVisible(false);
        }
    }

    private class RemoveMovieAction
    extends AbstractAction {
        private static final long serialVersionUID = 8013039811395731218L;

        RemoveMovieAction() {
            this.putValue("SwingLargeIconKey", IconManager.REMOVE_INV);
            this.putValue("ShortDescription", BUNDLE.getString("movieset.movie.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MovieSetEditorDialog.this.moviesInSet.isEmpty()) {
                return;
            }
            int row = MovieSetEditorDialog.this.tableMovies.getSelectedRow();
            if (row > -1) {
                Movie movie = (Movie)MovieSetEditorDialog.this.moviesInSet.get(row);
                MovieSetEditorDialog.this.moviesInSet.remove(row);
                MovieSetEditorDialog.this.removedMovies.add(movie);
            }
        }
    }
}

