/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.moviesets.filters.AbstractCheckComboBoxMovieSetUIFilter;

public class MovieSetDatasourceFilter
extends AbstractCheckComboBoxMovieSetUIFilter<String> {
    private MovieSettings movieSettings = MovieModuleManager.SETTINGS;

    public MovieSetDatasourceFilter() {
        this.buildAndInstallDatasourceArray();
        PropertyChangeListener propertyChangeListener = evt -> this.buildAndInstallDatasourceArray();
        this.movieSettings.addPropertyChangeListener("dataSource", propertyChangeListener);
    }

    @Override
    public String getId() {
        return "movieDatasource";
    }

    @Override
    public boolean accept(MovieSet movieSet, List<Movie> movies) {
        List datasources = this.checkComboBox.getSelectedItems();
        for (Movie movie : movies) {
            if (!datasources.contains(movie.getDataSource())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.datasource"));
    }

    private void buildAndInstallDatasourceArray() {
        ArrayList<String> datasources = new ArrayList<String>(this.movieSettings.getMovieDataSource());
        Collections.sort(datasources);
        this.setValues(datasources);
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

