/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.panels;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.ColumnLayout;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.moviesets.MovieInMovieSetTableFormat;
import org.tinymediamanager.ui.moviesets.MovieSetSelectionModel;

public class MovieSetInformationPanel
extends JPanel {
    private static final long serialVersionUID = -8166784589262658147L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetInformationPanel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final String ORIGINAL_IMAGE_SIZE = "originalImageSize";
    private JLabel lblMovieSetName;
    private ImageLabel lblFanart;
    private JLabel lblFanartSize;
    private ImageLabel lblPoster;
    private JLabel lblPosterSize;
    private JTextArea taOverview;
    private TmmTable tableAssignedMovies;
    private final MovieSetSelectionModel selectionModel;
    private final EventList<Movie> movieEventList;

    public MovieSetInformationPanel(MovieSetSelectionModel setSelectionModel) {
        this.selectionModel = setSelectionModel;
        this.movieEventList = new ObservableElementList((EventList)GlazedListsSwing.swingThreadProxyList((EventList)new BasicEventList()), GlazedLists.beanConnector(Movie.class));
        this.initComponents();
        this.initDataBindings();
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != MovieSetSelectionModel.class) {
                return;
            }
            MovieSetSelectionModel model = (MovieSetSelectionModel)source;
            if ("selectedMovieSet".equals(property) || "mediaFiles".equals(property) || "movies".equals(property)) {
                this.movieEventList.clear();
                this.movieEventList.addAll(this.selectionModel.getSelectedMovieSet().getMovies());
                this.setFanart(model.getSelectedMovieSet());
                this.setPoster(model.getSelectedMovieSet());
            }
        };
        this.selectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[100lp:100lp,grow][300lp:300lp,grow 250]", "[grow]"));
        JPanel panelLeft = new JPanel();
        panelLeft.setLayout(new ColumnLayout());
        this.add((Component)panelLeft, "cell 0 0,grow");
        this.lblPoster = new ImageLabel(false, false, true);
        this.lblPoster.setDesiredAspectRatio(0.6666667f);
        this.lblPoster.setCursor(Cursor.getPredefinedCursor(12));
        panelLeft.add(this.lblPoster);
        this.lblPoster.enableLightbox();
        this.lblPosterSize = new JLabel(BUNDLE.getString("mediafiletype.poster"));
        panelLeft.add(this.lblPosterSize);
        panelLeft.add(Box.createVerticalStrut(20));
        this.lblFanart = new ImageLabel(false, false, true);
        this.lblFanart.setDesiredAspectRatio(1.7777778f);
        this.lblFanart.setCursor(Cursor.getPredefinedCursor(12));
        panelLeft.add(this.lblFanart);
        this.lblFanart.enableLightbox();
        this.lblFanartSize = new JLabel(BUNDLE.getString("mediafiletype.fanart"));
        panelLeft.add(this.lblFanartSize);
        panelLeft.add(Box.createVerticalStrut(20));
        JPanel panelRight = new JPanel();
        this.add((Component)panelRight, "cell 1 0,grow");
        panelRight.setLayout((LayoutManager)new MigLayout("insets 0 n n n, hidemode 2", "[450lp,grow]", "[][shrink 0][][250lp:350lp,grow][][shrink 0][][350lp,grow]"));
        this.lblMovieSetName = new JLabel("");
        panelRight.add((Component)this.lblMovieSetName, "cell 0 0, wmin 0");
        TmmFontHelper.changeFont(this.lblMovieSetName, 1.33, 1);
        panelRight.add((Component)new JSeparator(), "cell 0 1,growx");
        JLabel lblPlot = new JLabel(BUNDLE.getString("metatag.plot"));
        panelRight.add((Component)lblPlot, "cell 0 2");
        TmmFontHelper.changeFont((JComponent)lblPlot, 1);
        JScrollPane scrollPaneOverview = new JScrollPane();
        panelRight.add((Component)scrollPaneOverview, "cell 0 3,grow");
        this.taOverview = new ReadOnlyTextArea();
        this.taOverview.setBorder(null);
        scrollPaneOverview.setViewportView(this.taOverview);
        panelRight.add((Component)new JSeparator(), "cell 0 5,growx");
        TmmTableModel<Movie> movieTableModel = new TmmTableModel<Movie>(this.movieEventList, new MovieInMovieSetTableFormat());
        this.tableAssignedMovies = new TmmTable((TableModel)((Object)movieTableModel));
        this.tableAssignedMovies.adjustColumnPreferredWidths(3);
        JScrollPane scrollPane = new JScrollPane(this.tableAssignedMovies);
        this.tableAssignedMovies.configureScrollPane(scrollPane);
        panelRight.add((Component)scrollPane, "cell 0 7,grow");
    }

    private void setPoster(MovieSet movieSet) {
        this.lblPoster.clearImage();
        this.lblPoster.setImagePath(movieSet.getArtworkFilename(MediaFileType.POSTER));
        Dimension posterSize = movieSet.getArtworkDimension(MediaFileType.POSTER);
        if (posterSize.width > 0 && posterSize.height > 0) {
            this.lblPosterSize.setText(BUNDLE.getString("mediafiletype.poster") + " - " + posterSize.width + "x" + posterSize.height);
        } else if (StringUtils.isNotBlank((CharSequence)this.lblPoster.getImagePath())) {
            ImageSizeLoader loader = new ImageSizeLoader(this.lblPoster.getImagePath(), "poster", this.lblPosterSize);
            loader.execute();
        } else {
            this.lblPosterSize.setText(BUNDLE.getString("mediafiletype.poster"));
        }
    }

    private void setFanart(MovieSet movieSet) {
        this.lblFanart.clearImage();
        this.lblFanart.setImagePath(movieSet.getArtworkFilename(MediaFileType.FANART));
        Dimension fanartSize = movieSet.getArtworkDimension(MediaFileType.FANART);
        if (fanartSize.width > 0 && fanartSize.height > 0) {
            this.lblFanartSize.setText(BUNDLE.getString("mediafiletype.fanart") + " - " + fanartSize.width + "x" + fanartSize.height);
        } else if (StringUtils.isNotBlank((CharSequence)this.lblFanart.getImagePath())) {
            ImageSizeLoader loader = new ImageSizeLoader(this.lblFanart.getImagePath(), "fanart", this.lblFanartSize);
            loader.execute();
        } else {
            this.lblFanartSize.setText(BUNDLE.getString("mediafiletype.fanart"));
        }
    }

    protected void initDataBindings() {
        BeanProperty tvShowSelectionModelBeanProperty = BeanProperty.create((String)"selectedMovieSet.title");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty, (Object)this.lblMovieSetName, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedMovieSet.plot");
        BeanProperty JTextAreaBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_1, (Object)this.taOverview, (Property)JTextAreaBeanProperty);
        autoBinding_1.bind();
    }

    private class ImageSizeLoader
    extends SwingWorker<Void, Void> {
        private final String path;
        private final String type;
        private final JLabel label;
        private int width;
        private int height;

        public ImageSizeLoader(String path, String type, JLabel label) {
            this.path = path;
            this.type = type;
            this.label = label;
        }

        @Override
        protected Void doInBackground() {
            if (!Files.exists(Paths.get(this.path, new String[0]), new LinkOption[0])) {
                return null;
            }
            try {
                BufferedImage img = ImageIO.read(new File(this.path));
                this.width = img.getWidth();
                this.height = img.getHeight();
            }
            catch (Exception e) {
                LOGGER.warn("Could not read {} dimensions: {}", (Object)("mediafiletype." + this.type), (Object)e.getMessage());
            }
            return null;
        }

        @Override
        protected void done() {
            super.done();
            if (this.width > 0 && this.height > 0) {
                this.label.setText(BUNDLE.getString("mediafiletype." + this.type) + " - " + this.width + "x" + this.height);
            } else {
                this.label.setText(BUNDLE.getString("mediafiletype." + this.type));
            }
        }
    }
}

