/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.ITmmTabItem;
import org.tinymediamanager.ui.ITmmUIFilter;
import org.tinymediamanager.ui.ITmmUIModule;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TablePopupListener;
import org.tinymediamanager.ui.components.TmmListPanel;
import org.tinymediamanager.ui.components.tree.ITmmTreeFilter;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.tree.TmmTreeTextFilter;
import org.tinymediamanager.ui.components.treetable.TmmTreeTable;
import org.tinymediamanager.ui.moviesets.MovieSetSelectionModel;
import org.tinymediamanager.ui.moviesets.MovieSetTableFormat;
import org.tinymediamanager.ui.moviesets.MovieSetTreeDataProvider;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;
import org.tinymediamanager.ui.moviesets.actions.MovieSetEditAction;

public class MovieSetTreePanel
extends TmmListPanel
implements ITmmTabItem {
    private static final long serialVersionUID = 5889203009864512935L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TmmTreeTable tree;
    private final MovieList movieList = MovieList.getInstance();
    private JLabel lblMovieCountFiltered;
    private JLabel lblMovieCountTotal;
    private JLabel lblMovieSetCountFiltered;
    private JLabel lblMovieSetCountTotal;
    private JButton btnFilter;

    public MovieSetTreePanel(MovieSetSelectionModel movieSetSelectionModel) {
        this.initComponents();
        this.initDataBindings();
        movieSetSelectionModel.setTreeTable(this.tree);
        this.updateFilteredCount();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("insets n n 0 n", "[200lp:n,grow][100lp:n,fill]", "[][400lp,grow]0[][][]"));
        TmmTreeTextFilter<TmmTreeNode> searchField = new TmmTreeTextFilter<TmmTreeNode>();
        this.add(searchField, "cell 0 0,growx");
        this.btnFilter = new JButton(BUNDLE.getString("movieextendedsearch.filter"));
        this.btnFilter.setToolTipText(BUNDLE.getString("movieextendedsearch.options"));
        this.btnFilter.addActionListener(e -> MovieSetUIModule.getInstance().setFilterDialogVisible(true));
        this.add((Component)this.btnFilter, "cell 1 0");
        this.tree = new TmmTreeTable(new MovieSetTreeDataProvider(), new MovieSetTableFormat()){

            @Override
            public void storeFilters() {
                if (MovieModuleManager.SETTINGS.isStoreUiFilters()) {
                    ArrayList<AbstractSettings.UIFilters> filterValues = new ArrayList<AbstractSettings.UIFilters>();
                    for (ITmmTreeFilter filter : this.treeFilters) {
                        ITmmUIFilter uiFilter;
                        if (!(filter instanceof ITmmUIFilter) || (uiFilter = (ITmmUIFilter)((Object)filter)).getFilterState() == ITmmUIFilter.FilterState.INACTIVE) continue;
                        AbstractSettings.UIFilters uiFilters = new AbstractSettings.UIFilters();
                        uiFilters.id = uiFilter.getId();
                        uiFilters.state = uiFilter.getFilterState();
                        uiFilters.filterValue = uiFilter.getFilterValueAsString();
                        filterValues.add(uiFilters);
                    }
                    MovieModuleManager.SETTINGS.setMovieSetUiFilters(filterValues);
                    MovieModuleManager.SETTINGS.saveSettings();
                }
            }
        };
        this.tree.addPropertyChangeListener("filterChanged", evt -> this.updateFilterIndicator());
        this.tree.readHiddenColumns(MovieModuleManager.SETTINGS.getMovieSetTableHiddenColumns());
        this.tree.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                this.writeSettings();
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                this.writeSettings();
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            private void writeSettings() {
                MovieSetTreePanel.this.tree.writeHiddenColumns(cols -> {
                    MovieModuleManager.SETTINGS.setMovieSetTableHiddenColumns((List<String>)cols);
                    MovieModuleManager.SETTINGS.saveSettings();
                });
            }
        });
        this.tree.addFilter(searchField);
        JScrollPane scrollPane = new JScrollPane(this.tree);
        this.tree.configureScrollPane(scrollPane, new int[]{0});
        this.add((Component)scrollPane, "cell 0 1 2 1,grow");
        this.tree.adjustColumnPreferredWidths(3);
        this.tree.setRootVisible(false);
        this.tree.getModel().addTableModelListener(arg0 -> {
            this.updateFilteredCount();
            ListSelectionModel selectionModel1 = this.tree.getSelectionModel();
            if (selectionModel1.isSelectionEmpty() && this.tree.getModel().getRowCount() > 0) {
                selectionModel1.setSelectionInterval(0, 0);
            }
        });
        this.tree.getSelectionModel().addListSelectionListener(arg0 -> {
            if (arg0.getValueIsAdjusting() || !(arg0.getSource() instanceof DefaultListSelectionModel)) {
                return;
            }
            int index = ((DefaultListSelectionModel)arg0.getSource()).getMinSelectionIndex();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getValueAt(index, 0);
            if (node != null) {
                if (node.getUserObject() instanceof MovieSet) {
                    MovieSet movieSet = (MovieSet)node.getUserObject();
                    MovieSetUIModule.getInstance().setSelectedMovieSet(movieSet);
                }
                if (node.getUserObject() instanceof Movie) {
                    Movie movie = (Movie)node.getUserObject();
                    MovieSetUIModule.getInstance().setSelectedMovie(movie);
                }
            } else {
                MovieSetUIModule.getInstance().setSelectedMovieSet(null);
            }
        });
        if (this.movieList.getMovieSetList() != null && !this.movieList.getMovieSetList().isEmpty()) {
            SwingUtilities.invokeLater(() -> {
                ListSelectionModel selectionModel1 = this.tree.getSelectionModel();
                if (selectionModel1.isSelectionEmpty() && this.tree.getModel().getRowCount() > 0) {
                    selectionModel1.setSelectionInterval(0, 0);
                }
            });
        }
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed() && e.getButton() == 1) {
                    new MovieSetEditAction().actionPerformed(new ActionEvent(e, 0, ""));
                }
            }
        };
        this.tree.addMouseListener(mouseListener);
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 39) {
                    MovieSetTreePanel.this.tree.expandRow(MovieSetTreePanel.this.tree.getSelectedRow());
                }
                if (e.getKeyCode() == 37) {
                    MovieSetTreePanel.this.tree.collapseRow(MovieSetTreePanel.this.tree.getSelectedRow());
                }
            }
        };
        this.tree.addKeyListener(keyListener);
        JSeparator separator = new JSeparator();
        this.add((Component)separator, "cell 0 2 2 1,growx");
        JLabel lblMovieSetCount = new JLabel(BUNDLE.getString("tmm.moviesets") + ":");
        this.add((Component)lblMovieSetCount, "flowx,cell 0 3 2 1");
        this.lblMovieSetCountFiltered = new JLabel("");
        this.add((Component)this.lblMovieSetCountFiltered, "cell 0 3 2 1");
        JLabel lblMovieSetCountOf = new JLabel(BUNDLE.getString("tmm.of"));
        this.add((Component)lblMovieSetCountOf, "cell 0 3 2 1");
        this.lblMovieSetCountTotal = new JLabel("");
        this.add((Component)this.lblMovieSetCountTotal, "cell 0 3 2 1");
        JLabel lblMovieCount = new JLabel(BUNDLE.getString("tmm.movies") + ":");
        this.add((Component)lblMovieCount, "flowx,cell 0 4 2 1");
        this.lblMovieCountFiltered = new JLabel("");
        this.add((Component)this.lblMovieCountFiltered, "cell 0 4 2 1");
        JLabel lblMovieCountOf = new JLabel(BUNDLE.getString("tmm.of"));
        this.add((Component)lblMovieCountOf, "cell 0 4 2 1");
        this.lblMovieCountTotal = new JLabel("");
        this.add((Component)this.lblMovieCountTotal, "cell 0 4 2 1");
    }

    private void updateFilterIndicator() {
        boolean active = false;
        for (ITmmTreeFilter<TmmTreeNode> filter : this.tree.getFilters()) {
            if (!(filter instanceof ITmmUIFilter)) continue;
            ITmmUIFilter uiFilter = (ITmmUIFilter)((Object)filter);
            switch (uiFilter.getFilterState()) {
                case ACTIVE: 
                case ACTIVE_NEGATIVE: {
                    active = true;
                    break;
                }
            }
            if (!active) continue;
            break;
        }
        if (active) {
            this.btnFilter.setIcon(IconManager.FILTER_ACTIVE);
        } else {
            this.btnFilter.setIcon(null);
        }
    }

    private void updateFilteredCount() {
        int movieSetCount = 0;
        int movieCount = 0;
        for (int i = 0; i < this.tree.getTreeTableModel().getRowCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getValueAt(i, 0);
            if (node == null || !(node.getUserObject() instanceof MovieSet)) continue;
            ++movieSetCount;
            movieCount += node.getChildCount();
        }
        this.lblMovieSetCountFiltered.setText(String.valueOf(movieSetCount));
        this.lblMovieCountFiltered.setText(String.valueOf(movieCount));
    }

    @Override
    public ITmmUIModule getUIModule() {
        return MovieSetUIModule.getInstance();
    }

    public TmmTreeTable getTreeTable() {
        return this.tree;
    }

    @Override
    public void setPopupMenu(JPopupMenu popupMenu) {
        popupMenu.addSeparator();
        popupMenu.add(new ExpandAllAction());
        popupMenu.add(new CollapseAllAction());
        this.tree.addMouseListener(new TablePopupListener(popupMenu, this.tree));
    }

    protected void initDataBindings() {
        BeanProperty movieListBeanProperty = BeanProperty.create((String)"movieSetCount");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieList, (Property)movieListBeanProperty, (Object)this.lblMovieSetCountTotal, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty movieListBeanProperty_1 = BeanProperty.create((String)"movieInMovieSetCount");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieList, (Property)movieListBeanProperty_1, (Object)this.lblMovieCountTotal, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
    }

    public class ExpandAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 6191727607109012198L;

        public ExpandAllAction() {
            this.putValue("Name", BUNDLE.getString("tree.expandall"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = 0;
            do {
                MovieSetTreePanel.this.tree.expandRow(i++);
            } while (i < MovieSetTreePanel.this.tree.getRowCount());
        }
    }

    public class CollapseAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -1444530142931061317L;

        public CollapseAllAction() {
            this.putValue("Name", BUNDLE.getString("tree.collapseall"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = MovieSetTreePanel.this.tree.getRowCount() - 1; i >= 0; --i) {
                MovieSetTreePanel.this.tree.collapseRow(i);
            }
        }
    }
}

