/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.scraper.config.MediaProviderConfig;
import org.tinymediamanager.scraper.config.MediaProviderConfigObject;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.TmmLabel;

public class MediaScraperConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = -4120483383064864579L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaScraperConfigurationPanel.class);
    private IMediaProvider mediaProvider;
    private boolean dirty = false;
    private JPanel configPanel;

    public MediaScraperConfigurationPanel(IMediaProvider mediaProvider) {
        this.mediaProvider = mediaProvider;
        this.setLayout(new BorderLayout());
        JPanel panelHead = new JPanel(new FlowLayout(0, 20, 0));
        this.add((Component)panelHead, "North");
        TmmLabel lblScraperOptions = new TmmLabel(BUNDLE.getString("Settings.scraper.options"), 1.2);
        panelHead.add(lblScraperOptions);
        this.configPanel = this.createConfigPanel();
        this.add((Component)this.configPanel, "Center");
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                if (MediaScraperConfigurationPanel.this.dirty) {
                    MediaScraperConfigurationPanel.this.saveSettings();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }
        });
    }

    private JPanel createConfigPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("gapy 0lp", "[][20lp!][]", ""));
        int row = 0;
        MediaProviderConfig config = this.mediaProvider.getProviderInfo().getConfig();
        for (Map.Entry<String, MediaProviderConfigObject> entry : config.getConfigObjects().entrySet()) {
            JComponent comp;
            if (!entry.getValue().isVisible()) continue;
            String keyDescription = this.getStringFromBundle("scraper." + this.mediaProvider.getProviderInfo().getId() + "." + entry.getKey());
            if (StringUtils.isBlank((CharSequence)keyDescription)) {
                keyDescription = this.getStringFromBundle(entry.getValue().getKeyDescription());
            }
            if (StringUtils.isBlank((CharSequence)keyDescription)) {
                keyDescription = entry.getValue().getKeyDescription();
            }
            JLabel label = new JLabel(keyDescription);
            panel.add((Component)label, "cell 0 " + row);
            switch (entry.getValue().getType()) {
                case BOOL: {
                    JCheckBox checkbox = new JCheckBox();
                    checkbox.setSelected(entry.getValue().getValueAsBool());
                    checkbox.addActionListener(e -> {
                        this.dirty = true;
                    });
                    comp = checkbox;
                    break;
                }
                case INTEGER: {
                    JSpinner spinner = new JSpinner(new SpinnerNumberModel(entry.getValue().getValueAsInteger(), 0, Integer.MAX_VALUE, 1));
                    spinner.addChangeListener(e -> {
                        this.dirty = true;
                    });
                    ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setColumns(5);
                    comp = spinner;
                    break;
                }
                case SELECT: 
                case SELECT_INDEX: {
                    JComboBox<String> combobox = new JComboBox<String>(entry.getValue().getPossibleValues().toArray(new String[0]));
                    combobox.setSelectedItem(entry.getValue().getValueAsString());
                    combobox.addActionListener(e -> {
                        this.dirty = true;
                    });
                    comp = combobox;
                    break;
                }
                default: {
                    JTextField tf = entry.getValue().isEncrypt() ? new JPasswordField(config.getValue(entry.getKey())) : new JTextField(config.getValue(entry.getKey()));
                    tf.setColumns(20);
                    tf.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            MediaScraperConfigurationPanel.this.dirty = true;
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            MediaScraperConfigurationPanel.this.dirty = true;
                        }

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            MediaScraperConfigurationPanel.this.dirty = true;
                        }
                    });
                    comp = tf;
                }
            }
            comp.putClientProperty(entry.getKey(), entry.getKey());
            panel.add((Component)comp, "cell 3 " + row);
            try {
                String desc = this.getStringFromBundle("scraper." + this.mediaProvider.getProviderInfo().getId() + "." + entry.getKey() + ".desc");
                if (StringUtils.isNotBlank((CharSequence)desc)) {
                    JLabel lblHint = new JLabel(IconManager.HINT);
                    lblHint.setToolTipText(desc);
                    panel.add((Component)lblHint, "cell 3 " + row);
                }
            }
            catch (Exception e2) {
                LOGGER.debug("failed to add a hint: {}", (Object)e2.getMessage());
            }
            ++row;
        }
        return panel;
    }

    private String getStringFromBundle(String key) {
        try {
            return BUNDLE.getString(key);
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void saveSettings() {
        Map<String, MediaProviderConfigObject> config = this.mediaProvider.getProviderInfo().getConfig().getConfigObjects();
        for (Map.Entry<String, MediaProviderConfigObject> entry : config.entrySet()) {
            for (Component comp : this.configPanel.getComponents()) {
                if (!(comp instanceof JComponent)) continue;
                Object param = ((JComponent)comp).getClientProperty(entry.getKey());
                if (!entry.getKey().equals(param)) continue;
                try {
                    if (comp instanceof JCheckBox) {
                        this.mediaProvider.getProviderInfo().getConfig().setValue(entry.getKey(), ((JCheckBox)comp).isSelected());
                        continue;
                    }
                    if (comp instanceof JComboBox) {
                        this.mediaProvider.getProviderInfo().getConfig().setValue(entry.getKey(), ((JComboBox)comp).getSelectedItem().toString());
                        continue;
                    }
                    if (comp instanceof JSpinner) {
                        this.mediaProvider.getProviderInfo().getConfig().setValue(entry.getKey(), (Integer)((JSpinner)comp).getValue());
                        continue;
                    }
                    this.mediaProvider.getProviderInfo().getConfig().setValue(entry.getKey(), ((JTextField)comp).getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.mediaProvider.getProviderInfo().getConfig().save();
    }
}

