/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTreeUI;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.TreePath;

public class TmmTreeUI
extends BaseTreeUI {
    private RowSelectionListener sf = new RowSelectionListener();

    public static ComponentUI createUI(JComponent c) {
        return new TmmTreeUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Insets insets = this.tree.getInsets();
        int w = this.tree.getWidth() - insets.left - insets.right;
        int h = this.tree.getHeight() - insets.top - insets.bottom;
        int x = insets.left;
        int y = insets.top;
        int nItems = this.tree.getRowCount();
        int rowHeight = 17;
        int i = 0;
        while (i < nItems) {
            Rectangle rect = this.tree.getRowBounds(i);
            rowHeight = rect != null ? rect.height : rowHeight;
            g.setColor(this.getSelectionModel().isRowSelected(i) ? AbstractLookAndFeel.getSelectionBackgroundColor() : AbstractLookAndFeel.getBackgroundColor());
            g.fillRect(x, y, w, rowHeight);
            ++i;
            y += rowHeight;
        }
        int remainder = insets.top + h - y;
        if (remainder > 0) {
            g.setColor(AbstractLookAndFeel.getBackgroundColor());
            g.fillRect(x, y, w, remainder);
        }
        this.tree.setOpaque(false);
        super.paint(g, c);
        this.tree.setOpaque(true);
    }

    @Override
    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.editingComponent != null && this.editingRow == row) {
            return;
        }
        bounds.width = this.tree.getWidth() - bounds.x;
        super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
    }

    @Override
    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
    }

    @Override
    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.tree.addMouseListener(this.sf);
    }

    @Override
    protected void uninstallListeners() {
        this.tree.removeMouseListener(this.sf);
        super.uninstallListeners();
    }

    private class RowSelectionListener
    extends MouseAdapter {
        private RowSelectionListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!TmmTreeUI.this.tree.isEnabled()) {
                return;
            }
            TreePath closestPath = TmmTreeUI.this.tree.getClosestPathForLocation(e.getX(), e.getY());
            if (closestPath == null) {
                return;
            }
            Rectangle bounds = TmmTreeUI.this.tree.getPathBounds(closestPath);
            if (e.getY() >= bounds.y && e.getY() < bounds.y + bounds.height && (e.getX() < bounds.x || e.getX() > bounds.x + bounds.width)) {
                if (TmmTreeUI.this.isLocationInExpandControl(closestPath, e.getX(), e.getY())) {
                    return;
                }
                TmmTreeUI.this.selectPathForEvent(closestPath, e);
            }
        }
    }
}

