/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.settings;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.DateField;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.SettingsPanelFactory;
import org.tinymediamanager.ui.components.TmmLabel;

class UiSettingsPanel
extends JPanel {
    private static final long serialVersionUID = 6409982195347794360L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(UiSettingsPanel.class);
    private static final Integer[] DEFAULT_FONT_SIZES = new Integer[]{12, 14, 16, 18, 20, 22, 24, 26, 28};
    private Settings settings = Settings.getInstance();
    private List<LocaleComboBox> locales = new ArrayList<LocaleComboBox>();
    private JComboBox cbLanguage;
    private JLabel lblFontChangeHint;
    private LinkLabel lblLinkTranslate;
    private JComboBox cbFontSize;
    private JComboBox cbFontFamily;
    private JLabel lblLanguageChangeHint;
    private JCheckBox chckbxStoreWindowPreferences;
    private JComboBox cbTheme;
    private JLabel lblThemeHint;
    private JCheckBox chckbxShowMemory;
    private JComboBox cbDatefield;

    UiSettingsPanel() {
        LocaleComboBox actualLocale = null;
        Locale settingsLang = Utils.getLocaleFromLanguage(Globals.settings.getLanguage());
        for (Locale l : Utils.getLanguages()) {
            LocaleComboBox localeComboBox = new LocaleComboBox(l);
            this.locales.add(localeComboBox);
            if (!l.equals(settingsLang)) continue;
            actualLocale = localeComboBox;
        }
        Collections.sort(this.locales);
        this.initComponents();
        this.initDataBindings();
        if (actualLocale != null) {
            this.cbLanguage.setSelectedItem(actualLocale);
        }
        this.cbFontFamily.setSelectedItem(Globals.settings.getFontFamily());
        int index = this.cbFontFamily.getSelectedIndex();
        if (index < 0) {
            this.cbFontFamily.setSelectedItem("Dialog");
            index = this.cbFontFamily.getSelectedIndex();
        }
        if (index < 0) {
            this.cbFontFamily.setSelectedIndex(0);
        }
        this.cbFontSize.setSelectedItem(Globals.settings.getFontSize());
        index = this.cbFontSize.getSelectedIndex();
        if (index < 0) {
            this.cbFontSize.setSelectedIndex(0);
        }
        this.cbTheme.setSelectedItem(Globals.settings.getTheme());
        index = this.cbTheme.getSelectedIndex();
        if (index < 0) {
            this.cbTheme.setSelectedIndex(0);
        }
        this.lblLinkTranslate.addActionListener(arg0 -> {
            try {
                TmmUIHelper.browseUrl(this.lblLinkTranslate.getText());
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.lblLinkTranslate.getText(), "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        ActionListener actionListener = e -> this.checkChanges();
        this.cbLanguage.addActionListener(actionListener);
        this.cbFontFamily.addActionListener(actionListener);
        this.cbFontSize.addActionListener(actionListener);
        this.cbTheme.addActionListener(actionListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 1", "[grow]", "[][15lp!][][15lp!][][15lp!][]"));
        JPanel panelLanguage = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblLanguageT = new TmmLabel(BUNDLE.getString("Settings.language"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelLanguage, lblLanguageT, true);
        this.add((Component)collapsiblePanel, "cell 0 0,growx, wmin 0");
        this.cbLanguage = new JComboBox<Object>(this.locales.toArray());
        panelLanguage.add((Component)this.cbLanguage, "cell 1 0 2 1");
        JLabel lblLanguageHint = new JLabel(BUNDLE.getString("tmm.helptranslate"));
        panelLanguage.add((Component)lblLanguageHint, "cell 1 1 2 1");
        this.lblLinkTranslate = new LinkLabel("https://forum.kodi.tv/showthread.php?tid=174987");
        panelLanguage.add((Component)this.lblLinkTranslate, "cell 1 2 2 1, grow, wmin 0");
        this.lblLanguageChangeHint = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblLanguageChangeHint, 1);
        panelLanguage.add((Component)this.lblLanguageChangeHint, "cell 0 3 3 1");
        JPanel panelTheme = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblThemeT = new TmmLabel(BUNDLE.getString("Settings.uitheme"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelTheme, lblThemeT, true);
        this.add((Component)collapsiblePanel, "cell 0 2,growx,wmin 0");
        this.cbTheme = new JComboBox<String>(new String[]{"Light", "Dark"});
        panelTheme.add((Component)this.cbTheme, "cell 1 0 2 1");
        this.lblThemeHint = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblThemeHint, 1);
        panelTheme.add((Component)this.lblThemeHint, "cell 0 1 3 1");
        JPanel panelFont = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblFontT = new TmmLabel(BUNDLE.getString("Settings.font"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelFont, lblFontT, true);
        this.add((Component)collapsiblePanel, "cell 0 4,growx,wmin 0");
        JLabel lblFontFamilyT = new JLabel(BUNDLE.getString("Settings.fontfamily"));
        panelFont.add((Component)lblFontFamilyT, "cell 1 0");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.cbFontFamily = new JComboBox<String>(env.getAvailableFontFamilyNames());
        panelFont.add((Component)this.cbFontFamily, "cell 2 0");
        JLabel lblFontSizeT = new JLabel(BUNDLE.getString("Settings.fontsize"));
        panelFont.add((Component)lblFontSizeT, "cell 1 1");
        this.cbFontSize = new JComboBox<Integer>(DEFAULT_FONT_SIZES);
        panelFont.add((Component)this.cbFontSize, "cell 2 1");
        ReadOnlyTextArea tpFontHint = new ReadOnlyTextArea(BUNDLE.getString("Settings.fonts.hint"));
        panelFont.add((Component)tpFontHint, "cell 1 2 2 1,growx");
        this.lblFontChangeHint = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblFontChangeHint, 1);
        panelFont.add((Component)this.lblFontChangeHint, "cell 0 3 3 1");
        JPanel panelMisc = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblMiscT = new TmmLabel(BUNDLE.getString("Settings.misc"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelMisc, lblMiscT, true);
        this.add((Component)collapsiblePanel, "cell 0 6,growx,wmin 0");
        JLabel lblDatefield = new JLabel(BUNDLE.getString("Settings.datefield"));
        panelMisc.add((Component)lblDatefield, "cell 1 0");
        this.cbDatefield = new JComboBox<DateField>(DateField.values());
        panelMisc.add((Component)this.cbDatefield, "cell 2 0");
        JLabel lblDatefieldHint = new JLabel(BUNDLE.getString("Settings.datefield.desc"));
        panelMisc.add((Component)lblDatefieldHint, "cell 2 1");
        this.chckbxStoreWindowPreferences = new JCheckBox(BUNDLE.getString("Settings.storewindowpreferences"));
        panelMisc.add((Component)this.chckbxStoreWindowPreferences, "cell 1 2 2 1");
        this.chckbxShowMemory = new JCheckBox(BUNDLE.getString("Settings.showmemory"));
        panelMisc.add((Component)this.chckbxShowMemory, "cell 1 3 2 1");
    }

    private void checkChanges() {
        String fontFamily;
        Integer fontSize;
        String theme;
        Locale actualLocale;
        Locale locale;
        LocaleComboBox loc = (LocaleComboBox)this.cbLanguage.getSelectedItem();
        if (loc != null && !(locale = loc.loc).equals(actualLocale = Utils.getLocaleFromLanguage(Globals.settings.getLanguage()))) {
            Globals.settings.setLanguage(locale.toString());
            this.lblLanguageChangeHint.setText(BUNDLE.getString("Settings.languagehint"));
        }
        if (!(theme = (String)this.cbTheme.getSelectedItem()).equals(Globals.settings.getTheme())) {
            Globals.settings.setTheme(theme);
            this.lblThemeHint.setText(BUNDLE.getString("Settings.uitheme.hint"));
        }
        if ((fontSize = (Integer)this.cbFontSize.getSelectedItem()) != null && fontSize.intValue() != Globals.settings.getFontSize()) {
            Globals.settings.setFontSize(fontSize);
            this.lblFontChangeHint.setText(BUNDLE.getString("Settings.fontchangehint"));
        }
        if ((fontFamily = (String)this.cbFontFamily.getSelectedItem()) != null && !fontFamily.equals(Globals.settings.getFontFamily())) {
            Globals.settings.setFontFamily(fontFamily);
            this.lblFontChangeHint.setText(BUNDLE.getString("Settings.fontchangehint"));
        }
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"storeWindowPreferences");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.chckbxStoreWindowPreferences, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"showMemory");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.chckbxShowMemory, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"dateField");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, (Object)this.cbDatefield, (Property)jComboBoxBeanProperty);
        autoBinding_2.bind();
    }

    private class LocaleComboBox
    implements Comparable<LocaleComboBox> {
        private Locale loc;
        private List<Locale> countries;

        LocaleComboBox(Locale loc) {
            this.loc = loc;
            this.countries = LocaleUtils.countriesByLanguage((String)loc.getLanguage().toLowerCase(Locale.ROOT));
        }

        public Locale getLocale() {
            return this.loc;
        }

        public String toString() {
            if (this.loc.getLanguage().equalsIgnoreCase(this.loc.getCountry())) {
                return this.loc.getDisplayLanguage(this.loc);
            }
            if (this.loc.toString().equals("en_US")) {
                return this.loc.getDisplayLanguage(this.loc);
            }
            if (this.countries.size() == 1) {
                return this.loc.getDisplayLanguage(this.loc);
            }
            if (StringUtils.isNotBlank((CharSequence)this.loc.getDisplayCountry(this.loc))) {
                return this.loc.getDisplayLanguage(this.loc) + " (" + this.loc.getDisplayCountry(this.loc) + ")";
            }
            return this.loc.getDisplayLanguage(this.loc);
        }

        @Override
        public int compareTo(LocaleComboBox o) {
            return this.toString().toLowerCase(Locale.ROOT).compareTo(o.toString().toLowerCase(Locale.ROOT));
        }
    }
}

