/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowHelpers;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.TrailerSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowTrailerProvider;
import org.tinymediamanager.scraper.util.StrgUtils;

public class TvShowChooserModel
extends AbstractModelObject {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowChooserModel.class);
    public static final TvShowChooserModel emptyResult = new TvShowChooserModel();
    private MediaScraper mediaScraper = null;
    private List<MediaScraper> artworkScrapers = null;
    private List<MediaScraper> trailerScrapers = null;
    private MediaLanguages language = null;
    private MediaSearchResult result = null;
    private MediaMetadata metadata = null;
    private float score = 0.0f;
    private String title = "";
    private String originalTitle = "";
    private String overview = "";
    private String year = "";
    private String combinedName = "";
    private String posterUrl = "";
    private boolean scraped = false;

    public TvShowChooserModel(MediaScraper mediaScraper, List<MediaScraper> artworkScrapers, List<MediaScraper> trailerScrapers, MediaSearchResult result, MediaLanguages language) {
        this.mediaScraper = mediaScraper;
        this.artworkScrapers = artworkScrapers;
        this.result = result;
        this.language = language;
        this.trailerScrapers = trailerScrapers;
        this.setTitle(result.getTitle());
        this.setOriginalTitle(result.getOriginalTitle());
        if (result.getYear() != 0) {
            this.setYear(Integer.toString(result.getYear()));
        } else {
            this.setYear("");
        }
        this.setCombinedName();
        this.score = result.getScore();
    }

    private TvShowChooserModel() {
        this.setTitle(BUNDLE.getString("chooser.nothingfound"));
        this.combinedName = this.title;
    }

    public float getScore() {
        return this.score;
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = StrgUtils.getNonNullString(title);
        this.firePropertyChange("title", oldValue, this.title);
    }

    public void setOriginalTitle(String originalTitle) {
        String oldValue = this.originalTitle;
        this.originalTitle = StrgUtils.getNonNullString(originalTitle);
        this.firePropertyChange("originalTitle", oldValue, this.originalTitle);
    }

    public void setOverview(String overview) {
        String oldValue = this.overview;
        this.overview = StrgUtils.getNonNullString(overview);
        this.firePropertyChange("overview", oldValue, this.overview);
    }

    public String getTitle() {
        return this.title;
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public String getOverview() {
        return this.overview;
    }

    public String getPosterUrl() {
        return this.posterUrl;
    }

    public void setPosterUrl(String newValue) {
        String oldValue = this.posterUrl;
        this.posterUrl = StrgUtils.getNonNullString(newValue);
        this.firePropertyChange("posterUrl", oldValue, newValue);
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        String oldValue = this.year;
        this.year = year;
        this.firePropertyChange("year", oldValue, this.year);
    }

    public void setCombinedName() {
        String oldValue = this.combinedName;
        this.combinedName = StringUtils.isNotBlank((CharSequence)this.getYear()) ? this.getTitle() + " (" + this.getYear() + ")" : this.getTitle();
        this.firePropertyChange("combinedName", oldValue, this.combinedName);
    }

    public String getCombinedName() {
        return this.combinedName;
    }

    public MediaScraper getMediaScraper() {
        return this.mediaScraper;
    }

    public List<MediaScraper> getArtworkScrapers() {
        return this.artworkScrapers;
    }

    public void startTrailerScrapeTask(TvShow tvShow) {
        TmmTaskManager.getInstance().addUnnamedTask(new TrailerScrapeTask(tvShow));
    }

    public void scrapeMetaData() {
        try {
            this.setPosterUrl(this.result.getPosterUrl());
            TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions();
            options.setSearchResult(this.result);
            options.setLanguage(this.language);
            options.setIds(this.result.getIds());
            LOGGER.info("=====================================================");
            LOGGER.info("Scrape metadata with scraper: {}", (Object)this.mediaScraper.getMediaProvider().getProviderInfo().getId());
            LOGGER.info("{}", (Object)options);
            LOGGER.info("=====================================================");
            this.metadata = ((ITvShowMetadataProvider)this.mediaScraper.getMediaProvider()).getMetadata(options);
            this.setOverview(this.metadata.getPlot());
            if (StringUtils.isBlank((CharSequence)this.posterUrl) && !this.metadata.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).isEmpty()) {
                this.setPosterUrl(this.metadata.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).get(0).getPreviewUrl());
            }
            this.setScraped(true);
        }
        catch (ScrapeException e) {
            LOGGER.error("getMetadata", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowChooser", "message.scrape.metadatatvshowfailed", new String[]{":", e.getLocalizedMessage()}));
        }
        catch (MissingIdException e) {
            LOGGER.warn("missing id for scrape");
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "TvShowChooser", "scraper.error.missingid"));
        }
        catch (NothingFoundException ignored) {
            LOGGER.debug("nothing found");
        }
    }

    public List<TvShowEpisode> getEpisodesForDisplay() {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>();
        if (!this.scraped) {
            return episodes;
        }
        TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions();
        options.setLanguage(this.language);
        for (Map.Entry<String, Object> entry : this.metadata.getIds().entrySet()) {
            options.setId(entry.getKey(), entry.getValue().toString());
        }
        try {
            List<MediaMetadata> mediaEpisodes = ((ITvShowMetadataProvider)this.mediaScraper.getMediaProvider()).getEpisodeList(options);
            for (MediaMetadata me : mediaEpisodes) {
                TvShowEpisode ep = new TvShowEpisode();
                ep.setEpisode(me.getEpisodeNumber());
                ep.setSeason(me.getSeasonNumber());
                ep.setDvdEpisode(me.getDvdEpisodeNumber());
                ep.setDvdSeason(me.getDvdSeasonNumber());
                ep.setTitle(me.getTitle());
                ep.setOriginalTitle(me.getOriginalTitle());
                ep.setPlot(me.getPlot());
                episodes.add(ep);
            }
        }
        catch (ScrapeException e) {
            LOGGER.error("getEpisodeList", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowChooser", "message.scrape.episodelistfailed", new String[]{":", e.getLocalizedMessage()}));
        }
        catch (MissingIdException e) {
            LOGGER.warn("missing id for scrape");
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "TvShowChooser", "scraper.error.missingid"));
        }
        return episodes;
    }

    public MediaMetadata getMetadata() {
        return this.metadata;
    }

    private void setScraped(boolean newvalue) {
        boolean oldValue = this.scraped;
        this.scraped = newvalue;
        this.firePropertyChange("scraped", oldValue, newvalue);
    }

    public boolean isScraped() {
        return this.scraped;
    }

    public MediaLanguages getLanguage() {
        return this.language;
    }

    public void startArtworkScrapeTask(TvShow tvShow, List<TvShowScraperMetadataConfig> config) {
        TmmTaskManager.getInstance().addUnnamedTask(new ArtworkScrapeTask(tvShow, config));
    }

    private class TrailerScrapeTask
    extends TmmTask {
        private TvShow tvShowtoScrape;

        public TrailerScrapeTask(TvShow tvShow) {
            super(BUNDLE.getString("message.scrape.trailer") + " " + tvShow.getTitle(), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
            this.tvShowtoScrape = tvShow;
        }

        @Override
        protected void doInBackground() {
            if (!TvShowChooserModel.this.scraped) {
                return;
            }
            ArrayList<MediaTrailer> trailer = new ArrayList<MediaTrailer>();
            TrailerSearchAndScrapeOptions options = new TrailerSearchAndScrapeOptions(MediaType.TV_SHOW);
            options.setMetadata(TvShowChooserModel.this.metadata);
            options.setIds(TvShowChooserModel.this.metadata.getIds());
            options.setLanguage(TvShowChooserModel.this.language);
            for (MediaScraper trailerScraper : TvShowChooserModel.this.trailerScrapers) {
                try {
                    ITvShowTrailerProvider trailerProvider = (ITvShowTrailerProvider)trailerScraper.getMediaProvider();
                    trailer.addAll(trailerProvider.getTrailers(options));
                }
                catch (ScrapeException e) {
                    LOGGER.error("getTrailers {}", (Object)e.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowChooser", "message.scrape.trailerfailed", new String[]{":", e.getLocalizedMessage()}));
                }
                catch (MissingIdException ignored) {
                    LOGGER.debug("no id found for scraper {}", (Object)trailerScraper.getMediaProvider().getProviderInfo().getId());
                }
            }
            this.tvShowtoScrape.setTrailers(trailer);
            this.tvShowtoScrape.saveToDb();
            this.tvShowtoScrape.writeNFO();
            TvShowHelpers.startAutomaticTrailerDownload(this.tvShowtoScrape);
        }
    }

    private class ArtworkScrapeTask
    extends TmmTask {
        private TvShow tvShowToScrape;
        private List<TvShowScraperMetadataConfig> config;

        public ArtworkScrapeTask(TvShow tvShow, List<TvShowScraperMetadataConfig> config) {
            super(BUNDLE.getString("message.scrape.artwork") + " " + tvShow.getTitle(), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
            this.tvShowToScrape = tvShow;
            this.config = config;
        }

        @Override
        protected void doInBackground() {
            if (!TvShowChooserModel.this.scraped) {
                return;
            }
            ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
            ArtworkSearchAndScrapeOptions options = new ArtworkSearchAndScrapeOptions(MediaType.TV_SHOW);
            options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            options.setLanguage(TvShowChooserModel.this.language);
            options.setMetadata(TvShowChooserModel.this.metadata);
            options.setIds(TvShowChooserModel.this.metadata.getIds());
            options.setLanguage(TvShowModuleManager.SETTINGS.getImageScraperLanguage());
            options.setFanartSize(TvShowModuleManager.SETTINGS.getImageFanartSize());
            options.setPosterSize(TvShowModuleManager.SETTINGS.getImagePosterSize());
            for (Map.Entry<String, Object> entry : this.tvShowToScrape.getIds().entrySet()) {
                options.setId(entry.getKey(), entry.getValue().toString());
            }
            for (MediaScraper artworkScraper : TvShowChooserModel.this.artworkScrapers) {
                ITvShowArtworkProvider artworkProvider = (ITvShowArtworkProvider)artworkScraper.getMediaProvider();
                try {
                    artwork.addAll(artworkProvider.getArtwork(options));
                }
                catch (ScrapeException e) {
                    LOGGER.error("getArtwork", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.tvShowToScrape, "message.scrape.tvshowartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                }
                catch (MissingIdException e) {
                    LOGGER.debug("no id found for scraper {}", (Object)artworkScraper.getMediaProvider().getProviderInfo().getId());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)TvShowChooserModel.this.getPosterUrl())) {
                MediaArtwork ma = new MediaArtwork(TvShowChooserModel.this.result.getProviderId(), MediaArtwork.MediaArtworkType.POSTER);
                ma.setDefaultUrl(TvShowChooserModel.this.getPosterUrl());
                ma.setPreviewUrl(TvShowChooserModel.this.getPosterUrl());
                artwork.add(ma);
            }
            this.tvShowToScrape.setArtwork(artwork, this.config);
        }
    }
}

