/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.awt.FontMetrics;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableFormat;
import org.tinymediamanager.ui.renderer.DateTableCellRenderer;
import org.tinymediamanager.ui.renderer.RightAlignTableCellRenderer;

public class TvShowTableFormat
extends TmmTreeTableFormat<TmmTreeNode> {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowTableFormat() {
        FontMetrics fontMetrics = this.getFontMetrics();
        TmmTableFormat.Column col = new TmmTableFormat.Column(BUNDLE.getString("metatag.seasons"), "seasons", this::getSeasons, String.class);
        col.setHeaderIcon(IconManager.SEASONS);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("99") * 1.2f));
        this.addColumn(col);
        col = new TmmTableFormat.Column(BUNDLE.getString("metatag.episodes"), "episodes", this::getEpisodes, String.class);
        col.setHeaderIcon(IconManager.EPISODES);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("999") * 1.2f));
        this.addColumn(col);
        col = new TmmTableFormat.Column(BUNDLE.getString("metatag.rating"), "rating", this::getRating, String.class);
        col.setHeaderIcon(IconManager.RATING);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("99.9") * 1.2f));
        this.addColumn(col);
        col = new TmmTableFormat.Column(BUNDLE.getString("metatag.aired"), "aired", this::getAiredDate, Date.class);
        col.setHeaderIcon(IconManager.DATE_ADDED);
        col.setCellRenderer(new DateTableCellRenderer());
        col.setColumnResizeable(false);
        try {
            Date date = StrgUtils.parseDate("2012-12-12");
            col.setMinWidth((int)((float)fontMetrics.stringWidth(TmmDateFormat.MEDIUM_DATE_FORMAT.format(date)) * 1.2f));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addColumn(col);
        col = new TmmTableFormat.Column(BUNDLE.getString("metatag.format"), "format", this::getFormat, String.class);
        col.setHeaderIcon(IconManager.VIDEO_FORMAT);
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("1080p") * 1.2f));
        this.addColumn(col);
        col = new TmmTableFormat.Column(BUNDLE.getString("metatag.size"), "fileSize", this::getFileSize, String.class);
        col.setHeaderIcon(IconManager.FILE_SIZE);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("50000M") * 1.2f));
        this.addColumn(col);
        col = new TmmTableFormat.Column(BUNDLE.getString("tmm.nfo"), "nfo", this::hasNfo, ImageIcon.class);
        col.setHeaderIcon(IconManager.NFO);
        col.setColumnResizeable(false);
        col.setColumnTooltip(this::hasNfoTooltip);
        this.addColumn(col);
        col = new TmmTableFormat.Column(BUNDLE.getString("tmm.images"), "images", this::hasImages, ImageIcon.class);
        col.setHeaderIcon(IconManager.IMAGES);
        col.setColumnResizeable(false);
        col.setColumnTooltip(this::hasImageTooltip);
        this.addColumn(col);
        col = new TmmTableFormat.Column(BUNDLE.getString("tmm.subtitles"), "subtitles", this::hasSubtitles, ImageIcon.class);
        col.setHeaderIcon(IconManager.SUBTITLES);
        col.setColumnResizeable(false);
        this.addColumn(col);
        col = new TmmTableFormat.Column(BUNDLE.getString("metatag.watched"), "watched", this::isWatched, ImageIcon.class);
        col.setHeaderIcon(IconManager.WATCHED);
        col.setColumnResizeable(false);
        this.addColumn(col);
    }

    private String getSeasons(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            return String.valueOf(((TvShow)userObject).getSeasonCount());
        }
        return "";
    }

    private String getEpisodes(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            return String.valueOf(((TvShow)userObject).getEpisodeCount());
        }
        if (userObject instanceof TvShowSeason && !((TvShowSeason)userObject).getEpisodes().isEmpty()) {
            return String.valueOf(((TvShowSeason)userObject).getEpisodes().size());
        }
        return "";
    }

    private String getRating(TmmTreeNode node) {
        MediaRating mediaRating;
        Object userObject = node.getUserObject();
        if ((userObject instanceof TvShow || userObject instanceof TvShowEpisode) && (mediaRating = ((MediaEntity)userObject).getRating()) != null && mediaRating.getRating() > 0.0f) {
            return String.valueOf(mediaRating.getRating());
        }
        return "";
    }

    private Date getAiredDate(TmmTreeNode node) {
        Date airedDate;
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow && (airedDate = ((TvShow)userObject).getFirstAired()) != null) {
            return airedDate;
        }
        if (userObject instanceof TvShowSeason && (airedDate = ((TvShowSeason)userObject).getFirstAired()) != null) {
            return airedDate;
        }
        if (userObject instanceof TvShowEpisode && (airedDate = ((TvShowEpisode)userObject).getFirstAired()) != null) {
            return airedDate;
        }
        return null;
    }

    private String getFormat(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            return ((TvShowEpisode)userObject).getMediaInfoVideoFormat();
        }
        return "";
    }

    private String getFileSize(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShowEpisode) {
            long size = 0L;
            for (MediaFile mf : ((TvShowEpisode)userObject).getMediaFiles(MediaFileType.VIDEO)) {
                size += mf.getFilesize();
            }
            return (int)((double)size / 1000000.0) + " M";
        }
        return "";
    }

    private ImageIcon hasNfo(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            if (TvShowModuleManager.SETTINGS.getEpisodeNfoFilenames().isEmpty()) {
                return this.getCheckIcon(tvShow.getHasNfoFile());
            }
            return this.getTriStateIcon(TmmTreeTableFormat.TRI_STATE.getState(tvShow.getHasNfoFile(), tvShow.getHasEpisodeNfoFiles()));
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.getCheckIcon(season.getHasEpisodeNfoFiles());
        }
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return this.getCheckIcon(episode.getHasNfoFile());
        }
        return null;
    }

    private ImageIcon hasImages(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.getTriStateIcon(TmmTreeTableFormat.TRI_STATE.getState(tvShow.getHasImages(), tvShow.getHasSeasonAndEpisodeImages()));
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.getTriStateIcon(TmmTreeTableFormat.TRI_STATE.getState(season.getHasImages(), season.getHasEpisodeImages()));
        }
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return this.getCheckIcon(episode.getHasImages());
        }
        return null;
    }

    private ImageIcon hasSubtitles(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            return this.getCheckIcon(tvShow.hasEpisodeSubtitles());
        }
        if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            return this.getCheckIcon(season.hasEpisodeSubtitles());
        }
        if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            return this.getCheckIcon(episode.getHasSubtitles());
        }
        return null;
    }

    private ImageIcon isWatched(TmmTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            return this.getCheckIcon(((TvShow)userObject).isWatched());
        }
        if (userObject instanceof TvShowSeason) {
            return this.getCheckIcon(((TvShowSeason)userObject).isWatched());
        }
        if (userObject instanceof TvShowEpisode) {
            return this.getCheckIcon(((TvShowEpisode)userObject).isWatched());
        }
        return null;
    }

    private String hasNfoTooltip(TmmTreeNode node) {
        ImageIcon nfoIcon;
        if (node.getUserObject() instanceof TvShow && (nfoIcon = this.hasNfo(node)) == IconManager.TABLE_PROBLEM) {
            return BUNDLE.getString("tvshow.tree.nfo.problem");
        }
        return null;
    }

    private String hasImageTooltip(TmmTreeNode node) {
        ImageIcon nfoIcon;
        if (node.getUserObject() instanceof TvShow) {
            ImageIcon nfoIcon2 = this.hasImages(node);
            if (nfoIcon2 == IconManager.TABLE_PROBLEM) {
                return BUNDLE.getString("tvshow.tree.tvshow.image.problem");
            }
        } else if (node.getUserObject() instanceof TvShowSeason && (nfoIcon = this.hasImages(node)) == IconManager.TABLE_PROBLEM) {
            return BUNDLE.getString("tvshow.tree.season.image.problem");
        }
        return null;
    }
}

