/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UIConstants;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableCellRenderer;
import org.tinymediamanager.ui.tvshows.TvShowTreeDataProvider;

public class TvShowTreeCellRenderer
extends TmmTreeTableCellRenderer {
    private Color colorDummy = UIConstants.LINK_COLOR;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TvShow tvShow;
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof TvShowTreeDataProvider.TvShowSeasonTreeNode) {
            TvShowSeason season = (TvShowSeason)((TvShowTreeDataProvider.TvShowSeasonTreeNode)value).getUserObject();
            if (season.isDummy()) {
                renderer.setForeground(this.colorDummy);
            }
            if (season.isNewlyAdded()) {
                renderer.setHorizontalTextPosition(10);
                renderer.setIconTextGap(10);
                renderer.setIcon(IconManager.NEW);
            }
        } else if (value instanceof TvShowTreeDataProvider.TvShowEpisodeTreeNode) {
            TvShowEpisode episode = (TvShowEpisode)((TvShowTreeDataProvider.TvShowEpisodeTreeNode)value).getUserObject();
            if (episode.isDummy()) {
                renderer.setForeground(this.colorDummy);
            }
            if (episode.isNewlyAdded()) {
                renderer.setHorizontalTextPosition(10);
                renderer.setIconTextGap(10);
                renderer.setIcon(IconManager.NEW);
            }
        } else if (value instanceof TvShowTreeDataProvider.TvShowTreeNode && ((tvShow = (TvShow)((TvShowTreeDataProvider.TvShowTreeNode)value).getUserObject()).isNewlyAdded() || tvShow.hasNewlyAddedEpisodes())) {
            renderer.setHorizontalTextPosition(10);
            renderer.setIconTextGap(10);
            renderer.setIcon(IconManager.NEW);
        }
        return renderer;
    }
}

