/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.beans.PropertyChangeListener;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.components.tree.TmmTreeDataProvider;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;

public class TvShowTreeDataProvider
extends TmmTreeDataProvider<TmmTreeNode> {
    protected static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TmmTreeNode root = new TmmTreeNode(new Object(), this);
    private RuleBasedCollator stringCollator = (RuleBasedCollator)RuleBasedCollator.getInstance();
    private final PropertyChangeListener tvShowListPropertyChangeListener;
    private final PropertyChangeListener tvShowPropertyChangeListener;
    private final PropertyChangeListener episodePropertyChangeListener;
    private final TvShowList tvShowList = TvShowList.getInstance();

    public TvShowTreeDataProvider() {
        this.tvShowListPropertyChangeListener = evt -> {
            switch (evt.getPropertyName()) {
                case "addedTvShow": {
                    TvShow tvShow = (TvShow)evt.getNewValue();
                    this.addTvShow(tvShow);
                    break;
                }
                case "removedTvShow": {
                    TvShow tvShow = (TvShow)evt.getNewValue();
                    this.removeTvShow(tvShow);
                    break;
                }
                default: {
                    if (evt.getSource() instanceof TvShowList) break;
                    this.nodeChanged(evt.getSource());
                }
            }
        };
        this.tvShowList.addPropertyChangeListener(this.tvShowListPropertyChangeListener);
        this.tvShowPropertyChangeListener = evt -> {
            if (!(evt.getSource() instanceof TvShow)) {
                return;
            }
            switch (evt.getPropertyName()) {
                case "addedSeason": {
                    TvShowSeason season = (TvShowSeason)evt.getNewValue();
                    this.addTvShowSeason(season);
                    break;
                }
                case "addedEpisode": {
                    TvShowEpisode episode = (TvShowEpisode)evt.getNewValue();
                    this.addTvShowEpisode(episode);
                    break;
                }
                case "removedEpisode": {
                    TvShowEpisode episode = (TvShowEpisode)evt.getNewValue();
                    this.removeTvShowEpisode(episode);
                    break;
                }
                case "episodeCount": 
                case "seasonCount": {
                    break;
                }
                default: {
                    this.nodeChanged(evt.getSource());
                }
            }
        };
        this.episodePropertyChangeListener = evt -> {
            switch (evt.getPropertyName()) {
                case "season": 
                case "episode": {
                    TvShowEpisode episode = (TvShowEpisode)evt.getSource();
                    this.removeTvShowEpisode(episode);
                    this.addTvShowEpisode(episode);
                    break;
                }
                case "tvShow": {
                    break;
                }
                default: {
                    this.nodeChanged(evt.getSource());
                }
            }
        };
        this.setTreeComparator(new TvShowComparator());
        TvShowModuleManager.SETTINGS.addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "displayMissingEpisodes": {
                    if (TvShowModuleManager.SETTINGS.isDisplayMissingEpisodes()) {
                        this.addDummyEpisodes();
                        break;
                    }
                    this.removeDummyEpisodes();
                    break;
                }
                case "displayMissingSpecials": {
                    if (TvShowModuleManager.SETTINGS.isDisplayMissingSpecials()) {
                        this.addDummySpecials();
                        break;
                    }
                    this.removeDummySpecials();
                }
            }
        });
    }

    private void addDummyEpisodes() {
        for (TvShow tvShow : this.tvShowList.getTvShows()) {
            for (TvShowEpisode episode : tvShow.getEpisodesForDisplay()) {
                if (!episode.isDummy()) continue;
                this.addTvShowEpisode(episode);
            }
        }
    }

    private void removeDummyEpisodes() {
        for (TvShow tvShow : this.tvShowList.getTvShows()) {
            for (TvShowEpisode episode : tvShow.getDummyEpisodes()) {
                if (!episode.isDummy()) continue;
                this.removeTvShowEpisode(episode);
            }
            for (TvShowSeason season : tvShow.getSeasons()) {
                if (!season.isDummy()) continue;
                this.removeTvShowSeason(season);
            }
        }
    }

    private void addDummySpecials() {
        for (TvShow tvShow : this.tvShowList.getTvShows()) {
            for (TvShowEpisode episode : tvShow.getEpisodesForDisplay()) {
                if (!episode.isDummy() || episode.getSeason() != 0) continue;
                this.addTvShowEpisode(episode);
            }
        }
    }

    private void removeDummySpecials() {
        for (TvShow tvShow : this.tvShowList.getTvShows()) {
            for (TvShowEpisode episode : tvShow.getDummyEpisodes()) {
                if (!episode.isDummy() || episode.getSeason() != 0) continue;
                this.removeTvShowEpisode(episode);
            }
            for (TvShowSeason season : tvShow.getSeasons()) {
                if (season.getSeason() != 0 || !season.isDummy()) continue;
                this.removeTvShowSeason(season);
            }
        }
    }

    private void nodeChanged(Object source) {
        TmmTreeNode node = this.getNodeFromCache(source);
        if (node != null) {
            this.firePropertyChange("nodeChanged", null, node);
        }
    }

    @Override
    public TmmTreeNode getRoot() {
        return this.root;
    }

    @Override
    public TmmTreeNode getParent(TmmTreeNode child) {
        if (child.getUserObject() instanceof TvShow) {
            return this.root;
        }
        if (child.getUserObject() instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)child.getUserObject();
            TmmTreeNode node = this.getNodeFromCache(season.getTvShow());
            if (node == null) {
                node = this.addTvShow(season.getTvShow());
            }
            return node;
        }
        if (child.getUserObject() instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)child.getUserObject();
            TmmTreeNode node = this.getNodeFromCache(episode.getTvShowSeason());
            if (node == null) {
                node = this.addTvShowSeason(episode.getTvShowSeason());
            }
            if (this.getNodeFromCache(episode.getTvShow()) == null) {
                this.addTvShow(episode.getTvShow());
            }
            return node;
        }
        return null;
    }

    @Override
    public List<TmmTreeNode> getChildren(TmmTreeNode parent) {
        if (parent == this.root) {
            ArrayList<TmmTreeNode> nodes = new ArrayList<TmmTreeNode>();
            for (TvShow tvShow : new ArrayList<TvShow>(this.tvShowList.getTvShows())) {
                TvShowTreeNode node = new TvShowTreeNode((Object)tvShow, this);
                this.putNodeToCache(tvShow, node);
                nodes.add(node);
                tvShow.addPropertyChangeListener(this.tvShowPropertyChangeListener);
            }
            return nodes;
        }
        if (parent.getUserObject() instanceof TvShow) {
            TvShow tvShow = (TvShow)parent.getUserObject();
            ArrayList<TmmTreeNode> nodes = new ArrayList<TmmTreeNode>();
            for (TvShowSeason season : tvShow.getSeasons()) {
                TvShowSeasonTreeNode node = new TvShowSeasonTreeNode((Object)season, this);
                this.putNodeToCache(season, node);
                nodes.add(node);
            }
            return nodes;
        }
        if (parent.getUserObject() instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)parent.getUserObject();
            ArrayList<TmmTreeNode> nodes = new ArrayList<TmmTreeNode>();
            for (TvShowEpisode episode : season.getEpisodesForDisplay()) {
                TmmTreeNode node = this.getNodeFromCache(episode);
                if (node == null) {
                    node = new TvShowEpisodeTreeNode((Object)episode, this);
                    this.putNodeToCache(episode, node);
                }
                nodes.add(node);
                episode.addPropertyChangeListener(this.episodePropertyChangeListener);
            }
            return nodes;
        }
        return null;
    }

    @Override
    public boolean isLeaf(TmmTreeNode node) {
        return node.getUserObject() instanceof TvShowEpisode;
    }

    @Override
    public Comparator<TmmTreeNode> getTreeComparator() {
        return super.getTreeComparator();
    }

    private TmmTreeNode addTvShow(TvShow tvShow) {
        TmmTreeNode cachedNode = this.getNodeFromCache(tvShow);
        if (cachedNode != null) {
            return cachedNode;
        }
        TvShowTreeNode node = new TvShowTreeNode((Object)tvShow, this);
        this.putNodeToCache(tvShow, node);
        this.firePropertyChange("nodeInserted", null, node);
        tvShow.addPropertyChangeListener(this.tvShowPropertyChangeListener);
        return node;
    }

    private void removeTvShow(TvShow tvShow) {
        tvShow.removePropertyChangeListener(this.tvShowPropertyChangeListener);
        TmmTreeNode cachedNode = this.removeNodeFromCache(tvShow);
        if (cachedNode == null) {
            return;
        }
        for (TvShowSeason season : tvShow.getSeasons()) {
            this.removeNodeFromCache(season);
        }
        for (TvShowEpisode episode : tvShow.getEpisodesForDisplay()) {
            this.removeNodeFromCache(episode);
        }
        this.firePropertyChange("nodeRemoved", null, cachedNode);
    }

    private TmmTreeNode addTvShowSeason(TvShowSeason season) {
        TmmTreeNode cachedNode = this.getNodeFromCache(season);
        if (cachedNode != null) {
            return cachedNode;
        }
        TvShowSeasonTreeNode node = new TvShowSeasonTreeNode((Object)season, this);
        this.putNodeToCache(season, node);
        this.firePropertyChange("nodeInserted", null, node);
        return node;
    }

    private TmmTreeNode addTvShowEpisode(TvShowEpisode episode) {
        TmmTreeNode cachedNode = this.getNodeFromCache(episode);
        if (cachedNode != null) {
            return cachedNode;
        }
        TvShowEpisodeTreeNode node = new TvShowEpisodeTreeNode((Object)episode, this);
        this.putNodeToCache(episode, node);
        this.firePropertyChange("nodeInserted", null, node);
        episode.addPropertyChangeListener(this.episodePropertyChangeListener);
        return node;
    }

    private void removeTvShowEpisode(TvShowEpisode episode) {
        episode.removePropertyChangeListener(this.episodePropertyChangeListener);
        TmmTreeNode cachedNode = this.removeNodeFromCache(episode);
        if (cachedNode == null) {
            return;
        }
        this.firePropertyChange("nodeRemoved", null, cachedNode);
        for (TvShowSeason season : episode.getTvShow().getSeasons()) {
            if (!season.getEpisodes().isEmpty()) continue;
            this.removeTvShowSeason(season);
        }
    }

    private void removeTvShowSeason(TvShowSeason season) {
        season.removePropertyChangeListener(this.episodePropertyChangeListener);
        TmmTreeNode cachedNode = this.removeNodeFromCache(season);
        if (cachedNode == null) {
            return;
        }
        this.firePropertyChange("nodeRemoved", null, cachedNode);
    }

    public static class TvShowEpisodeTreeNode
    extends AbstractTvShowTreeNode {
        private static final long serialVersionUID = -7108614568808831980L;

        public TvShowEpisodeTreeNode(Object userObject, TmmTreeDataProvider dataProvider) {
            super(userObject, dataProvider);
        }

        @Override
        public String toString() {
            if (this.getUserObject() instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)this.getUserObject();
                if (episode.getEpisode() >= 0) {
                    return episode.getEpisode() + ". " + episode.getTitle();
                }
                return episode.getTitleSortable();
            }
            return super.toString();
        }

        @Override
        public String getTitle() {
            if (this.getUserObject() instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)this.getUserObject();
                return episode.getTitle();
            }
            return this.toString();
        }

        @Override
        public String getOriginalTitle() {
            if (this.getUserObject() instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)this.getUserObject();
                return episode.getOriginalTitle();
            }
            return this.toString();
        }
    }

    public static class TvShowSeasonTreeNode
    extends AbstractTvShowTreeNode {
        private static final long serialVersionUID = -5734830011018805194L;

        public TvShowSeasonTreeNode(Object userObject, TmmTreeDataProvider dataProvider) {
            super(userObject, dataProvider);
        }

        @Override
        public String toString() {
            if (this.getUserObject() instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)this.getUserObject();
                if (StringUtils.isNotBlank((CharSequence)season.getTitle())) {
                    return season.getTitle();
                }
                if (season.getSeason() == -1) {
                    return BUNDLE.getString("tvshow.uncategorized");
                }
                if (season.getSeason() == 0) {
                    return BUNDLE.getString("metatag.specials");
                }
                return BUNDLE.getString("metatag.season") + " " + season.getSeason();
            }
            return super.toString();
        }

        @Override
        public String getTitle() {
            return this.toString();
        }

        @Override
        public String getOriginalTitle() {
            return this.toString();
        }
    }

    public static class TvShowTreeNode
    extends AbstractTvShowTreeNode {
        private static final long serialVersionUID = -1316609340104597133L;

        TvShowTreeNode(Object userObject, TmmTreeDataProvider dataProvider) {
            super(userObject, dataProvider);
        }

        @Override
        public String toString() {
            if (this.getUserObject() instanceof TvShow) {
                TvShow tvShow = (TvShow)this.getUserObject();
                return tvShow.getTitleSortable();
            }
            return super.toString();
        }

        @Override
        public String getTitle() {
            if (this.getUserObject() instanceof TvShow) {
                TvShow tvShow = (TvShow)this.getUserObject();
                return tvShow.getTitle();
            }
            return this.toString();
        }

        @Override
        public String getOriginalTitle() {
            if (this.getUserObject() instanceof TvShow) {
                TvShow tvShow = (TvShow)this.getUserObject();
                return tvShow.getOriginalTitle();
            }
            return this.toString();
        }
    }

    static abstract class AbstractTvShowTreeNode
    extends TmmTreeNode {
        AbstractTvShowTreeNode(Object userObject, TmmTreeDataProvider dataProvider) {
            super(userObject, dataProvider);
        }

        abstract String getTitle();

        abstract String getOriginalTitle();
    }

    class TvShowComparator
    implements Comparator<TmmTreeNode> {
        TvShowComparator() {
        }

        @Override
        public int compare(TmmTreeNode o1, TmmTreeNode o2) {
            Object userObject1 = o1.getUserObject();
            Object userObject2 = o2.getUserObject();
            if (userObject1 instanceof TvShow && userObject2 instanceof TvShow) {
                TvShow tvShow1 = (TvShow)userObject1;
                TvShow tvShow2 = (TvShow)userObject2;
                if (TvShowTreeDataProvider.this.stringCollator != null) {
                    return TvShowTreeDataProvider.this.stringCollator.compare(tvShow1.getTitleSortable().toLowerCase(Locale.ROOT), tvShow2.getTitleSortable().toLowerCase(Locale.ROOT));
                }
                return tvShow1.getTitleSortable().compareToIgnoreCase(tvShow2.getTitleSortable());
            }
            if (userObject1 instanceof TvShowSeason && userObject2 instanceof TvShowSeason) {
                TvShowSeason tvShowSeason1 = (TvShowSeason)userObject1;
                TvShowSeason tvShowSeason2 = (TvShowSeason)userObject2;
                return tvShowSeason1.getSeason() - tvShowSeason2.getSeason();
            }
            if (userObject1 instanceof TvShowEpisode && userObject2 instanceof TvShowEpisode) {
                TvShowEpisode tvShowEpisode1 = (TvShowEpisode)userObject1;
                TvShowEpisode tvShowEpisode2 = (TvShowEpisode)userObject2;
                return tvShowEpisode1.getEpisode() - tvShowEpisode2.getEpisode();
            }
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    }
}

