/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.dialogs.CleanUpUnwantedFilesDialog;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowCleanUpFilesAction
extends TmmAction {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowCleanUpFilesAction() {
        this.putValue("Name", BUNDLE.getString("cleanupfiles"));
        this.putValue("ShortDescription", BUNDLE.getString("cleanupfiles.desc"));
        this.putValue("SmallIcon", IconManager.DELETE);
        this.putValue("SwingLargeIconKey", IconManager.DELETE);
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<MediaEntity> selectedTvShows = new ArrayList<MediaEntity>(TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows());
        if (selectedTvShows.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        CleanUpUnwantedFilesDialog dialog = new CleanUpUnwantedFilesDialog(selectedTvShows);
        dialog.setVisible(true);
    }
}

