/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowMissingEpisodeListDialog;

public class TvShowMissingEpisodeListAction
extends TmmAction {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowMissingEpisodeListAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.missingepisodelist"));
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.missingepisodelist.desc"));
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, 192));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Object> selectedObjects = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects();
        ArrayList<TvShow> selectedTvShows = new ArrayList<TvShow>();
        for (Object obj : selectedObjects) {
            TvShowSeason tvShowSeason;
            if (obj instanceof TvShow) {
                TvShow tvShow = (TvShow)obj;
                selectedTvShows.add(tvShow);
            }
            if (!(obj instanceof TvShowSeason) || selectedTvShows.contains((tvShowSeason = (TvShowSeason)obj).getTvShow())) continue;
            selectedTvShows.add(tvShowSeason.getTvShow());
        }
        if (selectedTvShows.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        TvShowMissingEpisodeListDialog dialog = new TvShowMissingEpisodeListDialog(selectedTvShows);
        dialog.setVisible(true);
    }
}

