/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.thirdparty.trakttv.SyncTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowSyncSelectedTraktTvAction
extends TmmAction {
    private static final long serialVersionUID = 6640292090443882545L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowSyncSelectedTraktTvAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.synctrakt.selected"));
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.synctrakt.selected.desc"));
        this.putValue("SmallIcon", IconManager.SYNC);
        this.putValue("SwingLargeIconKey", IconManager.SYNC);
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        if (selectedTvShows.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        SyncTraktTvTask task = new SyncTraktTvTask(null, selectedTvShows);
        TmmTaskManager.getInstance().addUnnamedTask(task);
    }
}

