/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.tasks.TvShowUpdateDatasourceTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowUpdateAction
extends TmmAction {
    private static final long serialVersionUID = 7216738427209633666L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowUpdateAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.update"));
        this.putValue("SwingLargeIconKey", IconManager.REFRESH);
        this.putValue("SmallIcon", IconManager.REFRESH);
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        ArrayList<Path> tvShowFolders = new ArrayList<Path>();
        if (selectedTvShows.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        for (TvShow tvShow : selectedTvShows) {
            tvShowFolders.add(tvShow.getPathNIO());
        }
        TvShowUpdateDatasourceTask task = new TvShowUpdateDatasourceTask(tvShowFolders);
        TmmTaskManager.getInstance().addMainTask(task);
    }
}

