/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmWindowSaver;
import org.tinymediamanager.ui.components.MainTabbedPane;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.TmmTreeTable;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.tvshows.filters.ITvShowUIFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowAspectRatioFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowAudioChannelFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowAudioCodecFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowCastFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowDatasourceFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowDuplicateEpisodesFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowEmptyFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowFrameRateFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowGenreFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowMediaSourceFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowMissingArtworkFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowMissingEpisodesFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowMissingMetadataFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowMissingSubtitlesFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowNewEpisodesFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowStatusFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowStudioFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowTagFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowVideoCodecFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowVideoContainerFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowVideoFormatFilter;
import org.tinymediamanager.ui.tvshows.filters.TvShowWatchedFilter;

public class TvShowFilterDialog
extends TmmDialog {
    private static final long serialVersionUID = 2298540526328945319L;
    protected static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TmmTreeTable treeTable;
    private final Map<JPanel, Set<ITvShowUIFilter>> filterMap;
    private JTabbedPane tabbedPane;

    public TvShowFilterDialog(TmmTreeTable treeTable) {
        super(BUNDLE.getString("movieextendedsearch.options"), "tvShowFilter");
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.treeTable = treeTable;
        this.filterMap = new HashMap<JPanel, Set<ITvShowUIFilter>>();
        this.treeTable.addPropertyChangeListener("filterChanged", evt -> this.filterChanged());
        this.tabbedPane = new MainTabbedPane(){
            private static final long serialVersionUID = 9041548865608767661L;

            @Override
            public void updateUI() {
                this.putClientProperty("leftBorder", "half");
                this.putClientProperty("rightBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel panelMain = new JPanel((LayoutManager)new MigLayout("", "[][][100lp:n,grow]", "[]"));
        JScrollPane scrollPaneMain = new JScrollPane(panelMain);
        scrollPaneMain.setHorizontalScrollBarPolicy(31);
        this.tabbedPane.addTab(BUNDLE.getString("metatag.details"), scrollPaneMain);
        panelMain.add((Component)new TmmLabel(BUNDLE.getString("movieextendedsearch.filterby")), "cell 0 0 3 1, growx, aligny top, wrap");
        this.addFilter(new TvShowNewEpisodesFilter(), panelMain);
        this.addFilter(new TvShowDuplicateEpisodesFilter(), panelMain);
        this.addFilter(new TvShowWatchedFilter(), panelMain);
        this.addFilter(new TvShowStatusFilter(), panelMain);
        this.addFilter(new TvShowGenreFilter(), panelMain);
        this.addFilter(new TvShowStudioFilter(), panelMain);
        this.addFilter(new TvShowCastFilter(), panelMain);
        this.addFilter(new TvShowTagFilter(), panelMain);
        this.addFilter(new TvShowEmptyFilter(), panelMain);
        JPanel panelMediaData = new JPanel((LayoutManager)new MigLayout("", "[][][150lp:n,grow]", "[]"));
        JScrollPane scrollPaneMediaData = new JScrollPane(panelMediaData);
        scrollPaneMediaData.setHorizontalScrollBarPolicy(31);
        this.tabbedPane.addTab(BUNDLE.getString("metatag.mediainformation"), scrollPaneMediaData);
        panelMediaData.add((Component)new TmmLabel(BUNDLE.getString("movieextendedsearch.filterby")), "cell 0 0 3 1, growx, aligny top, wrap");
        this.addFilter(new TvShowVideoFormatFilter(), panelMediaData);
        this.addFilter(new TvShowVideoCodecFilter(), panelMediaData);
        this.addFilter(new TvShowAspectRatioFilter(), panelMediaData);
        this.addFilter(new TvShowFrameRateFilter(), panelMediaData);
        this.addFilter(new TvShowVideoContainerFilter(), panelMediaData);
        this.addFilter(new TvShowAudioCodecFilter(), panelMediaData);
        this.addFilter(new TvShowAudioChannelFilter(), panelMediaData);
        this.addFilter(new TvShowMediaSourceFilter(), panelMediaData);
        this.addFilter(new TvShowDatasourceFilter(), panelMediaData);
        this.addFilter(new TvShowMissingMetadataFilter(), panelMediaData);
        this.addFilter(new TvShowMissingArtworkFilter(), panelMediaData);
        this.addFilter(new TvShowMissingSubtitlesFilter(), panelMediaData);
        this.addFilter(new TvShowMissingEpisodesFilter(), panelMediaData);
    }

    private void addFilter(ITvShowUIFilter<TmmTreeNode> filter, JPanel panel) {
        panel.add((Component)filter.getCheckBox(), "");
        panel.add((Component)filter.getLabel(), "right");
        if (filter.getFilterComponent() != null) {
            panel.add((Component)filter.getFilterComponent(), "wmin 100, grow, wrap");
        } else {
            panel.add(Box.createGlue(), "wrap");
        }
        Set filters = this.filterMap.computeIfAbsent(panel, k -> new HashSet());
        filters.add(filter);
        this.treeTable.addFilter(filter);
    }

    private void filterChanged() {
        block3: for (Map.Entry<JPanel, Set<ITvShowUIFilter>> entry : this.filterMap.entrySet()) {
            boolean active = false;
            for (ITvShowUIFilter filter : entry.getValue()) {
                switch (filter.getFilterState()) {
                    case ACTIVE: 
                    case ACTIVE_NEGATIVE: {
                        active = true;
                        break;
                    }
                }
                if (!active) continue;
                break;
            }
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                if (!SwingUtilities.isDescendingFrom(entry.getKey(), this.tabbedPane.getComponentAt(i))) continue;
                if (active) {
                    this.tabbedPane.setIconAt(i, IconManager.FILTER_ACTIVE);
                    continue block3;
                }
                this.tabbedPane.setIconAt(i, null);
                continue block3;
            }
        }
    }

    @Override
    protected void initBottomPanel() {
    }

    @Override
    public void dispose() {
        TmmWindowSaver.getInstance().saveSettings(this);
    }
}

