/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.components.combobox.MediaScraperComboBox;
import org.tinymediamanager.ui.components.combobox.ScraperMetadataConfigCheckComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class TvShowScrapeMetadataDialog
extends TmmDialog {
    private static final long serialVersionUID = 6120530120703772160L;
    private boolean startScrape = false;
    private JComboBox cbLanguage;
    private MediaScraperComboBox cbMetadataScraper;
    private MediaScraperCheckComboBox cbArtworkScraper;
    private MediaScraperCheckComboBox cbTrailerScraper;
    private ScraperMetadataConfigCheckComboBox<TvShowScraperMetadataConfig> cbTvShowScraperConfig;
    private ScraperMetadataConfigCheckComboBox<TvShowEpisodeScraperMetadataConfig> cbEpisodeScraperConfig;

    public TvShowScrapeMetadataDialog(String title) {
        this(title, true, true, true, true, true);
    }

    public TvShowScrapeMetadataDialog(String title, boolean metadata, boolean artwork, boolean tvShowMetadata, boolean episodeMetadata, boolean trailer) {
        super(title, "tvShowUpdateMetadata");
        List<Enum> config;
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("hidemode 3", "[][600lp:800lp,grow]", "[][][][][shrink 0][200lp:n, grow]"));
        TmmLabel lblLanguageT = new TmmLabel(BUNDLE.getString("metatag.language"));
        panelContent.add((Component)lblLanguageT, "cell 0 0,alignx trailing");
        this.cbLanguage = new JComboBox<MediaLanguages>(MediaLanguages.valuesSorted());
        this.cbLanguage.setSelectedItem((Object)TvShowModuleManager.SETTINGS.getScraperLanguage());
        panelContent.add((Component)this.cbLanguage, "cell 1 0,growx");
        if (metadata) {
            TmmLabel lblMetadataScraperT = new TmmLabel(BUNDLE.getString("scraper.metadata"));
            panelContent.add((Component)lblMetadataScraperT, "cell 0 1,alignx trailing");
            this.cbMetadataScraper = new MediaScraperComboBox(TvShowList.getInstance().getAvailableMediaScrapers());
            panelContent.add((Component)this.cbMetadataScraper, "cell 1 1,growx");
        }
        if (artwork) {
            TmmLabel lblArtworkScraper = new TmmLabel(BUNDLE.getString("scraper.artwork"));
            panelContent.add((Component)lblArtworkScraper, "cell 0 2,alignx trailing");
            this.cbArtworkScraper = new MediaScraperCheckComboBox(TvShowList.getInstance().getAvailableArtworkScrapers());
            panelContent.add((Component)this.cbArtworkScraper, "cell 1 2,growx");
        }
        if (trailer) {
            TmmLabel lblTrailerScraper = new TmmLabel(BUNDLE.getString("scraper.trailer"));
            panelContent.add((Component)lblTrailerScraper, "cell 0 3,alignx right");
            this.cbTrailerScraper = new MediaScraperCheckComboBox(TvShowList.getInstance().getAvailableTrailerScrapers());
            panelContent.add((Component)this.cbTrailerScraper, "cell 1 3,growx");
        }
        JSeparator separator = new JSeparator();
        panelContent.add((Component)separator, "cell 0 4 2 1,growx");
        if (artwork || tvShowMetadata || episodeMetadata) {
            JPanel panelScraperConfig = new JPanel();
            panelContent.add((Component)panelScraperConfig, "cell 0 5 2 1,grow");
            panelScraperConfig.setLayout((LayoutManager)new MigLayout("hidemode 3", "[][300lp:500lp,grow]", "[][][]"));
            TmmLabel lblScrapeFollowingItems = new TmmLabel(BUNDLE.getString("chooser.scrape"));
            panelScraperConfig.add((Component)lblScrapeFollowingItems, "cell 0 0 2 1");
            if (artwork || tvShowMetadata) {
                TmmLabel lblTvShowsT = new TmmLabel(BUNDLE.getString("metatag.tvshows"));
                panelScraperConfig.add((Component)lblTvShowsT, "cell 0 1,alignx trailing");
                this.cbTvShowScraperConfig = new ScraperMetadataConfigCheckComboBox((ScraperMetadataConfig[])TvShowScraperMetadataConfig.values());
                panelScraperConfig.add(this.cbTvShowScraperConfig, "cell 1 1,grow, wmin 0");
            }
            if (artwork || episodeMetadata) {
                TmmLabel lblEpisodesT = new TmmLabel(BUNDLE.getString("metatag.episodes"));
                panelScraperConfig.add((Component)lblEpisodesT, "cell 0 2,alignx trailing");
                this.cbEpisodeScraperConfig = new ScraperMetadataConfigCheckComboBox((ScraperMetadataConfig[])TvShowEpisodeScraperMetadataConfig.values());
                panelScraperConfig.add(this.cbEpisodeScraperConfig, "cell 1 2,grow, wmin 0");
            }
        }
        JButton btnCancel = new JButton(BUNDLE.getString("Button.cancel"));
        btnCancel.setIcon(IconManager.CANCEL_INV);
        btnCancel.addActionListener(e -> {
            this.startScrape = false;
            this.setVisible(false);
        });
        this.addButton(btnCancel);
        JButton btnStart = new JButton(BUNDLE.getString("scraper.start"));
        btnStart.setIcon(IconManager.APPLY_INV);
        btnStart.addActionListener(e -> {
            this.startScrape = true;
            this.setVisible(false);
        });
        this.addDefaultButton(btnStart);
        if (this.cbMetadataScraper != null) {
            MediaScraper defaultScraper = TvShowList.getInstance().getDefaultMediaScraper();
            this.cbMetadataScraper.setSelectedItem(defaultScraper);
        }
        if (this.cbArtworkScraper != null) {
            ArrayList<MediaScraper> selectedArtworkScrapers = new ArrayList<MediaScraper>();
            for (MediaScraper artworkScraper : TvShowList.getInstance().getAvailableArtworkScrapers()) {
                if (!TvShowModuleManager.SETTINGS.getArtworkScrapers().contains(artworkScraper.getId())) continue;
                selectedArtworkScrapers.add(artworkScraper);
            }
            if (!selectedArtworkScrapers.isEmpty()) {
                this.cbArtworkScraper.setSelectedItems(selectedArtworkScrapers);
            }
        }
        if (this.cbTrailerScraper != null) {
            ArrayList<MediaScraper> selectedTrailerScrapers = new ArrayList<MediaScraper>();
            for (MediaScraper trailerScraper : TvShowList.getInstance().getAvailableTrailerScrapers()) {
                if (!TvShowModuleManager.SETTINGS.getTrailerScrapers().contains(trailerScraper.getId())) continue;
                selectedTrailerScrapers.add(trailerScraper);
            }
            if (!selectedTrailerScrapers.isEmpty()) {
                this.cbTrailerScraper.setSelectedItems(selectedTrailerScrapers);
            }
        }
        if (this.cbTvShowScraperConfig != null) {
            config = new ArrayList<TvShowScraperMetadataConfig>(TvShowModuleManager.SETTINGS.getTvShowScraperMetadataConfig());
            if (artwork && !tvShowMetadata) {
                config = config.stream().filter(ScraperMetadataConfig::isArtwork).collect(Collectors.toList());
            }
            this.cbTvShowScraperConfig.setSelectedItems(config);
        }
        if (this.cbEpisodeScraperConfig != null) {
            config = new ArrayList<TvShowEpisodeScraperMetadataConfig>(TvShowModuleManager.SETTINGS.getEpisodeScraperMetadataConfig());
            if (artwork && !episodeMetadata) {
                config = config.stream().filter(ScraperMetadataConfig::isArtwork).collect(Collectors.toList());
            }
            this.cbEpisodeScraperConfig.setSelectedItems(config);
        }
    }

    public TvShowSearchAndScrapeOptions getTvShowSearchAndScrapeOptions() {
        TvShowSearchAndScrapeOptions tvShowSearchAndScrapeConfig = new TvShowSearchAndScrapeOptions();
        tvShowSearchAndScrapeConfig.setLanguage((MediaLanguages)((Object)this.cbLanguage.getSelectedItem()));
        if (this.cbMetadataScraper != null) {
            tvShowSearchAndScrapeConfig.setMetadataScraper((MediaScraper)this.cbMetadataScraper.getSelectedItem());
        }
        if (this.cbArtworkScraper != null) {
            tvShowSearchAndScrapeConfig.setArtworkScraper(this.cbArtworkScraper.getSelectedItems());
        }
        if (this.cbTrailerScraper != null) {
            tvShowSearchAndScrapeConfig.setTrailerScraper(this.cbTrailerScraper.getSelectedItems());
        }
        return tvShowSearchAndScrapeConfig;
    }

    public TvShowEpisodeSearchAndScrapeOptions getTvShowEpisodeSearchAndScrapeOptions() {
        TvShowEpisodeSearchAndScrapeOptions episodeSearchAndScrapeOptions = new TvShowEpisodeSearchAndScrapeOptions();
        episodeSearchAndScrapeOptions.setLanguage((MediaLanguages)((Object)this.cbLanguage.getSelectedItem()));
        episodeSearchAndScrapeOptions.setMetadataScraper((MediaScraper)this.cbMetadataScraper.getSelectedItem());
        episodeSearchAndScrapeOptions.setArtworkScraper(this.cbArtworkScraper.getSelectedItems());
        return episodeSearchAndScrapeOptions;
    }

    public List<TvShowScraperMetadataConfig> getTvShowScraperMetadataConfig() {
        return this.cbTvShowScraperConfig.getSelectedItems();
    }

    public List<TvShowEpisodeScraperMetadataConfig> getTvShowEpisodeScraperMetadataConfig() {
        return this.cbEpisodeScraperConfig.getSelectedItems();
    }

    public boolean shouldStartScrape() {
        return this.startScrape;
    }
}

