/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.ShadowLayerUI;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.MainTabbedPane;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class TvShowSeasonEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = 3270218410302989845L;
    private static final String ORIGINAL_IMAGE_SIZE = "originalImageSize";
    private static final String SPACER = "        ";
    private TvShowSeason tvShowSeasonToEdit;
    private TvShowList tvShowList = TvShowList.getInstance();
    private boolean continueQueue = true;
    private boolean navigateBack = false;
    private int queueIndex;
    private int queueSize;
    private ImageLabel lblPoster;
    private ImageLabel lblBanner;
    private ImageLabel lblThumb;
    private JTextField tfPoster;
    private JTextField tfBanner;
    private JTextField tfThumb;
    private JTextField tfTitle;

    public TvShowSeasonEditorDialog(TvShowSeason tvShowSeason, int queueIndex, int queueSize) {
        super(BUNDLE.getString("tvshowseason.edit") + (queueSize > 1 ? " " + (queueIndex + 1) + "/" + queueSize : ""), "tvShowSeasonEditor");
        this.tvShowSeasonToEdit = tvShowSeason;
        this.queueIndex = queueIndex;
        this.queueSize = queueSize;
        this.initComponents();
        this.tfTitle.setText(tvShowSeason.getTitle());
        this.lblPoster.setImagePath(tvShowSeason.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_POSTER));
        this.lblThumb.setImagePath(tvShowSeason.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_THUMB));
        this.lblBanner.setImagePath(tvShowSeason.getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_BANNER));
        this.tfPoster.setText(tvShowSeason.getArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_POSTER));
        this.tfThumb.setText(tvShowSeason.getArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_THUMB));
        this.tfBanner.setText(tvShowSeason.getArtworkUrl(MediaArtwork.MediaArtworkType.SEASON_BANNER));
    }

    private void initComponents() {
        MainTabbedPane tabbedPane = new MainTabbedPane(){
            private static final long serialVersionUID = 71548865608767532L;

            @Override
            public void updateUI() {
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        JLayer<JComponent> rootLayer = new JLayer<JComponent>(tabbedPane, new ShadowLayerUI());
        this.getContentPane().add(rootLayer, "Center");
        JPanel artworkPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.details"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[200lp:300lp,grow][20lp:n][200lp:300lp,grow]", "[][][100lp:125lp,grow][20lp:n][][100lp:125lp,grow]"));
        TmmLabel lblTitleT = new TmmLabel(BUNDLE.getString("metatag.title"));
        artworkPanel.add((Component)lblTitleT, "flowx,cell 0 0 3 1");
        TmmLabel lblPosterT = new TmmLabel(BUNDLE.getString("mediafiletype.poster"));
        artworkPanel.add((Component)lblPosterT, "cell 0 1");
        LinkLabel lblPosterSize = new LinkLabel();
        artworkPanel.add((Component)lblPosterSize, "cell 0 1");
        FlatButton btnDeletePoster = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeletePoster.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeletePoster.addActionListener(e -> {
            this.lblPoster.clearImage();
            this.tfPoster.setText("");
        });
        artworkPanel.add((Component)btnDeletePoster, "cell 0 1");
        this.lblPoster = new ImageLabel();
        this.lblPoster.setCursor(Cursor.getPredefinedCursor(12));
        this.lblPoster.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HashMap<String, Object> ids = new HashMap<String, Object>(TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getTvShow().getIds());
                ids.put("tvShowSeason", TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getSeason());
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowSeasonEditorDialog.this, ids, ImageChooserDialog.ImageType.SEASON_POSTER, TvShowSeasonEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowSeasonEditorDialog.this.lblPoster, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                TvShowSeasonEditorDialog.this.updateArtworkUrl(TvShowSeasonEditorDialog.this.lblPoster, TvShowSeasonEditorDialog.this.tfPoster);
            }
        });
        artworkPanel.add((Component)this.lblPoster, "cell 0 2,grow");
        this.lblPoster.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblPosterSize, this.lblPoster, MediaArtwork.MediaArtworkType.SEASON_POSTER));
        TmmLabel lblThumbT = new TmmLabel(BUNDLE.getString("mediafiletype.thumb"));
        artworkPanel.add((Component)lblThumbT, "cell 2 1");
        LinkLabel lblThumbSize = new LinkLabel();
        artworkPanel.add((Component)lblThumbSize, "cell 2 1");
        FlatButton btnDeleteThumb = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteThumb.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeleteThumb.addActionListener(e -> {
            this.lblThumb.clearImage();
            this.tfThumb.setText("");
        });
        artworkPanel.add((Component)btnDeleteThumb, "cell 2 1");
        this.lblThumb = new ImageLabel();
        this.lblThumb.setCursor(Cursor.getPredefinedCursor(12));
        this.lblThumb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HashMap<String, Object> ids = new HashMap<String, Object>(TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getTvShow().getIds());
                ids.put("tvShowSeason", TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getSeason());
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowSeasonEditorDialog.this, ids, ImageChooserDialog.ImageType.SEASON_THUMB, TvShowSeasonEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowSeasonEditorDialog.this.lblThumb, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                TvShowSeasonEditorDialog.this.updateArtworkUrl(TvShowSeasonEditorDialog.this.lblThumb, TvShowSeasonEditorDialog.this.tfThumb);
            }
        });
        artworkPanel.add((Component)this.lblThumb, "cell 2 2,grow");
        this.lblThumb.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblThumbSize, this.lblThumb, MediaArtwork.MediaArtworkType.SEASON_THUMB));
        TmmLabel lblBannerT = new TmmLabel(BUNDLE.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "cell 0 4");
        LinkLabel lblBannerSize = new LinkLabel();
        artworkPanel.add((Component)lblBannerSize, "cell 0 4");
        FlatButton btnDeleteBanner = new FlatButton(SPACER, IconManager.DELETE_GRAY);
        btnDeleteBanner.setToolTipText(BUNDLE.getString("Button.deleteartwork.desc"));
        btnDeleteBanner.addActionListener(e -> {
            this.lblBanner.clearImage();
            this.tfBanner.setText("");
        });
        artworkPanel.add((Component)btnDeleteBanner, "cell 0 4");
        this.lblBanner = new ImageLabel();
        this.lblBanner.setCursor(Cursor.getPredefinedCursor(12));
        this.lblBanner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HashMap<String, Object> ids = new HashMap<String, Object>(TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getTvShow().getIds());
                ids.put("tvShowSeason", TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getSeason());
                ImageChooserDialog dialog = new ImageChooserDialog(TvShowSeasonEditorDialog.this, ids, ImageChooserDialog.ImageType.SEASON_BANNER, TvShowSeasonEditorDialog.this.tvShowList.getAvailableArtworkScrapers(), TvShowSeasonEditorDialog.this.lblBanner, null, null, MediaType.TV_SHOW);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                TvShowSeasonEditorDialog.this.updateArtworkUrl(TvShowSeasonEditorDialog.this.lblBanner, TvShowSeasonEditorDialog.this.tfBanner);
            }
        });
        artworkPanel.add((Component)this.lblBanner, "cell 0 5 3 1,grow");
        this.tfTitle = new JTextField();
        artworkPanel.add((Component)this.tfTitle, "cell 0 0,growx");
        this.tfTitle.setColumns(10);
        this.lblBanner.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(lblBannerSize, this.lblBanner, MediaArtwork.MediaArtworkType.SEASON_BANNER));
        artworkPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("edit.artwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][]"));
        TmmLabel lblPosterT2 = new TmmLabel(BUNDLE.getString("mediafiletype.poster"));
        artworkPanel.add((Component)lblPosterT2, "cell 0 0,alignx right");
        this.tfPoster = new JTextField();
        artworkPanel.add((Component)this.tfPoster, "cell 1 0,growx");
        TmmLabel lblBannerT2 = new TmmLabel(BUNDLE.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT2, "cell 0 1,alignx right");
        this.tfBanner = new JTextField();
        artworkPanel.add((Component)this.tfBanner, "cell 1 1,growx");
        TmmLabel lblThumbT2 = new TmmLabel(BUNDLE.getString("mediafiletype.thumb"));
        artworkPanel.add((Component)lblThumbT2, "cell 0 2,alignx right");
        this.tfThumb = new JTextField();
        artworkPanel.add((Component)this.tfThumb, "cell 1 2,growx");
        if (this.queueSize > 1) {
            JButton btnAbort = new JButton(new AbortAction());
            this.addButton(btnAbort);
            if (this.queueIndex > 0) {
                JButton backButton = new JButton(new NavigateBackAction());
                this.addButton(backButton);
            }
        }
        JButton cancelButton = new JButton(new CancelAction());
        this.addButton(cancelButton);
        JButton okButton = new JButton(new OKAction());
        this.addDefaultButton(okButton);
    }

    private void updateArtworkUrl(ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isNotBlank((CharSequence)imageLabel.getImageUrl())) {
            textField.setText(imageLabel.getImageUrl());
        }
    }

    private void setImageSizeAndCreateLink(LinkLabel lblSize, ImageLabel imageLabel, MediaArtwork.MediaArtworkType type) {
        TmmUIHelper.createLinkForImage(lblSize, imageLabel);
        if (imageLabel.getOriginalImageSize().width == 0 && imageLabel.getOriginalImageSize().height == 0) {
            lblSize.setText("");
            return;
        }
        Dimension dimension = this.tvShowSeasonToEdit.getArtworkSize(type);
        if (dimension.width == 0 && dimension.height == 0) {
            lblSize.setText(imageLabel.getOriginalImageSize().width + "x" + imageLabel.getOriginalImageSize().height);
        } else {
            lblSize.setText(dimension.width + "x" + dimension.height);
        }
    }

    private void processArtwork(MediaFileType type, ImageLabel imageLabel, JTextField textField) {
        MediaArtwork.MediaArtworkType artworkType = MediaFileType.getMediaArtworkType(type);
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{imageLabel.getImagePath(), imageLabel.getImageUrl()}) && StringUtils.isNotBlank((CharSequence)this.tvShowSeasonToEdit.getArtworkFilename(artworkType))) {
            this.tvShowSeasonToEdit.deleteArtworkFiles(artworkType);
        }
        if (StringUtils.isNotEmpty((CharSequence)textField.getText()) && !textField.getText().equals(this.tvShowSeasonToEdit.getArtworkUrl(artworkType))) {
            this.tvShowSeasonToEdit.setArtworkUrl(textField.getText(), artworkType);
            this.tvShowSeasonToEdit.downloadArtwork(artworkType);
        } else if (StringUtils.isEmpty((CharSequence)textField.getText())) {
            this.tvShowSeasonToEdit.removeArtworkUrl(artworkType);
        }
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    public boolean isContinueQueue() {
        return this.continueQueue;
    }

    public boolean isNavigateBack() {
        return this.navigateBack;
    }

    private class AbortAction
    extends AbstractAction {
        private static final long serialVersionUID = -7652218354710642510L;

        AbortAction() {
            this.putValue("Name", BUNDLE.getString("Button.abortqueue"));
            this.putValue("ShortDescription", BUNDLE.getString("tvshow.edit.abortqueue.desc"));
            this.putValue("SmallIcon", IconManager.STOP_INV);
            this.putValue("SwingLargeIconKey", IconManager.STOP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowSeasonEditorDialog.this.continueQueue = false;
            TvShowSeasonEditorDialog.this.setVisible(false);
        }
    }

    private class NavigateBackAction
    extends AbstractAction {
        private static final long serialVersionUID = -1652218154720642310L;

        public NavigateBackAction() {
            this.putValue("Name", BUNDLE.getString("Button.back"));
            this.putValue("SmallIcon", IconManager.BACK_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowSeasonEditorDialog.this.navigateBack = true;
            TvShowSeasonEditorDialog.this.setVisible(false);
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -4617793684152607277L;

        CancelAction() {
            this.putValue("Name", BUNDLE.getString("Button.cancel"));
            this.putValue("ShortDescription", BUNDLE.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
            this.putValue("SwingLargeIconKey", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowSeasonEditorDialog.this.setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction {
        private static final long serialVersionUID = 6699599213348390696L;

        OKAction() {
            this.putValue("Name", BUNDLE.getString("Button.ok"));
            this.putValue("ShortDescription", BUNDLE.getString("tvshow.change"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.setTitle(TvShowSeasonEditorDialog.this.tfTitle.getText());
            TvShowSeasonEditorDialog.this.processArtwork(MediaFileType.SEASON_POSTER, TvShowSeasonEditorDialog.this.lblPoster, TvShowSeasonEditorDialog.this.tfPoster);
            TvShowSeasonEditorDialog.this.processArtwork(MediaFileType.SEASON_BANNER, TvShowSeasonEditorDialog.this.lblBanner, TvShowSeasonEditorDialog.this.tfBanner);
            TvShowSeasonEditorDialog.this.processArtwork(MediaFileType.SEASON_THUMB, TvShowSeasonEditorDialog.this.lblThumb, TvShowSeasonEditorDialog.this.tfThumb);
            TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getTvShow().writeNFO();
            TvShowSeasonEditorDialog.this.tvShowSeasonToEdit.getTvShow().saveToDb();
            TvShowSeasonEditorDialog.this.setVisible(false);
        }
    }
}

