/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowAspectRatioFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    private static final String RATIO_1_33 = "4:3 (1.33:1)";
    private static final String RATIO_1_37 = "11:8 (1.37:1)";
    private static final String RATIO_1_43 = "IMAX (1.43:1)";
    private static final String RATIO_1_56 = "14:9 (1.56:1)";
    private static final String RATIO_1_66 = "5:3 (1.66:1)";
    private static final String RATIO_1_78 = "16:9 (1.77:1)";
    private static final String RATIO_1_85 = "Widescreen (1.85:1)";
    private static final String RATIO_1_90 = "Digital IMAX (1.90:1)";
    private static final String RATIO_2_20 = "70mm (2.20:1)";
    private static final String RATIO_2_35 = "Anamorphic (2.35:1)";
    private final String others = BUNDLE.getString("filter.others");

    public TvShowAspectRatioFilter() {
        this.setValues(RATIO_1_33, RATIO_1_37, RATIO_1_43, RATIO_1_56, RATIO_1_66, RATIO_1_78, RATIO_1_85, RATIO_1_90, RATIO_2_20, RATIO_2_35, this.others);
    }

    @Override
    public String getId() {
        return "tvShowAspectRatio";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List<String> selectedItems = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            MediaFile mf = episode.getMainVideoFile();
            if (!(invert ^ this.containsAspectRatio(mf, selectedItems))) continue;
            return true;
        }
        return false;
    }

    private boolean containsAspectRatio(MediaFile mediaFile, List<String> selectedItems) {
        float aspectRatio = mediaFile.getAspectRatio();
        for (String ratios : selectedItems) {
            if (!(aspectRatio == 1.33f ? ratios.equals(RATIO_1_33) : (aspectRatio == 1.37f ? ratios.equals(RATIO_1_37) : (aspectRatio == 1.43f ? ratios.equals(RATIO_1_43) : (aspectRatio == 1.56f ? ratios.equals(RATIO_1_56) : (aspectRatio == 1.66f ? ratios.equals(RATIO_1_66) : (aspectRatio == 1.78f ? ratios.equals(RATIO_1_78) : (aspectRatio == 1.85f ? ratios.equals(RATIO_1_85) : (aspectRatio == 1.9f ? ratios.equals(RATIO_1_90) : (aspectRatio == 2.2f ? ratios.equals(RATIO_2_20) : (aspectRatio == 2.35f ? ratios.equals(RATIO_2_35) : ratios.equals(this.others)))))))))))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.aspect"));
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

