/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowFrameRateFilter
extends AbstractCheckComboBoxTvShowUIFilter<Double> {
    private TvShowList tvShowList = TvShowList.getInstance();

    public TvShowFrameRateFilter() {
        this.buildAndInstallCodecArray();
        PropertyChangeListener propertyChangeListener = evt -> this.buildAndInstallCodecArray();
        this.tvShowList.addPropertyChangeListener("frameRate", propertyChangeListener);
    }

    @Override
    public String getId() {
        return "tvShowFrameRate";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List frameRates = this.checkComboBox.getSelectedItems();
        for (Double frameRate : frameRates) {
            if (invert ^ frameRate == 0.0) {
                return true;
            }
            for (TvShowEpisode episode : episodes) {
                if (!(invert ^ frameRate.doubleValue() == episode.getMediaInfoFrameRate())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("metatag.framerate"));
    }

    private void buildAndInstallCodecArray() {
        ArrayList<Double> frameRates = new ArrayList<Double>(this.tvShowList.getFrameRatesInEpisodes());
        Collections.sort(frameRates);
        this.setValues(frameRates);
    }

    @Override
    protected String parseTypeToString(Double type) throws Exception {
        return type.toString();
    }

    @Override
    protected Double parseStringToType(String string) throws Exception {
        return Double.parseDouble(string);
    }
}

