/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractTvShowUIFilter;

public class TvShowStudioFilter
extends AbstractTvShowUIFilter {
    private JTextField textField;

    @Override
    public String getId() {
        return "tvShowStudio";
    }

    @Override
    public String getFilterValueAsString() {
        return this.textField.getText();
    }

    @Override
    public void setFilterValue(Object value) {
        if (value instanceof String) {
            this.textField.setText((String)value);
        }
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        String filterText = StrgUtils.normalizeString(this.textField.getText());
        if (StringUtils.isBlank((CharSequence)filterText)) {
            return true;
        }
        try {
            Pattern pattern = Pattern.compile(filterText, 2);
            boolean foundShow = false;
            Matcher matcher = pattern.matcher(StrgUtils.normalizeString(tvShow.getProductionCompany()));
            if (matcher.find()) {
                foundShow = true;
            }
            if (!invert && foundShow) {
                return true;
            }
            if (invert && foundShow) {
                return false;
            }
            for (TvShowEpisode episode : episodes) {
                boolean foundEpisode = false;
                matcher = pattern.matcher(StrgUtils.normalizeString(episode.getProductionCompany()));
                if (matcher.find()) {
                    foundEpisode = true;
                }
                if (invert && !foundEpisode) {
                    return true;
                }
                if (invert || !foundEpisode) continue;
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("tvshowextendedsearch.studio"));
    }

    @Override
    protected JComponent createFilterComponent() {
        this.textField = new JTextField();
        return this.textField;
    }
}

