/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.JHintCheckBox;
import org.tinymediamanager.ui.components.TmmLabel;

public class TvShowScraperMetadataPanel
extends JPanel {
    private static final long serialVersionUID = 2417066912659769559L;
    private static final int COL_COUNT = 5;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TvShowSettings settings = TvShowModuleManager.SETTINGS;
    private Map<TvShowScraperMetadataConfig, JCheckBox> tvShowCheckboxes = new LinkedHashMap<TvShowScraperMetadataConfig, JCheckBox>();
    private Map<TvShowEpisodeScraperMetadataConfig, JCheckBox> episodeCheckboxes = new LinkedHashMap<TvShowEpisodeScraperMetadataConfig, JCheckBox>();

    public TvShowScraperMetadataPanel() {
        JCheckBox checkBox;
        ItemListener checkBoxListener = e -> this.checkChanges();
        this.initComponents();
        for (TvShowScraperMetadataConfig tvShowScraperMetadataConfig : this.settings.getTvShowScraperMetadataConfig()) {
            checkBox = this.tvShowCheckboxes.get(tvShowScraperMetadataConfig);
            if (checkBox == null) continue;
            checkBox.setSelected(true);
        }
        for (TvShowEpisodeScraperMetadataConfig tvShowEpisodeScraperMetadataConfig : this.settings.getEpisodeScraperMetadataConfig()) {
            checkBox = this.episodeCheckboxes.get(tvShowEpisodeScraperMetadataConfig);
            if (checkBox == null) continue;
            checkBox.setSelected(true);
        }
        for (JCheckBox jCheckBox : this.tvShowCheckboxes.values()) {
            jCheckBox.addItemListener(checkBoxListener);
        }
        for (JCheckBox jCheckBox : this.episodeCheckboxes.values()) {
            jCheckBox.addItemListener(checkBoxListener);
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        gbc.ipadx = 10;
        TmmLabel label = new TmmLabel(BUNDLE.getString("metatag.tvshows"));
        this.add((Component)label, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        for (TvShowScraperMetadataConfig value : TvShowScraperMetadataConfig.values()) {
            if (!value.isMetaData()) continue;
            this.addCheckbox(value, this.tvShowCheckboxes, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        for (TvShowScraperMetadataConfig value : TvShowScraperMetadataConfig.values()) {
            if (!value.isCast()) continue;
            this.addCheckbox(value, this.tvShowCheckboxes, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        for (TvShowScraperMetadataConfig value : TvShowScraperMetadataConfig.values()) {
            if (!value.isArtwork()) continue;
            this.addCheckbox(value, this.tvShowCheckboxes, gbc);
        }
        JPanel panel = new JPanel();
        JButton btnSelectAll = new JButton(IconManager.CHECK_ALL);
        panel.add(btnSelectAll);
        btnSelectAll.setToolTipText(BUNDLE.getString("Button.select.all"));
        btnSelectAll.addActionListener(e -> this.setTvShowCheckBoxState(true));
        JButton btnDeSelectAll = new JButton(IconManager.CLEAR_ALL);
        panel.add(btnDeSelectAll);
        btnDeSelectAll.setToolTipText(BUNDLE.getString("Button.select.none"));
        btnDeSelectAll.addActionListener(e -> this.setTvShowCheckBoxState(false));
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)panel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        label = new TmmLabel(BUNDLE.getString("metatag.episodes"));
        this.add((Component)label, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        for (TvShowEpisodeScraperMetadataConfig value : TvShowEpisodeScraperMetadataConfig.values()) {
            if (!value.isMetaData()) continue;
            this.addCheckbox(value, this.episodeCheckboxes, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        for (TvShowEpisodeScraperMetadataConfig value : TvShowEpisodeScraperMetadataConfig.values()) {
            if (!value.isCast()) continue;
            this.addCheckbox(value, this.episodeCheckboxes, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        for (TvShowEpisodeScraperMetadataConfig value : TvShowEpisodeScraperMetadataConfig.values()) {
            if (!value.isArtwork()) continue;
            this.addCheckbox(value, this.episodeCheckboxes, gbc);
        }
        panel = new JPanel();
        btnSelectAll = new JButton(IconManager.CHECK_ALL);
        panel.add(btnSelectAll);
        btnSelectAll.setToolTipText(BUNDLE.getString("Button.select.all"));
        btnSelectAll.addActionListener(e -> this.setEpisodeCheckBoxState(true));
        btnDeSelectAll = new JButton(IconManager.CLEAR_ALL);
        panel.add(btnDeSelectAll);
        btnDeSelectAll.setToolTipText(BUNDLE.getString("Button.select.none"));
        btnDeSelectAll.addActionListener(e -> this.setEpisodeCheckBoxState(false));
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)panel, gbc);
    }

    private <T extends ScraperMetadataConfig> void addCheckbox(T config, Map<T, JCheckBox> checkboxes, GridBagConstraints gbc) {
        JCheckBox checkBox;
        if (StringUtils.isNotBlank((CharSequence)config.getToolTip())) {
            checkBox = new JHintCheckBox(config.getDescription());
            checkBox.setToolTipText(config.getToolTip());
            ((JHintCheckBox)checkBox).setHintIcon(IconManager.HINT);
        } else {
            checkBox = new JCheckBox(config.getDescription());
        }
        checkboxes.put(config, checkBox);
        if (gbc.gridx >= 5) {
            gbc.gridx = 0;
            ++gbc.gridy;
        }
        this.add((Component)checkBox, gbc);
        ++gbc.gridx;
    }

    private void setTvShowCheckBoxState(boolean state) {
        this.setCheckBoxState(this.tvShowCheckboxes, state);
    }

    private void setEpisodeCheckBoxState(boolean state) {
        this.setCheckBoxState(this.episodeCheckboxes, state);
    }

    private void setCheckBoxState(Map<? extends ScraperMetadataConfig, JCheckBox> checkboxes, boolean state) {
        for (JCheckBox checkBox : checkboxes.values()) {
            checkBox.setSelected(state);
        }
    }

    private void checkChanges() {
        ArrayList<TvShowScraperMetadataConfig> tvShowConfig = new ArrayList<TvShowScraperMetadataConfig>();
        for (Map.Entry<TvShowScraperMetadataConfig, JCheckBox> entry : this.tvShowCheckboxes.entrySet()) {
            TvShowScraperMetadataConfig key = entry.getKey();
            JCheckBox value = entry.getValue();
            if (!value.isSelected() || tvShowConfig.contains(key)) continue;
            tvShowConfig.add(key);
        }
        this.settings.setTvShowScraperMetadataConfig(tvShowConfig);
        ArrayList<TvShowEpisodeScraperMetadataConfig> tvShowEpisodeConfig = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
        for (Map.Entry<TvShowEpisodeScraperMetadataConfig, JCheckBox> entry : this.episodeCheckboxes.entrySet()) {
            TvShowEpisodeScraperMetadataConfig key = entry.getKey();
            JCheckBox value = entry.getValue();
            if (!value.isSelected() || tvShowEpisodeConfig.contains(key)) continue;
            tvShowEpisodeConfig.add(key);
        }
        this.settings.setEpisodeScraperMetadataConfig(tvShowEpisodeConfig);
    }
}

