/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.ITmmTabItem;
import org.tinymediamanager.ui.ITmmUIFilter;
import org.tinymediamanager.ui.ITmmUIModule;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TablePopupListener;
import org.tinymediamanager.ui.components.TmmListPanel;
import org.tinymediamanager.ui.components.tree.ITmmTreeFilter;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.TmmTreeTable;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowTableFormat;
import org.tinymediamanager.ui.tvshows.TvShowTreeDataProvider;
import org.tinymediamanager.ui.tvshows.TvShowTreeTextFilter;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;
import org.tinymediamanager.ui.tvshows.actions.TvShowEditAction;

public class TvShowTreePanel
extends TmmListPanel
implements ITmmTabItem {
    private static final long serialVersionUID = 5889203009864512935L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TvShowList tvShowList = TvShowList.getInstance();
    private int rowcount;
    private long rowcountLastUpdate;
    private TmmTreeTable tree;
    private JLabel lblEpisodeCountFiltered;
    private JLabel lblEpisodeCountTotal;
    private JLabel lblTvShowCountFiltered;
    private JLabel lblTvShowCountTotal;
    private JButton btnFilter;

    public TvShowTreePanel(TvShowSelectionModel selectionModel) {
        this.initComponents();
        selectionModel.setTreeTable(this.tree);
        this.updateTotals();
        this.updateFilteredCount();
        this.tvShowList.addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "tvShowCount": 
                case "episodeCount": {
                    this.updateTotals();
                }
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("insets n n 0 n", "[200lp:n,grow][100lp:n,fill]", "[][200lp:n,grow]0[][][]"));
        TvShowTreeTextFilter<TmmTreeNode> searchField = new TvShowTreeTextFilter<TmmTreeNode>();
        this.add(searchField, "cell 0 0,growx");
        this.btnFilter = new JButton(BUNDLE.getString("movieextendedsearch.filter"));
        this.btnFilter.setToolTipText(BUNDLE.getString("movieextendedsearch.options"));
        this.btnFilter.addActionListener(e -> TvShowUIModule.getInstance().setFilterDialogVisible(true));
        this.add((Component)this.btnFilter, "cell 1 0");
        this.tree = new TmmTreeTable(new TvShowTreeDataProvider(), new TvShowTableFormat()){
            private static final long serialVersionUID = 5889201999994512935L;

            @Override
            public void storeFilters() {
                if (TvShowModuleManager.SETTINGS.isStoreUiFilters()) {
                    ArrayList<AbstractSettings.UIFilters> filterValues = new ArrayList<AbstractSettings.UIFilters>();
                    for (ITmmTreeFilter filter : this.treeFilters) {
                        ITmmUIFilter uiFilter;
                        if (!(filter instanceof ITmmUIFilter) || (uiFilter = (ITmmUIFilter)((Object)filter)).getFilterState() == ITmmUIFilter.FilterState.INACTIVE) continue;
                        AbstractSettings.UIFilters uiFilters = new AbstractSettings.UIFilters();
                        uiFilters.id = uiFilter.getId();
                        uiFilters.state = uiFilter.getFilterState();
                        uiFilters.filterValue = uiFilter.getFilterValueAsString();
                        filterValues.add(uiFilters);
                    }
                    TvShowModuleManager.SETTINGS.setUiFilters(filterValues);
                    TvShowModuleManager.SETTINGS.saveSettings();
                }
            }
        };
        this.tree.addPropertyChangeListener("filterChanged", evt -> this.updateFilterIndicator());
        this.tree.readHiddenColumns(TvShowModuleManager.SETTINGS.getTvShowTableHiddenColumns());
        this.tree.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                this.writeSettings();
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                this.writeSettings();
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            private void writeSettings() {
                TvShowTreePanel.this.tree.writeHiddenColumns(cols -> {
                    TvShowModuleManager.SETTINGS.setTvShowTableHiddenColumns((List<String>)cols);
                    TvShowModuleManager.SETTINGS.saveSettings();
                });
            }
        });
        this.tree.addFilter(searchField);
        JScrollPane scrollPane = new JScrollPane(this.tree);
        this.tree.configureScrollPane(scrollPane, new int[]{0});
        this.add((Component)scrollPane, "cell 0 1 2 1,grow");
        this.tree.adjustColumnPreferredWidths(3);
        this.tree.setRootVisible(false);
        this.tree.getModel().addTableModelListener(arg0 -> {
            this.updateFilteredCount();
            ListSelectionModel selectionModel1 = this.tree.getSelectionModel();
            if (selectionModel1.isSelectionEmpty() && this.tree.getModel().getRowCount() > 0) {
                selectionModel1.setSelectionInterval(0, 0);
            } else if (this.tree.getModel().getRowCount() == 0) {
                TvShowUIModule.getInstance().setSelectedTvShow(null);
            }
        });
        this.tree.getSelectionModel().addListSelectionListener(arg0 -> {
            if (arg0.getValueIsAdjusting() || !(arg0.getSource() instanceof DefaultListSelectionModel)) {
                return;
            }
            if (this.tree.getModel().getRowCount() == 0) {
                TvShowUIModule.getInstance().setSelectedTvShow(null);
                return;
            }
            int index = ((DefaultListSelectionModel)arg0.getSource()).getMinSelectionIndex();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getValueAt(index, 0);
            if (node != null) {
                if (node.getUserObject() instanceof TvShow) {
                    TvShow tvShow = (TvShow)node.getUserObject();
                    TvShowUIModule.getInstance().setSelectedTvShow(tvShow);
                }
                if (node.getUserObject() instanceof TvShowSeason) {
                    TvShowSeason tvShowSeason = (TvShowSeason)node.getUserObject();
                    TvShowUIModule.getInstance().setSelectedTvShowSeason(tvShowSeason);
                }
                if (node.getUserObject() instanceof TvShowEpisode) {
                    TvShowEpisode tvShowEpisode = (TvShowEpisode)node.getUserObject();
                    TvShowUIModule.getInstance().setSelectedTvShowEpisode(tvShowEpisode);
                }
            } else {
                TvShowUIModule.getInstance().setSelectedTvShow(null);
            }
        });
        TvShowList tvShowList = TvShowList.getInstance();
        if (tvShowList.getTvShows() != null && !tvShowList.getTvShows().isEmpty()) {
            SwingUtilities.invokeLater(() -> {
                ListSelectionModel selectionModel1 = this.tree.getSelectionModel();
                if (selectionModel1.isSelectionEmpty() && this.tree.getModel().getRowCount() > 0) {
                    selectionModel1.setSelectionInterval(0, 0);
                }
            });
        }
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed() && e.getButton() == 1) {
                    new TvShowEditAction().actionPerformed(new ActionEvent(e, 0, ""));
                }
            }
        };
        this.tree.addMouseListener(mouseListener);
        KeyAdapter keyListener = new KeyAdapter(){
            private long lastKeypress = 0L;
            private String searchTerm = "";

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 39) {
                    TvShowTreePanel.this.tree.expandRow(TvShowTreePanel.this.tree.getSelectedRow());
                }
                if (e.getKeyCode() == 37) {
                    TvShowTreePanel.this.tree.collapseRow(TvShowTreePanel.this.tree.getSelectedRow());
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                long now = System.currentTimeMillis();
                if (now - this.lastKeypress > 500L) {
                    this.searchTerm = "";
                }
                this.lastKeypress = now;
                if (e.getKeyChar() != '\uffff') {
                    this.searchTerm = this.searchTerm + e.getKeyChar();
                    this.searchTerm = this.searchTerm.toLowerCase();
                }
                if (StringUtils.isNotBlank((CharSequence)this.searchTerm)) {
                    TableModel model = TvShowTreePanel.this.tree.getModel();
                    for (int i = 0; i < model.getRowCount(); ++i) {
                        TvShowTreeDataProvider.TvShowTreeNode node;
                        String title;
                        if (!(model.getValueAt(i, 0) instanceof TvShowTreeDataProvider.TvShowTreeNode) || !(title = (node = (TvShowTreeDataProvider.TvShowTreeNode)model.getValueAt(i, 0)).toString().toLowerCase(Locale.ROOT)).startsWith(this.searchTerm)) continue;
                        TvShowTreePanel.this.tree.getSelectionModel().setSelectionInterval(i, i);
                        TvShowTreePanel.this.tree.scrollRectToVisible(new Rectangle(TvShowTreePanel.this.tree.getCellRect(i, 0, true)));
                        break;
                    }
                }
            }
        };
        this.tree.addKeyListener(keyListener);
        JSeparator separator = new JSeparator();
        this.add((Component)separator, "cell 0 2 2 1,growx");
        JLabel lblTvShowCount = new JLabel(BUNDLE.getString("tmm.tvshows") + ":");
        this.add((Component)lblTvShowCount, "flowx,cell 0 3 2 1");
        this.lblTvShowCountFiltered = new JLabel("");
        this.add((Component)this.lblTvShowCountFiltered, "cell 0 3 2 1");
        JLabel lblTvShowCountOf = new JLabel(BUNDLE.getString("tmm.of"));
        this.add((Component)lblTvShowCountOf, "cell 0 3 2 1");
        this.lblTvShowCountTotal = new JLabel("");
        this.add((Component)this.lblTvShowCountTotal, "cell 0 3 2 1");
        JLabel lblEpisodeCount = new JLabel(BUNDLE.getString("metatag.episodes") + ":");
        this.add((Component)lblEpisodeCount, "flowx,cell 0 4 2 1");
        this.lblEpisodeCountFiltered = new JLabel("");
        this.add((Component)this.lblEpisodeCountFiltered, "cell 0 4 2 1");
        JLabel lblEpisodeCountOf = new JLabel(BUNDLE.getString("tmm.of"));
        this.add((Component)lblEpisodeCountOf, "cell 0 4 2 1");
        this.lblEpisodeCountTotal = new JLabel("");
        this.add((Component)this.lblEpisodeCountTotal, "cell 0 4 2 1");
    }

    private void updateFilterIndicator() {
        boolean active = false;
        for (ITmmTreeFilter<TmmTreeNode> filter : this.tree.getFilters()) {
            if (!(filter instanceof ITmmUIFilter)) continue;
            ITmmUIFilter uiFilter = (ITmmUIFilter)((Object)filter);
            switch (uiFilter.getFilterState()) {
                case ACTIVE: 
                case ACTIVE_NEGATIVE: {
                    active = true;
                    break;
                }
            }
            if (!active) continue;
            break;
        }
        if (active) {
            this.btnFilter.setIcon(IconManager.FILTER_ACTIVE);
        } else {
            this.btnFilter.setIcon(null);
        }
    }

    private void updateTotals() {
        this.lblTvShowCountTotal.setText(String.valueOf(this.tvShowList.getTvShowCount()));
        int dummyEpisodeCount = this.tvShowList.getDummyEpisodeCount();
        if (dummyEpisodeCount > 0) {
            int episodeCount = this.tvShowList.getEpisodeCount();
            this.lblEpisodeCountTotal.setText(episodeCount + " (" + (episodeCount + dummyEpisodeCount) + ")");
        } else {
            this.lblEpisodeCountTotal.setText(String.valueOf(this.tvShowList.getEpisodeCount()));
        }
    }

    private void updateFilteredCount() {
        int tvShowCount = 0;
        int episodeCount = 0;
        int virtualEpisodeCount = 0;
        int rowcount = this.tree.getTreeTableModel().getRowCount();
        long rowcountLastUpdate = System.currentTimeMillis();
        if (this.rowcount == rowcount && rowcountLastUpdate - this.rowcountLastUpdate < 2000L) {
            return;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getTreeTableModel().getRoot();
        Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            Object userObject = node.getUserObject();
            if (userObject instanceof TvShow) {
                ++tvShowCount;
                continue;
            }
            if (!(userObject instanceof TvShowEpisode)) continue;
            if (((TvShowEpisode)userObject).isDummy()) {
                ++virtualEpisodeCount;
                continue;
            }
            ++episodeCount;
        }
        this.lblTvShowCountFiltered.setText(String.valueOf(tvShowCount));
        if (this.tvShowList.hasDummyEpisodes()) {
            this.lblEpisodeCountFiltered.setText(episodeCount + " (" + (episodeCount + virtualEpisodeCount) + ")");
        } else {
            this.lblEpisodeCountFiltered.setText(String.valueOf(episodeCount));
        }
        this.rowcount = rowcount;
        this.rowcountLastUpdate = rowcountLastUpdate;
    }

    @Override
    public ITmmUIModule getUIModule() {
        return TvShowUIModule.getInstance();
    }

    public TmmTreeTable getTreeTable() {
        return this.tree;
    }

    @Override
    public void setPopupMenu(JPopupMenu popupMenu) {
        popupMenu.addSeparator();
        popupMenu.add(new ExpandAllAction());
        popupMenu.add(new CollapseAllAction());
        this.tree.addMouseListener(new TablePopupListener(popupMenu, this.tree));
    }

    public class ExpandAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 6191727607109012198L;

        public ExpandAllAction() {
            this.putValue("Name", BUNDLE.getString("tree.expandall"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = 0;
            do {
                TvShowTreePanel.this.tree.expandRow(i++);
            } while (i < TvShowTreePanel.this.tree.getRowCount());
        }
    }

    public class CollapseAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -1444530142931061317L;

        public CollapseAllAction() {
            this.putValue("Name", BUNDLE.getString("tree.collapseall"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = TvShowTreePanel.this.tree.getRowCount() - 1; i >= 0; --i) {
                TvShowTreePanel.this.tree.collapseRow(i);
            }
        }
    }
}

