/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels.episode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.ui.ColumnLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;
import org.tinymediamanager.ui.components.StarRater;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.converter.RatingConverter;
import org.tinymediamanager.ui.converter.VoteCountConverter;
import org.tinymediamanager.ui.panels.MediaInformationLogosPanel;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeSelectionModel;

public class TvShowEpisodeInformationPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeInformationPanel.class);
    private static final long serialVersionUID = 2032708149757390567L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TvShowSettings settings = TvShowModuleManager.SETTINGS;
    private TvShowEpisodeSelectionModel tvShowEpisodeSelectionModel;
    private StarRater panelRatingStars;
    private JLabel lblTvShowName;
    private JLabel lblRating;
    private JLabel lblVoteCount;
    private JLabel lblEpisodeTitle;
    private ImageLabel lblEpisodeThumb;
    private ImageLabel lblSeasonPoster;
    private JTextArea taOverview;
    private MediaInformationLogosPanel panelLogos;
    private JSeparator sepLogos;
    private JLabel lblSeasonPosterSize;
    private JLabel lblEpisodeThumbSize;
    private JLabel lblOriginalTitle;
    private JButton btnPlay;
    private JLabel lblSeason;
    private JLabel lblEpisode;
    private JLabel lblAired;
    private JTextArea taTags;
    private LinkLabel lblPath;
    private JLabel lblNote;

    public TvShowEpisodeInformationPanel(TvShowEpisodeSelectionModel tvShowEpisodeSelectionModel) {
        this.tvShowEpisodeSelectionModel = tvShowEpisodeSelectionModel;
        this.initComponents();
        this.initDataBindings();
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != TvShowEpisodeSelectionModel.class) {
                return;
            }
            TvShowEpisodeSelectionModel model = (TvShowEpisodeSelectionModel)source;
            TvShowEpisode episode = model.getSelectedTvShowEpisode();
            if ("selectedTvShowEpisode".equals(property) || "poster".equals(property) || "seasonPoster".equals(property)) {
                this.setSeasonPoster(episode);
            }
            if ("selectedTvShowEpisode".equals(property) || "thumb".equals(property)) {
                this.setEpisodeThumb(episode);
            }
            if ("selectedTvShowEpisode".equals(property) || "mediaFiles".equals(property) || "mediaInformation".equals(property)) {
                this.panelLogos.setMediaInformationSource(episode);
            }
        };
        this.tvShowEpisodeSelectionModel.addPropertyChangeListener(propertyChangeListener);
        this.btnPlay.addActionListener(e -> {
            MediaFile mf = this.tvShowEpisodeSelectionModel.getSelectedTvShowEpisode().getMainVideoFile();
            if (StringUtils.isNotBlank((CharSequence)mf.getFilename())) {
                try {
                    TmmUIHelper.openFile(mf.getFileAsPath());
                }
                catch (Exception ex) {
                    LOGGER.error("open file", (Object)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf, "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
                }
            }
        });
        this.lblPath.addActionListener(arg0 -> {
            if (!StringUtils.isEmpty((CharSequence)this.lblPath.getText())) {
                Path path = Paths.get(this.lblPath.getText(), new String[0]);
                try {
                    if (Files.exists(path, new LinkOption[0])) {
                        TmmUIHelper.openFile(path);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("open filemanager", (Throwable)ex);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
                }
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[100lp:100lp,grow][300lp:300lp,grow 250]", "[][grow]"));
        JPanel panelLeft = new JPanel();
        panelLeft.setLayout(new ColumnLayout());
        this.add((Component)panelLeft, "cell 0 0 1 2,grow");
        this.lblSeasonPoster = new ImageLabel(false, false, true);
        this.lblSeasonPoster.setDesiredAspectRatio(0.6666667f);
        panelLeft.add(this.lblSeasonPoster);
        this.lblSeasonPoster.enableLightbox();
        this.lblSeasonPosterSize = new JLabel(BUNDLE.getString("mediafiletype.season_poster"));
        panelLeft.add(this.lblSeasonPosterSize);
        panelLeft.add(Box.createVerticalStrut(20));
        this.lblEpisodeThumb = new ImageLabel(false, false, true);
        this.lblEpisodeThumb.setDesiredAspectRatio(1.7777778f);
        panelLeft.add(this.lblEpisodeThumb);
        this.lblEpisodeThumb.enableLightbox();
        this.lblEpisodeThumbSize = new JLabel(BUNDLE.getString("mediafiletype.thumb"));
        panelLeft.add(this.lblEpisodeThumbSize);
        JPanel panelTitle = new JPanel();
        this.add((Component)panelTitle, "cell 1 0,growx");
        panelTitle.setLayout((LayoutManager)new MigLayout("insets 0 0 n n", "[grow][]", "[][][][shrink 0]"));
        this.lblTvShowName = new TmmLabel("", 1.33);
        panelTitle.add((Component)this.lblTvShowName, "flowx,cell 0 0,growx,wmin 0");
        this.btnPlay = new FlatButton(IconManager.PLAY_LARGE);
        panelTitle.add((Component)this.btnPlay, "cell 1 0 1 4,aligny top");
        this.lblEpisodeTitle = new TmmLabel("", 1.16);
        panelTitle.add((Component)this.lblEpisodeTitle, "cell 0 1,growx,wmin 0");
        this.lblOriginalTitle = new JLabel("");
        panelTitle.add((Component)this.lblOriginalTitle, "cell 0 2,growx,wmin 0");
        panelTitle.add((Component)new JSeparator(), "cell 0 3 2 1,growx");
        JPanel panelRight = new JPanel();
        panelRight.setLayout((LayoutManager)new MigLayout("insets n 0 n n, hidemode 2", "[grow]", "[][shrink 0][][shrink 0][][shrink 0][][][][]"));
        this.add((Component)panelRight, "cell 1 1,grow");
        JPanel panelTopDetails = new JPanel();
        panelTopDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[][10lp][grow]", "[]2lp[][]"));
        panelRight.add((Component)panelTopDetails, "cell 0 0,grow");
        JLabel lblSeasonT = new JLabel(BUNDLE.getString("metatag.season"));
        TmmFontHelper.changeFont(lblSeasonT, 1.166, 1);
        panelTopDetails.add((Component)lblSeasonT, "cell 0 0");
        this.lblSeason = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblSeason, 1.166);
        panelTopDetails.add((Component)this.lblSeason, "cell 2 0");
        JLabel lblEpisodeT = new JLabel(BUNDLE.getString("metatag.episode"));
        TmmFontHelper.changeFont(lblEpisodeT, 1.166, 1);
        panelTopDetails.add((Component)lblEpisodeT, "cell 0 1");
        this.lblEpisode = new JLabel("");
        TmmFontHelper.changeFont((JComponent)this.lblEpisode, 1.166);
        panelTopDetails.add((Component)this.lblEpisode, "cell 2 1");
        TmmLabel lblAiredT = new TmmLabel(BUNDLE.getString("metatag.aired"));
        panelTopDetails.add((Component)lblAiredT, "cell 0 2");
        this.lblAired = new JLabel("");
        panelTopDetails.add((Component)this.lblAired, "cell 2 2");
        panelRight.add((Component)new JSeparator(), "cell 0 1,growx");
        this.panelRatingStars = new StarRater(10, 1);
        panelRight.add((Component)this.panelRatingStars, "flowx,cell 0 2,aligny center");
        this.panelRatingStars.setEnabled(false);
        this.lblRating = new JLabel("");
        panelRight.add((Component)this.lblRating, "cell 0 2,aligny center");
        this.lblVoteCount = new JLabel("");
        panelRight.add((Component)this.lblVoteCount, "cell 0 2,aligny center");
        this.sepLogos = new JSeparator();
        panelRight.add((Component)this.sepLogos, "cell 0 3,growx");
        this.panelLogos = new MediaInformationLogosPanel();
        panelRight.add((Component)this.panelLogos, "cell 0 4,wmin 0");
        panelRight.add((Component)new JSeparator(), "cell 0 5,growx");
        TmmLabel lblPlot = new TmmLabel(BUNDLE.getString("metatag.plot"));
        panelRight.add((Component)lblPlot, "cell 0 6");
        this.taOverview = new ReadOnlyTextArea();
        panelRight.add((Component)this.taOverview, "cell 0 7,growx,wmin 0,aligny top");
        panelRight.add((Component)new JSeparator(), "cell 0 8,growx");
        JPanel panelBottomDetails = new JPanel();
        panelRight.add((Component)panelBottomDetails, "cell 0 9,grow");
        panelBottomDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[][10lp][200lp,grow]", "[]2lp[]2lp[]"));
        TmmLabel lblTagsT = new TmmLabel(BUNDLE.getString("metatag.tags"));
        panelBottomDetails.add((Component)lblTagsT, "cell 0 0");
        this.taTags = new ReadOnlyTextArea();
        panelBottomDetails.add((Component)this.taTags, "cell 2 0,growx,wmin 0");
        TmmLabel lblPathT = new TmmLabel(BUNDLE.getString("metatag.path"));
        panelBottomDetails.add((Component)lblPathT, "cell 0 1");
        this.lblPath = new LinkLabel("");
        panelBottomDetails.add((Component)this.lblPath, "cell 2 1,growx,wmin 0");
        TmmLabel lblNoteT = new TmmLabel(BUNDLE.getString("metatag.note"));
        panelBottomDetails.add((Component)lblNoteT, "cell 0 2");
        this.lblNote = new JLabel("");
        panelBottomDetails.add((Component)this.lblNote, "cell 2 2,growx,wmin 0");
    }

    private void setSeasonPoster(TvShowEpisode tvShowEpisode) {
        this.lblSeasonPoster.clearImage();
        this.lblSeasonPoster.setImagePath(tvShowEpisode.getTvShowSeason().getArtworkFilename(MediaArtwork.MediaArtworkType.SEASON_POSTER));
        Dimension posterSize = tvShowEpisode.getTvShowSeason().getArtworkSize(MediaArtwork.MediaArtworkType.SEASON_POSTER);
        if (posterSize.width > 0 && posterSize.height > 0) {
            this.lblSeasonPosterSize.setText(BUNDLE.getString("mediafiletype.season_poster") + " - " + posterSize.width + "x" + posterSize.height);
        } else {
            this.lblSeasonPosterSize.setText(BUNDLE.getString("mediafiletype.season_poster"));
        }
    }

    private void setEpisodeThumb(TvShowEpisode tvShowEpisode) {
        this.lblEpisodeThumb.clearImage();
        this.lblEpisodeThumb.setImagePath(tvShowEpisode.getArtworkFilename(MediaFileType.THUMB));
        Dimension thumbSize = tvShowEpisode.getArtworkDimension(MediaFileType.THUMB);
        if (thumbSize.width > 0 && thumbSize.height > 0) {
            this.lblEpisodeThumbSize.setText(BUNDLE.getString("mediafiletype.thumb") + " - " + thumbSize.width + "x" + thumbSize.height);
        } else {
            this.lblEpisodeThumbSize.setText(BUNDLE.getString("mediafiletype.thumb"));
        }
    }

    protected void initDataBindings() {
        BeanProperty tvShowEpisodeSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShowEpisode.tvShow.title");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty, (Object)this.lblTvShowName, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShowEpisode.titleForUi");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_1, (Object)this.lblEpisodeTitle, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedTvShowEpisode.plot");
        BeanProperty JTextAreaBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_3, (Object)this.taOverview, (Property)JTextAreaBeanProperty);
        autoBinding_3.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_4 = BeanProperty.create((String)"selectedTvShowEpisode.rating.ratingNormalized");
        BeanProperty starRaterBeanProperty = BeanProperty.create((String)"rating");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_4, (Object)this.panelRatingStars, (Property)starRaterBeanProperty);
        autoBinding_4.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_6 = BeanProperty.create((String)"selectedTvShowEpisode");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_6, (Object)this.lblRating, (Property)jLabelBeanProperty);
        autoBinding_5.setConverter(new RatingConverter());
        autoBinding_5.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedTvShowEpisode.originalTitle");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_2, (Object)this.lblOriginalTitle, (Property)jLabelBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_5 = BeanProperty.create((String)"selectedTvShowEpisode.rating.votes");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_5, (Object)this.lblVoteCount, (Property)jLabelBeanProperty);
        autoBinding_6.setConverter((Converter)new VoteCountConverter());
        autoBinding_6.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"showLogosPanel");
        BeanProperty jSeparatorBeanProperty = BeanProperty.create((String)"visible");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.sepLogos, (Property)jSeparatorBeanProperty);
        autoBinding_7.bind();
        BeanProperty mediaInformationLogosPanelBeanProperty = BeanProperty.create((String)"visible");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.panelLogos, (Property)mediaInformationLogosPanelBeanProperty);
        autoBinding_8.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_7 = BeanProperty.create((String)"selectedTvShowEpisode.season");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_7, (Object)this.lblSeason, (Property)jLabelBeanProperty);
        autoBinding_9.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_8 = BeanProperty.create((String)"selectedTvShowEpisode.episode");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_8, (Object)this.lblEpisode, (Property)jLabelBeanProperty);
        autoBinding_10.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_9 = BeanProperty.create((String)"selectedTvShowEpisode.firstAiredAsString");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_9, (Object)this.lblAired, (Property)jLabelBeanProperty);
        autoBinding_11.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_10 = BeanProperty.create((String)"selectedTvShowEpisode.tagsAsString");
        BeanProperty jTextAreaBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_10, (Object)this.taTags, (Property)jTextAreaBeanProperty);
        autoBinding_12.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_11 = BeanProperty.create((String)"selectedTvShowEpisode.path");
        BeanProperty linkLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_13 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_11, (Object)this.lblPath, (Property)linkLabelBeanProperty);
        autoBinding_13.bind();
        BeanProperty tvShowEpisodeSelectionModelBeanProperty_12 = BeanProperty.create((String)"selectedTvShowEpisode.note");
        AutoBinding autoBinding_14 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tvShowEpisodeSelectionModel, (Property)tvShowEpisodeSelectionModelBeanProperty_12, (Object)this.lblNote, (Property)jLabelBeanProperty);
        autoBinding_14.bind();
    }
}

