/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels.tvshow;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.panels.MediaFilesPanel;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;

public class TvShowMediaInformationPanel
extends JPanel {
    private static final long serialVersionUID = 1610264727610254912L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowMediaInformationPanel.class);
    private TvShowSelectionModel selectionModel;
    private EventList<MediaFile> mediaFileEventList;
    private MediaFilesPanel panelMediaFiles;
    private LinkLabel lblTvShowPath;
    private JLabel lblDateAdded;
    private JCheckBox cbWatched;

    public TvShowMediaInformationPanel(TvShowSelectionModel model) {
        this.selectionModel = model;
        this.mediaFileEventList = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(MediaFile.class));
        this.initComponents();
        this.initDataBindings();
        this.lblTvShowPath.addActionListener(arg0 -> {
            if (StringUtils.isNotBlank((CharSequence)this.lblTvShowPath.getText())) {
                Path path = Paths.get(this.lblTvShowPath.getText(), new String[0]);
                try {
                    if (Files.exists(path, new LinkOption[0])) {
                        TmmUIHelper.openFile(path);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("open filemanager", (Throwable)ex);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
                }
            }
        });
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != TvShowSelectionModel.class) {
                return;
            }
            if ("selectedTvShow".equals(property) || "mediaInformation".equals(property) || "mediaFiles".equals(property)) {
                try {
                    this.mediaFileEventList.getReadWriteLock().writeLock().lock();
                    this.mediaFileEventList.clear();
                    this.mediaFileEventList.addAll(this.selectionModel.getSelectedTvShow().getMediaFiles());
                }
                catch (Exception exception) {
                }
                finally {
                    this.mediaFileEventList.getReadWriteLock().writeLock().unlock();
                }
                this.panelMediaFiles.adjustColumns();
            }
        };
        this.selectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[][150lp][grow]", "[][][80lp,grow]"));
        TmmLabel lblTvShowPathT = new TmmLabel(BUNDLE.getString("metatag.path"));
        this.add((Component)lblTvShowPathT, "cell 0 0");
        this.lblTvShowPath = new LinkLabel("");
        this.add((Component)this.lblTvShowPath, "cell 1 0 2 1,growx,wmin 0");
        TmmLabel lblDateAddedT = new TmmLabel(BUNDLE.getString("metatag.dateadded"));
        this.add((Component)lblDateAddedT, "cell 0 1");
        this.lblDateAdded = new JLabel("");
        this.add((Component)this.lblDateAdded, "cell 1 1");
        TmmLabel lblWatchedT = new TmmLabel(BUNDLE.getString("metatag.watched"));
        this.add((Component)lblWatchedT, "flowx,cell 2 1");
        this.panelMediaFiles = new MediaFilesPanel(this.mediaFileEventList){

            @Override
            public MediaEntity getMediaEntity() {
                return TvShowMediaInformationPanel.this.selectionModel.getSelectedTvShow();
            }
        };
        this.add((Component)this.panelMediaFiles, "cell 0 2 3 1,grow");
        this.cbWatched = new JCheckBox("");
        this.cbWatched.setEnabled(false);
        this.add((Component)this.cbWatched, "cell 2 1");
    }

    protected void initDataBindings() {
        BeanProperty tvShowSelectionModelBeanProperty = BeanProperty.create((String)"selectedTvShow.dateAdded.date");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty, (Object)this.lblDateAdded, (Property)jLabelBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedTvShow.watched");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_1, (Object)this.cbWatched, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedTvShow.dateAdded.day");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_2, (Object)this.lblDateAdded, (Property)jLabelBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedTvShow.dateAddedAsString");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_3, (Object)this.lblDateAdded, (Property)jLabelBeanProperty);
        autoBinding_3.bind();
        BeanProperty tvShowSelectionModelBeanProperty_13 = BeanProperty.create((String)"selectedTvShow.path");
        BeanProperty jTextAreaBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_19 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.selectionModel, (Property)tvShowSelectionModelBeanProperty_13, (Object)this.lblTvShowPath, (Property)jTextAreaBeanProperty);
        autoBinding_19.bind();
    }
}

