/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.thirdparty.trakttv.ClearTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.CollapsiblePanel;
import org.tinymediamanager.ui.components.SettingsPanelFactory;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;

class TvShowSettingsPanel
extends JPanel {
    private static final long serialVersionUID = -675729644848101096L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TvShowSettings settings = TvShowModuleManager.SETTINGS;
    private JCheckBox chckbxImageCache;
    private JCheckBox chckbxExtractArtworkFromVsmeta;
    private JCheckBox chckbxTraktTv;
    private JButton btnClearTraktTvShows;
    private JCheckBox chckbxPersistUiFilters;
    private JCheckBox chckbxShowLogos;
    private JCheckBox chckbxShowMissingEpisodes;
    private JButton btnPresetKodi;
    private JButton btnPresetXbmc;
    private JButton btnPresetMediaPortal1;
    private JButton btnPresetMediaPortal2;
    private JButton btnPresetPlex;
    private JCheckBox chckbxPersonalRatingFirst;
    private AutocompleteComboBox<String> cbRating;
    private JCheckBox chckbxRenameAfterScrape;
    private JCheckBox chckbxShowMissingSpecials;
    private JCheckBox chckbxTvShowCheckPoster;
    private JCheckBox chckbxTvShowCheckFanart;
    private JCheckBox chckbxTvShowCheckBanner;
    private JCheckBox chckbxTvShowCheckClearart;
    private JCheckBox chckbxTvShowCheckThumb;
    private JCheckBox chckbxTvShowCheckLogo;
    private JCheckBox chckbxTvShowCheckClearlogo;
    private JCheckBox chckbxTvShowSeasonCheckPoster;
    private JCheckBox chckbxTvShowSeasonCheckBanner;
    private JCheckBox chckbxTvShowSeasonCheckThumb;
    private JCheckBox chckbxTvShowEpisodeCheckThumb;
    private ItemListener checkBoxListener = e -> this.checkChanges();

    TvShowSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnClearTraktTvShows.addActionListener(e -> {
            Object[] options = new Object[]{BUNDLE.getString("Button.yes"), BUNDLE.getString("Button.no")};
            int confirm = JOptionPane.showOptionDialog(null, BUNDLE.getString("Settings.trakt.cleartvshows.hint"), BUNDLE.getString("Settings.trakt.cleartvshows"), 0, 3, null, options, null);
            if (confirm == 0) {
                ClearTraktTvTask task = new ClearTraktTvTask(false, true);
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
        });
        this.btnPresetXbmc.addActionListener(evt -> this.settings.setDefaultSettingsForXbmc());
        this.btnPresetKodi.addActionListener(evt -> this.settings.setDefaultSettingsForKodi());
        this.btnPresetMediaPortal1.addActionListener(evt -> this.settings.setDefaultSettingsForMediaPortal());
        this.btnPresetMediaPortal2.addActionListener(evt -> this.settings.setDefaultSettingsForMediaPortal());
        this.btnPresetPlex.addActionListener(evt -> this.settings.setDefaultSettingsForPlex());
        this.buildCheckBoxes();
    }

    private void checkChanges() {
        this.settings.clearTvShowCheckImages();
        if (this.chckbxTvShowCheckPoster.isSelected()) {
            this.settings.addTvShowCheckImages(MediaArtwork.MediaArtworkType.POSTER);
        }
        if (this.chckbxTvShowCheckFanart.isSelected()) {
            this.settings.addTvShowCheckImages(MediaArtwork.MediaArtworkType.BACKGROUND);
        }
        if (this.chckbxTvShowCheckBanner.isSelected()) {
            this.settings.addTvShowCheckImages(MediaArtwork.MediaArtworkType.BANNER);
        }
        if (this.chckbxTvShowCheckClearart.isSelected()) {
            this.settings.addTvShowCheckImages(MediaArtwork.MediaArtworkType.CLEARART);
        }
        if (this.chckbxTvShowCheckThumb.isSelected()) {
            this.settings.addTvShowCheckImages(MediaArtwork.MediaArtworkType.THUMB);
        }
        if (this.chckbxTvShowCheckLogo.isSelected()) {
            this.settings.addTvShowCheckImages(MediaArtwork.MediaArtworkType.LOGO);
        }
        if (this.chckbxTvShowCheckClearlogo.isSelected()) {
            this.settings.addTvShowCheckImages(MediaArtwork.MediaArtworkType.CLEARLOGO);
        }
        this.settings.clearSeasonCheckImages();
        if (this.chckbxTvShowSeasonCheckPoster.isSelected()) {
            this.settings.addSeasonCheckImages(MediaArtwork.MediaArtworkType.SEASON_POSTER);
        }
        if (this.chckbxTvShowSeasonCheckBanner.isSelected()) {
            this.settings.addSeasonCheckImages(MediaArtwork.MediaArtworkType.SEASON_BANNER);
        }
        if (this.chckbxTvShowSeasonCheckThumb.isSelected()) {
            this.settings.addSeasonCheckImages(MediaArtwork.MediaArtworkType.SEASON_THUMB);
        }
        this.settings.clearEpisodeCheckImages();
        if (this.chckbxTvShowEpisodeCheckThumb.isSelected()) {
            this.settings.addEpisodeCheckImages(MediaArtwork.MediaArtworkType.THUMB);
        }
    }

    private void buildCheckBoxes() {
        this.chckbxTvShowCheckPoster.removeItemListener(this.checkBoxListener);
        this.chckbxTvShowCheckFanart.removeItemListener(this.checkBoxListener);
        this.chckbxTvShowCheckBanner.removeItemListener(this.checkBoxListener);
        this.chckbxTvShowCheckClearart.removeItemListener(this.checkBoxListener);
        this.chckbxTvShowCheckThumb.removeItemListener(this.checkBoxListener);
        this.chckbxTvShowCheckLogo.removeItemListener(this.checkBoxListener);
        this.chckbxTvShowCheckClearlogo.removeItemListener(this.checkBoxListener);
        this.clearSelection(this.chckbxTvShowCheckPoster, this.chckbxTvShowCheckFanart, this.chckbxTvShowCheckBanner, this.chckbxTvShowCheckClearart, this.chckbxTvShowCheckThumb, this.chckbxTvShowCheckLogo, this.chckbxTvShowCheckClearlogo);
        this.chckbxTvShowSeasonCheckPoster.removeItemListener(this.checkBoxListener);
        this.chckbxTvShowSeasonCheckBanner.removeItemListener(this.checkBoxListener);
        this.chckbxTvShowSeasonCheckThumb.removeItemListener(this.checkBoxListener);
        this.clearSelection(this.chckbxTvShowSeasonCheckPoster, this.chckbxTvShowSeasonCheckBanner, this.chckbxTvShowSeasonCheckThumb);
        this.chckbxTvShowEpisodeCheckThumb.removeItemListener(this.checkBoxListener);
        this.clearSelection(this.chckbxTvShowEpisodeCheckThumb);
        for (MediaArtwork.MediaArtworkType type : this.settings.getTvShowCheckImages()) {
            switch (type) {
                case POSTER: {
                    this.chckbxTvShowCheckPoster.setSelected(true);
                    break;
                }
                case BACKGROUND: {
                    this.chckbxTvShowCheckFanart.setSelected(true);
                    break;
                }
                case BANNER: {
                    this.chckbxTvShowCheckBanner.setSelected(true);
                    break;
                }
                case CLEARART: {
                    this.chckbxTvShowCheckClearart.setSelected(true);
                    break;
                }
                case THUMB: {
                    this.chckbxTvShowCheckThumb.setSelected(true);
                    break;
                }
                case LOGO: {
                    this.chckbxTvShowCheckLogo.setSelected(true);
                    break;
                }
                case CLEARLOGO: {
                    this.chckbxTvShowCheckClearlogo.setSelected(true);
                    break;
                }
            }
        }
        for (MediaArtwork.MediaArtworkType type : this.settings.getSeasonCheckImages()) {
            switch (type) {
                case SEASON_POSTER: {
                    this.chckbxTvShowSeasonCheckPoster.setSelected(true);
                    break;
                }
                case SEASON_BANNER: {
                    this.chckbxTvShowSeasonCheckBanner.setSelected(true);
                    break;
                }
                case SEASON_THUMB: {
                    this.chckbxTvShowSeasonCheckThumb.setSelected(true);
                    break;
                }
            }
        }
        for (MediaArtwork.MediaArtworkType type : this.settings.getEpisodeCheckImages()) {
            switch (type) {
                case THUMB: {
                    this.chckbxTvShowEpisodeCheckThumb.setSelected(true);
                    break;
                }
            }
        }
        this.chckbxTvShowCheckPoster.addItemListener(this.checkBoxListener);
        this.chckbxTvShowCheckFanart.addItemListener(this.checkBoxListener);
        this.chckbxTvShowCheckBanner.addItemListener(this.checkBoxListener);
        this.chckbxTvShowCheckClearart.addItemListener(this.checkBoxListener);
        this.chckbxTvShowCheckThumb.addItemListener(this.checkBoxListener);
        this.chckbxTvShowCheckLogo.addItemListener(this.checkBoxListener);
        this.chckbxTvShowCheckClearlogo.addItemListener(this.checkBoxListener);
        this.chckbxTvShowSeasonCheckPoster.addItemListener(this.checkBoxListener);
        this.chckbxTvShowSeasonCheckBanner.addItemListener(this.checkBoxListener);
        this.chckbxTvShowSeasonCheckThumb.addItemListener(this.checkBoxListener);
        this.chckbxTvShowEpisodeCheckThumb.addItemListener(this.checkBoxListener);
    }

    private void clearSelection(JCheckBox ... checkBoxes) {
        for (JCheckBox checkBox : checkBoxes) {
            checkBox.setSelected(false);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][15lp!][][15lp!][][15lp!][]"));
        JPanel panelUiSettings = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblUiSettings = new TmmLabel(BUNDLE.getString("Settings.ui"), TmmFontHelper.H3);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelUiSettings, lblUiSettings, true);
        this.add((Component)collapsiblePanel, "cell 0 0,growx,wmin 0");
        this.chckbxPersistUiFilters = new JCheckBox(BUNDLE.getString("Settings.movie.persistuifilter"));
        panelUiSettings.add((Component)this.chckbxPersistUiFilters, "cell 1 0 2 1");
        this.chckbxShowLogos = new JCheckBox(BUNDLE.getString("Settings.showlogos"));
        panelUiSettings.add((Component)this.chckbxShowLogos, "cell 1 1 2 1");
        this.chckbxShowMissingEpisodes = new JCheckBox(BUNDLE.getString("Settings.tvshow.missingepisodes"));
        panelUiSettings.add((Component)this.chckbxShowMissingEpisodes, "cell 1 2 2 1");
        this.chckbxShowMissingSpecials = new JCheckBox(BUNDLE.getString("Settings.tvshow.missingespecials"));
        panelUiSettings.add((Component)this.chckbxShowMissingSpecials, "cell 2 3");
        JLabel lblRating = new JLabel(BUNDLE.getString("Settings.preferredrating"));
        panelUiSettings.add((Component)lblRating, "flowx,cell 1 4 2 1");
        this.cbRating = new AutocompleteComboBox<String>(Arrays.asList("tvdb", "tmdb"));
        panelUiSettings.add(this.cbRating, "cell 1 4");
        this.chckbxPersonalRatingFirst = new JCheckBox(BUNDLE.getString("Settings.personalratingfirst"));
        panelUiSettings.add((Component)this.chckbxPersonalRatingFirst, "cell 2 5");
        JPanel panelAutomaticTasks = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblAutomaticTasksT = new TmmLabel(BUNDLE.getString("Settings.automatictasks"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelAutomaticTasks, lblAutomaticTasksT, true);
        this.add((Component)collapsiblePanel, "cell 0 2,growx,wmin 0");
        this.chckbxRenameAfterScrape = new JCheckBox(BUNDLE.getString("Settings.tvshow.automaticrename"));
        panelAutomaticTasks.add((Component)this.chckbxRenameAfterScrape, "cell 1 0 2 1");
        JLabel lblAutomaticRenameHint = new JLabel(IconManager.HINT);
        lblAutomaticRenameHint.setToolTipText(BUNDLE.getString("Settings.tvshow.automaticrename.desc"));
        panelAutomaticTasks.add((Component)lblAutomaticRenameHint, "cell 1 0");
        this.chckbxTraktTv = new JCheckBox(BUNDLE.getString("Settings.trakt"));
        panelAutomaticTasks.add((Component)this.chckbxTraktTv, "cell 1 1 2 1");
        this.btnClearTraktTvShows = new JButton(BUNDLE.getString("Settings.trakt.cleartvshows"));
        panelAutomaticTasks.add((Component)this.btnClearTraktTvShows, "cell 1 1");
        JPanel panelMisc = SettingsPanelFactory.createSettingsPanel();
        TmmLabel lblMiscT = new TmmLabel(BUNDLE.getString("Settings.misc"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelMisc, lblMiscT, true);
        this.add((Component)collapsiblePanel, "cell 0 4,growx,wmin 0");
        this.chckbxExtractArtworkFromVsmeta = new JCheckBox(BUNDLE.getString("Settings.extractartworkfromvsmeta"));
        panelMisc.add((Component)this.chckbxExtractArtworkFromVsmeta, "cell 1 0 2 1");
        this.chckbxImageCache = new JCheckBox(BUNDLE.getString("Settings.imagecacheimport"));
        panelMisc.add((Component)this.chckbxImageCache, "cell 1 1 2 1");
        JLabel lblBuildImageCacheHint = new JLabel(IconManager.HINT);
        lblBuildImageCacheHint.setToolTipText(BUNDLE.getString("Settings.imagecacheimporthint"));
        panelMisc.add((Component)lblBuildImageCacheHint, "cell 1 1");
        JLabel lblCheckImages = new JLabel(BUNDLE.getString("Settings.checkimages"));
        panelMisc.add((Component)lblCheckImages, "cell 1 2 2 1");
        JPanel panelCheckImages = new JPanel();
        panelCheckImages.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[][][][]", ""));
        panelMisc.add((Component)panelCheckImages, "cell 2 3");
        TmmLabel lblTvShowCheckImages = new TmmLabel(BUNDLE.getString("metatag.tvshow"));
        panelCheckImages.add((Component)lblTvShowCheckImages, "cell 0 0");
        this.chckbxTvShowCheckPoster = new JCheckBox(BUNDLE.getString("mediafiletype.poster"));
        panelCheckImages.add((Component)this.chckbxTvShowCheckPoster, "cell 1 0");
        this.chckbxTvShowCheckFanart = new JCheckBox(BUNDLE.getString("mediafiletype.fanart"));
        panelCheckImages.add((Component)this.chckbxTvShowCheckFanart, "cell 2 0");
        this.chckbxTvShowCheckBanner = new JCheckBox(BUNDLE.getString("mediafiletype.banner"));
        panelCheckImages.add((Component)this.chckbxTvShowCheckBanner, "cell 3 0");
        this.chckbxTvShowCheckClearart = new JCheckBox(BUNDLE.getString("mediafiletype.clearart"));
        panelCheckImages.add((Component)this.chckbxTvShowCheckClearart, "cell 4 0");
        this.chckbxTvShowCheckThumb = new JCheckBox(BUNDLE.getString("mediafiletype.thumb"));
        panelCheckImages.add((Component)this.chckbxTvShowCheckThumb, "cell 5 0");
        this.chckbxTvShowCheckLogo = new JCheckBox(BUNDLE.getString("mediafiletype.logo"));
        panelCheckImages.add((Component)this.chckbxTvShowCheckLogo, "cell 6 0");
        this.chckbxTvShowCheckClearlogo = new JCheckBox(BUNDLE.getString("mediafiletype.clearlogo"));
        panelCheckImages.add((Component)this.chckbxTvShowCheckClearlogo, "cell 7 0");
        TmmLabel lblTvShowSeasonCheckImages = new TmmLabel(BUNDLE.getString("metatag.season"));
        panelCheckImages.add((Component)lblTvShowSeasonCheckImages, "cell 0 1");
        this.chckbxTvShowSeasonCheckPoster = new JCheckBox(BUNDLE.getString("mediafiletype.poster"));
        panelCheckImages.add((Component)this.chckbxTvShowSeasonCheckPoster, "cell 1 1");
        this.chckbxTvShowSeasonCheckBanner = new JCheckBox(BUNDLE.getString("mediafiletype.banner"));
        panelCheckImages.add((Component)this.chckbxTvShowSeasonCheckBanner, "cell 2 1");
        this.chckbxTvShowSeasonCheckThumb = new JCheckBox(BUNDLE.getString("mediafiletype.thumb"));
        panelCheckImages.add((Component)this.chckbxTvShowSeasonCheckThumb, "cell 3 1");
        TmmLabel lblTvShowEpisodeCheckImages = new TmmLabel(BUNDLE.getString("metatag.episode"));
        panelCheckImages.add((Component)lblTvShowEpisodeCheckImages, "cell 0 2");
        this.chckbxTvShowEpisodeCheckThumb = new JCheckBox(BUNDLE.getString("mediafiletype.thumb"));
        panelCheckImages.add((Component)this.chckbxTvShowEpisodeCheckThumb, "cell 1 2");
        JPanel panelPresets = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][15lp][][][grow]", "[]"));
        TmmLabel lblPresets = new TmmLabel(BUNDLE.getString("Settings.preset"), TmmFontHelper.H3);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelPresets, lblPresets, true);
        this.add((Component)collapsiblePanel, "cell 0 6,growx,wmin 0");
        JLabel lblPresetHintT = new JLabel(BUNDLE.getString("Settings.preset.desc"));
        panelPresets.add((Component)lblPresetHintT, "cell 1 0 3 1");
        this.btnPresetKodi = new JButton("Kodi v17+");
        panelPresets.add((Component)this.btnPresetKodi, "cell 2 1,growx");
        this.btnPresetXbmc = new JButton("XBMC/Kodi <v17");
        panelPresets.add((Component)this.btnPresetXbmc, "cell 3 1,growx");
        this.btnPresetMediaPortal1 = new JButton("MediaPortal 1.x");
        panelPresets.add((Component)this.btnPresetMediaPortal1, "cell 2 2,growx");
        this.btnPresetMediaPortal2 = new JButton("MediaPortal 2.x");
        panelPresets.add((Component)this.btnPresetMediaPortal2, "cell 3 2,growx");
        this.btnPresetPlex = new JButton("Plex");
        panelPresets.add((Component)this.btnPresetPlex, "cell 2 3,growx");
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"syncTrakt");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.chckbxTraktTv, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"buildImageCacheOnImport");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.chckbxImageCache, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowSettingsBeanProperty_1 = BeanProperty.create((String)"storeUiFilters");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_1, (Object)this.chckbxPersistUiFilters, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowSettingsBeanProperty_2 = BeanProperty.create((String)"displayMissingEpisodes");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_2, (Object)this.chckbxShowMissingEpisodes, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty tvShowSettingsBeanProperty_3 = BeanProperty.create((String)"preferredRating");
        BeanProperty autocompleteComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_3, this.cbRating, (Property)autocompleteComboBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty tvShowSettingsBeanProperty_4 = BeanProperty.create((String)"preferPersonalRating");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_4, (Object)this.chckbxPersonalRatingFirst, (Property)jCheckBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty tvShowSettingsBeanProperty_5 = BeanProperty.create((String)"renameAfterScrape");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_5, (Object)this.chckbxRenameAfterScrape, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxShowMissingEpisodes, (Property)jCheckBoxBeanProperty, (Object)this.chckbxShowMissingSpecials, (Property)jCheckBoxBeanProperty_1);
        autoBinding_7.bind();
        BeanProperty tvShowSettingsBeanProperty_6 = BeanProperty.create((String)"displayMissingSpecials");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_6, (Object)this.chckbxShowMissingSpecials, (Property)jCheckBoxBeanProperty);
        autoBinding_8.bind();
        BeanProperty tvShowSettingsBeanProperty_7 = BeanProperty.create((String)"showLogosPanel");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_7, (Object)this.chckbxShowLogos, (Property)jCheckBoxBeanProperty);
        autoBinding_9.bind();
        BeanProperty tvShowSettingsBeanProperty_8 = BeanProperty.create((String)"extractArtworkFromVsmeta");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_8, (Object)this.chckbxExtractArtworkFromVsmeta, (Property)jCheckBoxBeanProperty);
        autoBinding_10.bind();
    }
}

