/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.wizard;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;

class MovieSourcePanel
extends JPanel {
    private static final long serialVersionUID = -8346420911623937902L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final MovieSettings settings = MovieModuleManager.SETTINGS;
    private JList<String> listDataSources;

    public MovieSourcePanel() {
        this.initComponents();
        this.initDataBindings();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][200lp,grow]"));
        JLabel lblMovieDataSources = new JLabel(BUNDLE.getString("wizard.movie.datasources"));
        TmmFontHelper.changeFont(lblMovieDataSources, 1.3333, 1);
        this.add((Component)lblMovieDataSources, "cell 0 0");
        JPanel panelMovieDataSources = new JPanel();
        this.add((Component)panelMovieDataSources, "cell 0 1,grow");
        panelMovieDataSources.setLayout((LayoutManager)new MigLayout("", "[grow][]", "[][200lp,grow]"));
        ReadOnlyTextArea tpDatasourceHint = new ReadOnlyTextArea(BUNDLE.getString("wizard.datasource.hint"));
        panelMovieDataSources.add((Component)tpDatasourceHint, "cell 0 0 2 1,grow");
        JScrollPane scrollPaneDataSources = new JScrollPane();
        panelMovieDataSources.add((Component)scrollPaneDataSources, "cell 0 1,grow");
        this.listDataSources = new JList();
        scrollPaneDataSources.setViewportView(this.listDataSources);
        JButton btnAdd = new JButton(IconManager.ADD_INV);
        panelMovieDataSources.add((Component)btnAdd, "flowy,cell 1 1,aligny top");
        btnAdd.setToolTipText(BUNDLE.getString("Button.add"));
        btnAdd.setMargin(new Insets(2, 2, 2, 2));
        JButton btnRemove = new JButton(IconManager.REMOVE_INV);
        panelMovieDataSources.add((Component)btnRemove, "cell 1 1");
        btnRemove.setToolTipText(BUNDLE.getString("Button.remove"));
        btnRemove.setMargin(new Insets(2, 2, 2, 2));
        btnRemove.addActionListener(arg0 -> {
            int row = this.listDataSources.getSelectedIndex();
            if (row != -1) {
                String path = MovieModuleManager.SETTINGS.getMovieDataSource().get(row);
                Object[] choices = new String[]{BUNDLE.getString("Button.continue"), BUNDLE.getString("Button.abort")};
                int decision = JOptionPane.showOptionDialog(null, String.format(BUNDLE.getString("Settings.movie.datasource.remove.info"), path), BUNDLE.getString("Settings.datasource.remove"), 0, -1, null, choices, BUNDLE.getString("Button.abort"));
                if (decision == 0) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    MovieModuleManager.SETTINGS.removeMovieDataSources(path);
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        btnAdd.addActionListener(arg0 -> {
            String path = TmmProperties.getInstance().getProperty("movie.datasource.path");
            Path file = TmmUIHelper.selectDirectory(BUNDLE.getString("Settings.datasource.folderchooser"), path);
            if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                MovieModuleManager.SETTINGS.addMovieDataSources(file.toAbsolutePath().toString());
            }
        });
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty_4 = BeanProperty.create((String)"movieDataSource");
        JListBinding jListBinding_1 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_4, this.listDataSources);
        jListBinding_1.bind();
    }
}

