/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.wizard;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.UTF8Control;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.ReadOnlyTextArea;

class TvShowSourcePanel
extends JPanel {
    private static final long serialVersionUID = -7126616245313008341L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private final TvShowSettings settings = TvShowModuleManager.SETTINGS;
    private JList<String> listDataSources;
    private JCheckBox cbDvdOrder;

    public TvShowSourcePanel() {
        this.initComponents();
        this.initDataBindings();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][grow]"));
        JLabel lblDataSource = new JLabel(BUNDLE.getString("wizard.tvshow.datasources"));
        TmmFontHelper.changeFont(lblDataSource, 1.3333, 1);
        this.add((Component)lblDataSource, "cell 0 0");
        JPanel panelTvShowDataSources = new JPanel();
        this.add((Component)panelTvShowDataSources, "cell 0 1,grow");
        panelTvShowDataSources.setLayout((LayoutManager)new MigLayout("", "[grow][]", "[][grow][]"));
        ReadOnlyTextArea tpDatasourceHint = new ReadOnlyTextArea(BUNDLE.getString("wizard.datasource.hint"));
        panelTvShowDataSources.add((Component)tpDatasourceHint, "cell 0 0 2 1,growx");
        JScrollPane scrollPaneDataSources = new JScrollPane();
        panelTvShowDataSources.add((Component)scrollPaneDataSources, "cell 0 1,grow");
        this.listDataSources = new JList();
        scrollPaneDataSources.setViewportView(this.listDataSources);
        this.cbDvdOrder = new JCheckBox(BUNDLE.getString("Settings.dvdorder"));
        panelTvShowDataSources.add((Component)this.cbDvdOrder, "flowx,cell 0 2");
        JButton btnAdd = new JButton(IconManager.ADD_INV);
        panelTvShowDataSources.add((Component)btnAdd, "flowy,cell 1 1,aligny top");
        btnAdd.setToolTipText(BUNDLE.getString("Button.add"));
        btnAdd.setMargin(new Insets(2, 2, 2, 2));
        btnAdd.addActionListener(arg0 -> {
            String path = TmmProperties.getInstance().getProperty("tvshow.datasource.path");
            Path file = TmmUIHelper.selectDirectory(BUNDLE.getString("Settings.tvshowdatasource.folderchooser"), path);
            if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                this.settings.addTvShowDataSources(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty("tvshow.datasource.path", file.toAbsolutePath().toString());
            }
        });
        JButton btnRemove = new JButton(IconManager.REMOVE_INV);
        panelTvShowDataSources.add((Component)btnRemove, "cell 1 1");
        btnRemove.setToolTipText(BUNDLE.getString("Button.remove"));
        btnRemove.setMargin(new Insets(2, 2, 2, 2));
        btnRemove.addActionListener(arg0 -> {
            int row = this.listDataSources.getSelectedIndex();
            if (row != -1) {
                String path = this.settings.getTvShowDataSource().get(row);
                Object[] choices = new String[]{BUNDLE.getString("Button.continue"), BUNDLE.getString("Button.abort")};
                int decision = JOptionPane.showOptionDialog(null, String.format(BUNDLE.getString("Settings.tvshowdatasource.remove.info"), path), BUNDLE.getString("Settings.datasource.remove"), 0, -1, null, choices, BUNDLE.getString("Button.abort"));
                if (decision == 0) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.settings.removeTvShowDataSources(path);
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    protected void initDataBindings() {
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"dvdOrder");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.cbDvdOrder, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"tvShowDataSource");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, this.listDataSources);
        jListBinding.bind();
    }
}

