/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader;

import com.alibaba.fastjson.JSONObject;
import com.github.kiulian.downloader.YoutubeException;
import com.github.kiulian.downloader.cipher.CipherFunction;
import com.github.kiulian.downloader.model.VideoDetails;
import com.github.kiulian.downloader.model.YoutubeVideo;
import com.github.kiulian.downloader.model.formats.Format;
import com.github.kiulian.downloader.model.playlist.PlaylistDetails;
import com.github.kiulian.downloader.model.playlist.PlaylistVideoDetails;
import com.github.kiulian.downloader.model.playlist.YoutubePlaylist;
import com.github.kiulian.downloader.model.subtitles.SubtitlesInfo;
import com.github.kiulian.downloader.parser.DefaultParser;
import com.github.kiulian.downloader.parser.Parser;
import java.util.List;

public class YoutubeDownloader {
    private Parser parser;

    public YoutubeDownloader() {
        this.parser = new DefaultParser();
    }

    public YoutubeDownloader(Parser parser) {
        this.parser = parser;
    }

    public void setParserRequestProperty(String string, String string2) {
        this.parser.getExtractor().setRequestProperty(string, string2);
    }

    public void setParserRetryOnFailure(int n) {
        this.parser.getExtractor().setRetryOnFailure(n);
    }

    public void addCipherFunctionPattern(int n, String string) {
        this.parser.getCipherFactory().addInitialFunctionPattern(n, string);
    }

    public void addCipherFunctionEquivalent(String string, CipherFunction cipherFunction) {
        this.parser.getCipherFactory().addFunctionEquivalent(string, cipherFunction);
    }

    public YoutubeVideo getVideo(String string) throws YoutubeException {
        String string2 = "https://www.youtube.com/watch?v=" + string;
        JSONObject jSONObject = this.parser.getPlayerConfig(string2);
        jSONObject.put("yt-downloader-videoId", (Object)string);
        VideoDetails videoDetails = this.parser.getVideoDetails(jSONObject);
        List<Format> list = this.parser.parseFormats(jSONObject);
        List<SubtitlesInfo> list2 = this.parser.getSubtitlesInfoFromCaptions(jSONObject);
        String string3 = this.parser.getClientVersion(jSONObject);
        return new YoutubeVideo(videoDetails, list, list2, string3);
    }

    public YoutubePlaylist getPlaylist(String string) throws YoutubeException {
        String string2 = "https://www.youtube.com/playlist?list=" + string;
        JSONObject jSONObject = this.parser.getInitialData(string2);
        PlaylistDetails playlistDetails = this.parser.getPlaylistDetails(string, jSONObject);
        List<PlaylistVideoDetails> list = this.parser.getPlaylistVideos(jSONObject, playlistDetails.videoCount());
        return new YoutubePlaylist(playlistDetails, list);
    }

    public List<SubtitlesInfo> getVideoSubtitles(String string) throws YoutubeException {
        return this.parser.getSubtitlesInfo(string);
    }
}

