/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.cipher;

import com.github.kiulian.downloader.YoutubeException;
import com.github.kiulian.downloader.cipher.Cipher;
import com.github.kiulian.downloader.cipher.CipherFactory;
import com.github.kiulian.downloader.cipher.CipherFunction;
import com.github.kiulian.downloader.cipher.DefaultCipher;
import com.github.kiulian.downloader.cipher.JsFunction;
import com.github.kiulian.downloader.cipher.ReverseFunction;
import com.github.kiulian.downloader.cipher.SpliceFunction;
import com.github.kiulian.downloader.cipher.SwapFunctionV1;
import com.github.kiulian.downloader.cipher.SwapFunctionV2;
import com.github.kiulian.downloader.extractor.Extractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CachedCipherFactory
implements CipherFactory {
    private static String[] INITIAL_FUNCTION_PATTERNS = new String[]{"\\b[cs]\\s*&&\\s*[adf]\\.set\\([^,]+\\s*,\\s*encodeURIComponent\\s*\\(\\s*([a-zA-Z0-9$]+)\\(", "\\b[a-zA-Z0-9]+\\s*&&\\s*[a-zA-Z0-9]+\\.set\\([^,]+\\s*,\\s*encodeURIComponent\\s*\\(\\s*([a-zA-Z0-9$]+)\\(", "(?:\\b|[^a-zA-Z0-9$])([a-zA-Z0-9$]{2})\\s*=\\s*function\\(\\s*a\\s*\\)\\s*\\{\\s*a\\s*=\\s*a\\.split\\(\\s*\"\"\\s*\\)", "([a-zA-Z0-9$]+)\\s*=\\s*function\\(\\s*a\\s*\\)\\s*\\{\\s*a\\s*=\\s*a\\.split\\(\\s*\"\"\\s*\\)", "([\"'])signature\\1\\s*,\\s*([a-zA-Z0-9$]+)\\(", "\\.sig\\|\\|([a-zA-Z0-9$]+)\\(", "yt\\.akamaized\\.net/\\)\\s*\\|\\|\\s*.*?\\s*[cs]\\s*&&\\s*[adf]\\.set\\([^,]+\\s*,\\s*(?:encodeURIComponent\\s*\\()?\\s*()$", "\\b[cs]\\s*&&\\s*[adf]\\.set\\([^,]+\\s*,\\s*([a-zA-Z0-9$]+)\\(", "\\b[a-zA-Z0-9]+\\s*&&\\s*[a-zA-Z0-9]+\\.set\\([^,]+\\s*,\\s*([a-zA-Z0-9$]+)\\(", "\\bc\\s*&&\\s*a\\.set\\([^,]+\\s*,\\s*\\([^)]*\\)\\s*\\(\\s*([a-zA-Z0-9$]+)\\(", "\\bc\\s*&&\\s*[a-zA-Z0-9]+\\.set\\([^,]+\\s*,\\s*\\([^)]*\\)\\s*\\(\\s*([a-zA-Z0-9$]+)\\("};
    private static String FUNCTION_REVERSE_PATTERN = "\\{\\w\\.reverse\\(\\)\\}";
    private static String FUNCTION_SPLICE_PATTERN = "\\{\\w\\.splice\\(0,\\w\\)\\}";
    private static String FUNCTION_SWAP1_PATTERN = "\\{var\\s\\w=\\w\\[0];\\w\\[0]=\\w\\[\\w%\\w.length];\\w\\[\\w]=\\w\\}";
    private static String FUNCTION_SWAP2_PATTERN = "\\{var\\s\\w=\\w\\[0];\\w\\[0]=\\w\\[\\w%\\w.length];\\w\\[\\w%\\w.length]=\\w\\}";
    private static Pattern JS_FUNCTION_PATTERN = Pattern.compile("\\w+\\.(\\w+)\\(\\w,(\\d+)\\)");
    private Extractor extractor;
    private List<Pattern> knownInitialFunctionPatterns = new ArrayList<Pattern>();
    private Map<Pattern, CipherFunction> functionsEquivalentMap = new HashMap<Pattern, CipherFunction>();
    private Map<String, Cipher> ciphers = new HashMap<String, Cipher>();

    public CachedCipherFactory(Extractor extractor) {
        this.extractor = extractor;
        for (String string : INITIAL_FUNCTION_PATTERNS) {
            this.addInitialFunctionPattern(this.knownInitialFunctionPatterns.size(), string);
        }
        this.addFunctionEquivalent(FUNCTION_REVERSE_PATTERN, new ReverseFunction());
        this.addFunctionEquivalent(FUNCTION_SPLICE_PATTERN, new SpliceFunction());
        this.addFunctionEquivalent(FUNCTION_SWAP1_PATTERN, new SwapFunctionV1());
        this.addFunctionEquivalent(FUNCTION_SWAP2_PATTERN, new SwapFunctionV2());
    }

    @Override
    public void addInitialFunctionPattern(int n, String string) {
        this.knownInitialFunctionPatterns.add(n, Pattern.compile(string));
    }

    @Override
    public void addFunctionEquivalent(String string, CipherFunction cipherFunction) {
        this.functionsEquivalentMap.put(Pattern.compile(string), cipherFunction);
    }

    @Override
    public Cipher createCipher(String string) throws YoutubeException {
        Cipher cipher = this.ciphers.get(string);
        if (cipher == null) {
            String string2 = this.extractor.loadUrl(string);
            List<JsFunction> list = this.getTransformFunctions(string2);
            String string3 = list.get(0).getVar();
            Map<String, CipherFunction> map = this.getTransformFunctionsMap(string3, string2);
            cipher = new DefaultCipher(list, map);
            this.ciphers.put(string, cipher);
        }
        return cipher;
    }

    public void clearCache() {
        this.ciphers.clear();
    }

    private List<JsFunction> getTransformFunctions(String string) throws YoutubeException {
        String string2 = this.getInitialFunctionName(string).replaceAll("[^$A-Za-z0-9_]", "");
        Pattern pattern = Pattern.compile(Pattern.quote(string2) + "=function\\(\\w\\)\\{[a-z=\\.\\(\\\"\\)]*;(.*);(?:.+)\\}");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String[] stringArray = matcher.group(1).split(";");
            ArrayList<JsFunction> arrayList = new ArrayList<JsFunction>(stringArray.length);
            for (String string3 : stringArray) {
                String string4 = string3.split("\\.")[0];
                String[] stringArray2 = this.parseFunction(string3);
                String string5 = stringArray2[0];
                String string6 = stringArray2[1];
                arrayList.add(new JsFunction(string4, string5, string6));
            }
            return arrayList;
        }
        throw new YoutubeException.CipherException("Transformation functions not found");
    }

    private String getInitialFunctionName(String string) throws YoutubeException {
        for (Pattern pattern : this.knownInitialFunctionPatterns) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        throw new YoutubeException.CipherException("Initial function name not found");
    }

    private Map<String, CipherFunction> getTransformFunctionsMap(String string, String string2) throws YoutubeException {
        String[] stringArray = this.getTransformObject(string, string2);
        HashMap<String, CipherFunction> hashMap = new HashMap<String, CipherFunction>();
        for (String string3 : stringArray) {
            String[] stringArray2 = string3.split(":", 2);
            String string4 = stringArray2[0];
            String string5 = stringArray2[1];
            CipherFunction cipherFunction = this.mapFunction(string5);
            hashMap.put(string4, cipherFunction);
        }
        return hashMap;
    }

    private String[] getTransformObject(String string, String string2) throws YoutubeException {
        string = string.replaceAll("[^$A-Za-z0-9_]", "");
        string = Pattern.quote(string);
        Pattern pattern = Pattern.compile(String.format("var %s=\\{(.*?)\\};", string), 32);
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find()) {
            return matcher.group(1).replaceAll("\n", " ").split(", ");
        }
        throw new YoutubeException.CipherException("Transofrm object not found");
    }

    private CipherFunction mapFunction(String string) throws YoutubeException {
        for (Map.Entry<Pattern, CipherFunction> entry : this.functionsEquivalentMap.entrySet()) {
            Matcher matcher = entry.getKey().matcher(string);
            if (!matcher.find()) continue;
            return entry.getValue();
        }
        throw new YoutubeException.CipherException("Map function not found");
    }

    private String[] parseFunction(String string) throws YoutubeException {
        Matcher matcher = JS_FUNCTION_PATTERN.matcher(string);
        String[] stringArray = new String[2];
        if (matcher.find()) {
            stringArray[0] = matcher.group(1);
            stringArray[1] = matcher.group(2);
            return stringArray;
        }
        throw new YoutubeException.CipherException("Could not parse js function");
    }
}

