/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model.playlist;

import com.alibaba.fastjson.JSONObject;
import com.github.kiulian.downloader.YoutubeException;
import com.github.kiulian.downloader.model.AbstractVideoDetails;

public class PlaylistVideoDetails
extends AbstractVideoDetails {
    private int index;
    private boolean isPlayable;

    public PlaylistVideoDetails() {
    }

    public PlaylistVideoDetails(JSONObject jSONObject) {
        super(jSONObject);
        JSONObject jSONObject2;
        if (jSONObject.containsKey("shortBylineText")) {
            this.author = jSONObject.getJSONObject("shortBylineText").getJSONArray("runs").getJSONObject(0).getString("text");
        }
        this.title = (jSONObject2 = jSONObject.getJSONObject("title")).containsKey("simpleText") ? jSONObject2.getString("simpleText") : jSONObject2.getJSONArray("runs").getJSONObject(0).getString("text");
        if (!this.thumbnails().isEmpty()) {
            this.isLive = this.thumbnails().get(0).contains("/hqdefault_live.jpg?");
        }
        if (jSONObject.containsKey("index")) {
            this.index = jSONObject.getJSONObject("index").getIntValue("simpleText");
        }
        this.isPlayable = jSONObject.getBooleanValue("isPlayable");
    }

    @Override
    protected void checkDownload() throws YoutubeException.DownloadUnavailableException {
        if (!this.isPlayable) {
            throw new YoutubeException.RestrictedVideoException("Can not download " + this.title());
        }
        if (this.isLive() || this.lengthSeconds() == 0) {
            throw new YoutubeException.LiveVideoException("Can not download live stream");
        }
    }

    public int index() {
        return this.index;
    }

    public boolean isPlayable() {
        return this.isPlayable;
    }
}

