/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model.subtitles;

import com.github.kiulian.downloader.YoutubeException;
import com.github.kiulian.downloader.model.Extension;
import com.github.kiulian.downloader.model.Utils;
import com.github.kiulian.downloader.model.subtitles.OnSubtitlesDownloadListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class Subtitles {
    private final String url;
    private Extension format;
    private String translationLanguage;

    Subtitles(String string) {
        this.url = string;
    }

    public Subtitles formatTo(Extension extension) {
        this.format = extension;
        return this;
    }

    public Subtitles translateTo(String string) {
        this.translationLanguage = string;
        return this;
    }

    public String getDownloadUrl() {
        String string = this.url;
        if (this.format != null && this.format.isSubtitle()) {
            string = string + "&fmt=" + this.format.value();
        }
        if (this.translationLanguage != null && !this.translationLanguage.isEmpty()) {
            string = string + "&tlang=" + this.translationLanguage;
        }
        return string;
    }

    public String download() throws YoutubeException {
        URL uRL;
        try {
            uRL = new URL(this.getDownloadUrl());
        }
        catch (MalformedURLException malformedURLException) {
            throw new YoutubeException.SubtitlesException("Failed to download subtitle: Invalid url: " + malformedURLException.getMessage());
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            String string;
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                throw new YoutubeException.SubtitlesException("Failed to download subtitle: HTTP " + n);
            }
            if (httpURLConnection.getContentLength() == 0) {
                throw new YoutubeException.SubtitlesException("Failed to download subtitle: Response is empty");
            }
            bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append('\n');
            }
        }
        catch (IOException iOException) {
            try {
                throw new YoutubeException.SubtitlesException("Failed to download subtitle: " + iOException.getMessage());
            }
            catch (Throwable throwable) {
                Utils.closeSilently(bufferedReader);
                throw throwable;
            }
        }
        Utils.closeSilently(bufferedReader);
        return stringBuilder.toString();
    }

    public Future<String> downloadAsync() {
        return this.downloadAsync(null);
    }

    public Future<String> downloadAsync(final OnSubtitlesDownloadListener onSubtitlesDownloadListener) {
        FutureTask<String> futureTask = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() {
                String string;
                block3: {
                    string = null;
                    try {
                        string = Subtitles.this.download();
                        if (onSubtitlesDownloadListener != null) {
                            onSubtitlesDownloadListener.onFinished(string);
                        }
                    }
                    catch (YoutubeException youtubeException) {
                        if (onSubtitlesDownloadListener == null) break block3;
                        onSubtitlesDownloadListener.onError(youtubeException);
                    }
                }
                return string;
            }
        });
        Thread thread = new Thread(futureTask, "YtSubDownloader");
        thread.setDaemon(true);
        thread.start();
        return futureTask;
    }
}

