/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.kiulian.downloader.YoutubeException;
import com.github.kiulian.downloader.cipher.CachedCipherFactory;
import com.github.kiulian.downloader.cipher.Cipher;
import com.github.kiulian.downloader.cipher.CipherFactory;
import com.github.kiulian.downloader.extractor.DefaultExtractor;
import com.github.kiulian.downloader.extractor.Extractor;
import com.github.kiulian.downloader.model.Itag;
import com.github.kiulian.downloader.model.VideoDetails;
import com.github.kiulian.downloader.model.formats.AudioFormat;
import com.github.kiulian.downloader.model.formats.AudioVideoFormat;
import com.github.kiulian.downloader.model.formats.Format;
import com.github.kiulian.downloader.model.formats.VideoFormat;
import com.github.kiulian.downloader.model.playlist.PlaylistDetails;
import com.github.kiulian.downloader.model.playlist.PlaylistVideoDetails;
import com.github.kiulian.downloader.model.subtitles.SubtitlesInfo;
import com.github.kiulian.downloader.parser.Parser;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultParser
implements Parser {
    private static final Pattern subtitleLangCodeRegex = Pattern.compile("lang_code=\"(.{2,3})\"");
    private static final Pattern textNumberRegex = Pattern.compile("[0-9, ']+");
    private static final Pattern assetsJsRegex = Pattern.compile("\"assets\":.+?\"js\":\\s*\"([^\"]+)\"");
    private static final Pattern embJsRegex = Pattern.compile("\"jsUrl\":\\s*\"([^\"]+)\"");
    private Extractor extractor = new DefaultExtractor();
    private CipherFactory cipherFactory = new CachedCipherFactory(this.extractor);

    @Override
    public Extractor getExtractor() {
        return this.extractor;
    }

    @Override
    public CipherFactory getCipherFactory() {
        return this.cipherFactory;
    }

    @Override
    public JSONObject getPlayerConfig(String string) throws YoutubeException {
        String string2 = this.extractor.loadUrl(string);
        String string3 = this.extractor.extractYtPlayerConfig(string2);
        try {
            JSONObject jSONObject = JSON.parseObject(string3);
            if (jSONObject.containsKey("args")) {
                return jSONObject;
            }
            return new JSONObject().fluentPut("args", new JSONObject().fluentPut("player_response", jSONObject));
        }
        catch (Exception exception) {
            throw new YoutubeException.BadPageException("Could not parse player config json");
        }
    }

    @Override
    public String getClientVersion(JSONObject jSONObject) {
        return this.getClientVersionFromContext(jSONObject.getJSONObject("args").getJSONObject("player_response").getJSONObject("responseContext"));
    }

    @Override
    public String getJsUrl(JSONObject jSONObject) throws YoutubeException {
        String string = null;
        if (jSONObject.containsKey("assets")) {
            string = jSONObject.getJSONObject("assets").getString("js");
        } else {
            String string2 = jSONObject.getString("yt-downloader-videoId");
            String string3 = this.extractor.loadUrl("https://www.youtube.com/embed/" + string2);
            Matcher matcher = assetsJsRegex.matcher(string3);
            if (matcher.find()) {
                string = matcher.group(1).replace("\\", "");
            } else {
                matcher = embJsRegex.matcher(string3);
                if (matcher.find()) {
                    string = matcher.group(1).replace("\\", "");
                }
            }
        }
        if (string == null) {
            throw new YoutubeException.BadPageException("Could not extract js url: assets not found");
        }
        return "https://youtube.com" + string;
    }

    @Override
    public VideoDetails getVideoDetails(JSONObject jSONObject) {
        JSONObject jSONObject2 = jSONObject.getJSONObject("args");
        JSONObject jSONObject3 = jSONObject2.getJSONObject("player_response");
        if (jSONObject3.containsKey("videoDetails")) {
            JSONObject jSONObject4 = jSONObject3.getJSONObject("videoDetails");
            String string = null;
            if (jSONObject4.getBooleanValue("isLive") && jSONObject3.containsKey("streamingData")) {
                string = jSONObject3.getJSONObject("streamingData").getString("hlsManifestUrl");
            }
            return new VideoDetails(jSONObject4, string);
        }
        return new VideoDetails();
    }

    @Override
    public List<SubtitlesInfo> getSubtitlesInfoFromCaptions(JSONObject jSONObject) {
        JSONObject jSONObject2 = jSONObject.getJSONObject("args");
        JSONObject jSONObject3 = jSONObject2.getJSONObject("player_response");
        if (!jSONObject3.containsKey("captions")) {
            return Collections.emptyList();
        }
        JSONObject jSONObject4 = jSONObject3.getJSONObject("captions");
        JSONObject jSONObject5 = jSONObject4.getJSONObject("playerCaptionsTracklistRenderer");
        if (jSONObject5 == null || jSONObject5.isEmpty()) {
            return Collections.emptyList();
        }
        JSONArray jSONArray = jSONObject5.getJSONArray("captionTracks");
        if (jSONArray == null || jSONArray.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SubtitlesInfo> arrayList = new ArrayList<SubtitlesInfo>();
        for (int i = 0; i < jSONArray.size(); ++i) {
            JSONObject jSONObject6 = jSONArray.getJSONObject(i);
            String string = jSONObject6.getString("languageCode");
            String string2 = jSONObject6.getString("baseUrl");
            String string3 = jSONObject6.getString("vssId");
            if (string == null || string2 == null || string3 == null) continue;
            boolean bl = string3.startsWith("a.");
            arrayList.add(new SubtitlesInfo(string2, string, bl));
        }
        return arrayList;
    }

    @Override
    public List<SubtitlesInfo> getSubtitlesInfo(String string) throws YoutubeException {
        String string2 = "https://video.google.com/timedtext?hl=en&type=list&v=" + string;
        String string3 = this.extractor.loadUrl(string2);
        Matcher matcher = subtitleLangCodeRegex.matcher(string3);
        if (!matcher.find()) {
            return Collections.emptyList();
        }
        ArrayList<SubtitlesInfo> arrayList = new ArrayList<SubtitlesInfo>();
        do {
            String string4 = matcher.group(1);
            String string5 = String.format("https://www.youtube.com/api/timedtext?lang=%s&v=%s", string4, string);
            arrayList.add(new SubtitlesInfo(string5, string4, false));
        } while (matcher.find());
        return arrayList;
    }

    @Override
    public List<Format> parseFormats(JSONObject jSONObject) throws YoutubeException {
        JSONObject jSONObject2 = jSONObject.getJSONObject("args");
        JSONObject jSONObject3 = jSONObject2.getJSONObject("player_response");
        if (!jSONObject3.containsKey("streamingData")) {
            throw new YoutubeException.BadPageException("Streaming data not found");
        }
        JSONObject jSONObject4 = jSONObject3.getJSONObject("streamingData");
        JSONArray jSONArray = new JSONArray();
        if (jSONObject4.containsKey("formats")) {
            jSONArray.addAll(jSONObject4.getJSONArray("formats"));
        }
        JSONArray jSONArray2 = new JSONArray();
        if (jSONObject4.containsKey("adaptiveFormats")) {
            jSONArray2.addAll(jSONObject4.getJSONArray("adaptiveFormats"));
        }
        String string = this.getJsUrl(jSONObject);
        ArrayList<Format> arrayList = new ArrayList<Format>(jSONArray.size() + jSONArray2.size());
        this.populateFormats(arrayList, jSONArray, string, false);
        this.populateFormats(arrayList, jSONArray2, string, true);
        return arrayList;
    }

    @Override
    public JSONObject getInitialData(String string) throws YoutubeException {
        String string2 = this.extractor.loadUrl(string);
        String string3 = this.extractor.extractYtInitialData(string2);
        try {
            return JSON.parseObject(string3);
        }
        catch (Exception exception) {
            throw new YoutubeException.BadPageException("Could not parse initial data json");
        }
    }

    @Override
    public PlaylistDetails getPlaylistDetails(String string, JSONObject jSONObject) {
        String string2 = jSONObject.getJSONObject("metadata").getJSONObject("playlistMetadataRenderer").getString("title");
        JSONArray jSONArray = jSONObject.getJSONObject("sidebar").getJSONObject("playlistSidebarRenderer").getJSONArray("items");
        String string3 = null;
        try {
            string3 = jSONArray.getJSONObject(1).getJSONObject("playlistSidebarSecondaryInfoRenderer").getJSONObject("videoOwner").getJSONObject("videoOwnerRenderer").getJSONObject("title").getJSONArray("runs").getJSONObject(0).getString("text");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSONArray jSONArray2 = jSONArray.getJSONObject(0).getJSONObject("playlistSidebarPrimaryInfoRenderer").getJSONArray("stats");
        int n = DefaultParser.extractNumber(jSONArray2.getJSONObject(0).getJSONArray("runs").getJSONObject(0).getString("text"));
        int n2 = DefaultParser.extractNumber(jSONArray2.getJSONObject(1).getString("simpleText"));
        return new PlaylistDetails(string, string2, string3, n, n2);
    }

    @Override
    public List<PlaylistVideoDetails> getPlaylistVideos(JSONObject jSONObject, int n) throws YoutubeException {
        JSONObject jSONObject2;
        try {
            jSONObject2 = jSONObject.getJSONObject("contents").getJSONObject("twoColumnBrowseResultsRenderer").getJSONArray("tabs").getJSONObject(0).getJSONObject("tabRenderer").getJSONObject("content").getJSONObject("sectionListRenderer").getJSONArray("contents").getJSONObject(0).getJSONObject("itemSectionRenderer").getJSONArray("contents").getJSONObject(0).getJSONObject("playlistVideoListRenderer");
        }
        catch (NullPointerException nullPointerException) {
            throw new YoutubeException.BadPageException("Playlist initial data not found");
        }
        AbstractList abstractList = n > 0 ? new ArrayList(n) : new LinkedList();
        this.populatePlaylist(jSONObject2, abstractList, this.getClientVersionFromContext(jSONObject.getJSONObject("responseContext")));
        return abstractList;
    }

    private void populateFormats(List<Format> list, JSONArray jSONArray, String string, boolean bl) throws YoutubeException.CipherException {
        for (int i = 0; i < jSONArray.size(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            if ("FORMAT_STREAM_TYPE_OTF".equals(jSONObject.getString("type"))) continue;
            try {
                Format format = this.parseFormat(jSONObject, string, bl);
                list.add(format);
                continue;
            }
            catch (YoutubeException.CipherException cipherException) {
                throw cipherException;
            }
            catch (YoutubeException youtubeException) {
                System.err.println("Error parsing format: " + youtubeException.getMessage());
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private Format parseFormat(JSONObject jSONObject, String string, boolean bl) throws YoutubeException {
        boolean bl2;
        Object object;
        if (jSONObject.containsKey("signatureCipher")) {
            Object object2;
            object = new JSONObject();
            String[] stringArray = jSONObject.getString("signatureCipher").replace("\\u0026", "&").split("&");
            for (String string2 : stringArray) {
                object2 = string2.split("=");
                ((JSONObject)object).put(object2[0], (Object)object2[1]);
            }
            if (!((JSONObject)object).containsKey("url")) {
                throw new YoutubeException.BadPageException("Could not found url in cipher data");
            }
            Object object3 = ((JSONObject)object).getString("url");
            try {
                object3 = URLDecoder.decode((String)object3, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            if (!((String)object3).contains("signature") && (((JSONObject)object).containsKey("s") || !((String)object3).contains("&sig=") && !((String)object3).contains("&lsig="))) {
                String string2;
                String string3 = ((JSONObject)object).getString("s");
                try {
                    string3 = URLDecoder.decode(string3, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
                Cipher cipher = this.cipherFactory.createCipher(string);
                string2 = cipher.getSignature(string3);
                object2 = (String)object3 + "&sig=" + string2;
                jSONObject.put("url", object2);
            }
        }
        try {
            object = Itag.valueOf("i" + jSONObject.getInteger("itag"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            object = Itag.unknown;
            ((Itag)((Object)object)).setId(jSONObject.getIntValue("itag"));
        }
        boolean bl3 = ((Itag)((Object)object)).isVideo() || jSONObject.containsKey("size") || jSONObject.containsKey("width");
        boolean bl4 = bl2 = ((Itag)((Object)object)).isAudio() || jSONObject.containsKey("audioQuality");
        if (bl3 && bl2) {
            return new AudioVideoFormat(jSONObject, bl);
        }
        if (bl3) {
            return new VideoFormat(jSONObject, bl);
        }
        if (bl2) {
            return new AudioFormat(jSONObject, bl);
        }
        throw new YoutubeException.UnknownFormatException("unknown format with itag " + ((Itag)((Object)object)).id());
    }

    private void populatePlaylist(JSONObject jSONObject, List<PlaylistVideoDetails> list, String string) throws YoutubeException {
        JSONArray jSONArray;
        if (jSONObject.containsKey("contents")) {
            jSONArray = jSONObject.getJSONArray("contents");
        } else if (jSONObject.containsKey("continuationItems")) {
            jSONArray = jSONObject.getJSONArray("continuationItems");
        } else {
            if (jSONObject.containsKey("continuations")) {
                String string2 = jSONObject.getJSONArray("continuations").getJSONObject(0).getJSONObject("nextContinuationData").getString("continuation");
                this.loadPlaylistContinuation(string2, list, string);
                return;
            }
            return;
        }
        for (int i = 0; i < jSONArray.size(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            if (jSONObject2.containsKey("playlistVideoRenderer")) {
                list.add(new PlaylistVideoDetails(jSONObject2.getJSONObject("playlistVideoRenderer")));
                continue;
            }
            if (!jSONObject2.containsKey("continuationItemRenderer")) continue;
            String string3 = jSONObject2.getJSONObject("continuationItemRenderer").getJSONObject("continuationEndpoint").getJSONObject("continuationCommand").getString("token");
            this.loadPlaylistContinuation(string3, list, string);
        }
    }

    private void loadPlaylistContinuation(String string, List<PlaylistVideoDetails> list, String string2) throws YoutubeException {
        String string3 = "https://www.youtube.com/browse_ajax?ctoken=" + string + "&continuation=" + string;
        this.getExtractor().setRequestProperty("X-YouTube-Client-Name", "1");
        this.getExtractor().setRequestProperty("X-YouTube-Client-Version", string2);
        String string4 = this.getExtractor().loadUrl(string3);
        try {
            JSONArray jSONArray = JSON.parseArray(string4);
            JSONObject jSONObject = jSONArray.getJSONObject(1).getJSONObject("response");
            JSONObject jSONObject2 = jSONObject.containsKey("continuationContents") ? jSONObject.getJSONObject("continuationContents").getJSONObject("playlistVideoListContinuation") : jSONObject.getJSONArray("onResponseReceivedActions").getJSONObject(0).getJSONObject("appendContinuationItemsAction");
            this.populatePlaylist(jSONObject2, list, string2);
        }
        catch (YoutubeException youtubeException) {
            throw youtubeException;
        }
        catch (Exception exception) {
            throw new YoutubeException.BadPageException("Could not parse playlist continuation json");
        }
    }

    private String getClientVersionFromContext(JSONObject jSONObject) {
        JSONArray jSONArray = jSONObject.getJSONArray("serviceTrackingParams");
        if (jSONArray == null) {
            return "2.20200720.00.02";
        }
        for (int i = 0; i < jSONArray.size(); ++i) {
            JSONArray jSONArray2 = jSONArray.getJSONObject(i).getJSONArray("params");
            for (int j = 0; j < jSONArray2.size(); ++j) {
                if (!jSONArray2.getJSONObject(j).getString("key").equals("cver")) continue;
                return jSONArray2.getJSONObject(j).getString("value");
            }
        }
        return null;
    }

    private static int extractNumber(String string) {
        Matcher matcher = textNumberRegex.matcher(string);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(0).replaceAll("[, ']", ""));
        }
        return 0;
    }
}

