/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf;

import com.github.stephenc.javaisotools.loopfs.udf.UDFFileEntry;
import com.github.stephenc.javaisotools.loopfs.udf.UDFFileSystem;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class UDFEntryIterator
implements Iterator<UDFFileEntry> {
    private final UDFFileSystem fs;
    private final List<UDFFileEntry> queue;

    public UDFEntryIterator(UDFFileSystem fs, UDFFileEntry rootEntry) {
        this.fs = fs;
        this.queue = new LinkedList<UDFFileEntry>();
        if (rootEntry != null) {
            this.queue.add(rootEntry);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public UDFFileEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        UDFFileEntry entry = this.queue.remove(0);
        if (entry.isDirectory()) {
            try {
                entry.loadFiles();
                for (UDFFileEntry fe : entry.getFiles()) {
                    this.queue.add(fe);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return entry;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

