/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf;

import com.github.stephenc.javaisotools.loopfs.api.FileEntry;
import com.github.stephenc.javaisotools.loopfs.spi.VolumeDescriptorSet;
import com.github.stephenc.javaisotools.loopfs.udf.UDFFileEntry;
import com.github.stephenc.javaisotools.loopfs.udf.UDFFileSystem;
import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.ExtendedFileEntryDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.FileEntryDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.FileSetDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.PartitionDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.PrimaryVolumeDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.DescriptorTag;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDFVolumeDescriptorSet
implements VolumeDescriptorSet {
    private static final Log log = LogFactory.getLog(UDFVolumeDescriptorSet.class);
    private UDFFileSystem fs;
    public PrimaryVolumeDescriptor pvd;
    public PartitionDescriptor pd;
    public FileSetDescriptor rootFSD;
    public FileEntryDescriptor rootEntry;

    public UDFVolumeDescriptorSet(UDFFileSystem fs) {
        this.fs = fs;
    }

    public boolean deserialize(byte[] bytes) throws IOException {
        Integer type = UDFUtil.getUInt16(bytes, 0);
        boolean terminated = false;
        try {
            switch (type) {
                case 1: {
                    this.pvd = new PrimaryVolumeDescriptor(bytes);
                    log.debug((Object)"Found primary volume descriptor.");
                    break;
                }
                case 4: {
                    log.debug((Object)"Found implementation use descriptor.");
                    break;
                }
                case 5: {
                    this.pd = new PartitionDescriptor(bytes);
                    log.debug((Object)"Found partition descriptor.");
                    this.tracePartition();
                    break;
                }
                case 6: {
                    log.debug((Object)"Found logical volume descriptor.");
                    break;
                }
                case 7: {
                    log.debug((Object)"Found unallocated space descriptor.");
                    break;
                }
                case 8: {
                    terminated = true;
                    log.debug((Object)"Found terminating descriptor.");
                    break;
                }
                default: {
                    log.debug((Object)("Found unknown volume descriptor with type: " + type));
                    break;
                }
            }
        }
        catch (InvalidDescriptor ex) {
            throw new IOException(ex.getMessage());
        }
        return terminated;
    }

    private void tracePartition() throws IOException, InvalidDescriptor {
        byte[] buffer = new byte[2048];
        long startingLocation = this.getPDStartPos() + this.fs.getAnchor().mainVolumeExtent.location;
        this.fs.readBlock(startingLocation, buffer);
        this.rootFSD = new FileSetDescriptor(buffer);
        this.fs.readBlock(startingLocation + this.rootFSD.rootICB.location.blockNumber, buffer);
        DescriptorTag tag = new DescriptorTag(buffer);
        if (tag.identifier == 261) {
            this.rootEntry = new FileEntryDescriptor(buffer);
        } else if (tag.identifier == 266) {
            this.rootEntry = new ExtendedFileEntryDescriptor(buffer);
        }
    }

    public FileEntry getRootEntry() {
        return new UDFFileEntry(this.fs, this.rootEntry, null, null, true);
    }

    public long getPDStartPos() {
        return this.pd.startingLocation;
    }
}

