/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.UDFFileSystem;
import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.FileEntryDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.FileIdentifierDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ExtentAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ICBTag;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.LongAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.RegId;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.Timestamp;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.io.IOException;
import java.math.BigInteger;

public class ExtendedFileEntryDescriptor
extends FileEntryDescriptor {
    public BigInteger objectSize;
    public Timestamp creatiDT;
    public LongAD streamDirICB;
    public final int LEN_ICB_TAG = 20;
    public final int LEN_UID = 4;
    public final int LEN_GID = 4;
    public final int LEN_PERM = 4;
    public final int LEN_F_LINK_CNT = 2;
    public final int LEN_RCD_FMT = 1;
    public final int LEN_RCD_DISP_ATTRS = 1;
    public final int LEN_RCD_LEN = 4;
    public final int LEN_INFO_LEN = 8;
    public final int LEN_LB_RECORDED = 8;
    public final int LEN_ACCESS_DT = 12;
    public final int LEN_MODIFI_DT = 12;
    public final int LEN_CREATI_DT = 12;
    public final int LEN_ATTR_DT = 12;
    public final int LEN_CHECKPOINT = 4;
    public final int LEN_EXT_ATTR_ICB = 16;
    public final int LEN_STREAM_DIR_ICB = 16;
    public final int LEN_IMPL_ID = 32;
    public final int LEN_UNIQUE_ID = 8;
    public final int LEN_EXT_ATTR_LEN = 4;
    public final int LEN_ALLOC_DESC_LEN = 4;
    public final int BP_ICB_TAG = 16;
    public final int BP_UID = 36;
    public final int BP_GID = 40;
    public final int BP_PERM = 44;
    public final int BP_F_LINK_CNT = 48;
    public final int BP_RCD_FMT = 50;
    public final int BP_RCD_DISP_ATTRS = 51;
    public final int BP_RCD_LEN = 52;
    public final int BP_INFO_LEN = 56;
    public final int BP_OBJECT_SIZE = 64;
    public final int BP_LB_RECORDED = 72;
    public final int BP_ACCESS_DT = 80;
    public final int BP_MODIFI_DT = 92;
    public final int BP_CREATI_DT = 104;
    public final int BP_ATTR_DT = 116;
    public final int BP_CHECKPOINT = 128;
    public final int BP_EXT_ATTR_ICB = 136;
    public final int BP_STREA_DIR_ICB = 136;
    public final int BP_IMPL_ID = 168;
    public final int BP_UNIQUE_ID = 200;
    public final int BP_EXT_ATTR_LEN = 208;
    public final int BP_ALLOC_DESC_LEN = 212;
    public final int BP_EXT_ATTRS = 216;
    public final int EP_ICB_TAG = 36;
    public final int EP_UID = 40;
    public final int EP_GID = 44;
    public final int EP_PERM = 48;
    public final int EP_F_LINK_CNT = 50;
    public final int EP_RCD_FMT = 51;
    public final int EP_RCD_DISP_ATTRS = 52;
    public final int EP_RCD_LEN = 56;
    public final int EP_INFO_LEN = 64;
    public final int EP_LB_RECORDED = 80;
    public final int EP_ACCESS_DT = 92;
    public final int EP_MODIFI_DT = 104;
    public final int EP_ATTR_DT = 128;
    public final int EP_CHECKPOINT = 132;
    public final int EP_EXT_ATTR_ICB = 152;
    public final int EP_IMPL_ID = 200;
    public final int EP_UNIQUE_ID = 208;
    public final int EP_EXT_ATTR_LEN = 212;
    public final int EP_ALLOC_DESC_LEN = 216;
    public final int MINIMUM_LENGTH = 512;

    public ExtendedFileEntryDescriptor() {
    }

    public ExtendedFileEntryDescriptor(byte[] bytes) throws InvalidDescriptor {
        this.deserialize(bytes);
        this.verifyTagIdentifier();
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 266;
    }

    @Override
    public void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 512) {
            throw new InvalidDescriptor("File entry descriptor too short");
        }
        this.deserializeTag(bytes);
        byte[] fragment = UDFUtil.getBytes(bytes, 16, 20);
        this.icbTag = new ICBTag(fragment);
        this.uid = UDFUtil.getUInt32(bytes, 36);
        this.gid = UDFUtil.getUInt32(bytes, 40);
        this.permissions = UDFUtil.getUInt32(bytes, 44);
        this.fileLinks = UDFUtil.getUInt16(bytes, 48);
        this.recordFormat = UDFUtil.getUInt8(bytes, 50);
        this.recordDisplayAttrs = UDFUtil.getUInt8(bytes, 51);
        this.recordLength = UDFUtil.getUInt32(bytes, 52);
        this.infoLength = UDFUtil.getUInt64(bytes, 56);
        this.objectSize = UDFUtil.getUInt64(bytes, 64);
        this.lbRecorded = UDFUtil.getUInt64(bytes, 72);
        fragment = UDFUtil.getBytes(bytes, 80, 12);
        this.accessDT = new Timestamp(fragment);
        fragment = UDFUtil.getBytes(bytes, 92, 12);
        this.modifiDT = new Timestamp(fragment);
        fragment = UDFUtil.getBytes(bytes, 104, 12);
        this.creatiDT = new Timestamp(fragment);
        fragment = UDFUtil.getBytes(bytes, 116, 12);
        this.attributeDT = new Timestamp(fragment);
        this.checkpoint = UDFUtil.getUInt32(bytes, 128);
        fragment = UDFUtil.getBytes(bytes, 136, 16);
        this.extAttrICB = new LongAD(fragment);
        fragment = UDFUtil.getBytes(bytes, 136, 16);
        this.streamDirICB = new LongAD(fragment);
        fragment = UDFUtil.getBytes(bytes, 168, 32);
        this.implIdentifier = new RegId(fragment);
        this.uniqueId = UDFUtil.getUInt64(bytes, 200);
        this.extAttrLength = UDFUtil.getUInt32(bytes, 208);
        this.allocDescriptorLength = UDFUtil.getUInt32(bytes, 212);
        Integer maxExtAttrLen = 1832;
        if (this.extAttrLength > (long)maxExtAttrLen.intValue()) {
            throw new InvalidDescriptor("Extended attributes too long");
        }
        Integer intExtAttrLength = this.extAttrLength.intValue();
        this.extAttrs = UDFUtil.getBytes(bytes, 216, intExtAttrLength);
        Integer bpAllocDescriptors = 216 + intExtAttrLength;
        Integer maxAllocLen = 2048 - bpAllocDescriptors;
        if (this.allocDescriptorLength > (long)maxAllocLen.intValue()) {
            throw new InvalidDescriptor("Allocation descriptors too long");
        }
        Integer intAllocDescLen = this.allocDescriptorLength.intValue();
        byte[] bytesAllocDescriptors = UDFUtil.getBytes(bytes, bpAllocDescriptors, intAllocDescLen);
        int allocOffset = 0;
        while (allocOffset + 8 <= intAllocDescLen) {
            fragment = UDFUtil.getBytes(bytesAllocDescriptors, allocOffset, 8);
            this.allocDescriptors.add(new ExtentAD(fragment));
            allocOffset += 8;
        }
    }

    @Override
    public void loadChildren(UDFFileSystem fs) throws IOException {
        int bs = 2048;
        block2: for (ExtentAD ead : this.allocDescriptors) {
            int bufferLength = ead.length.intValue();
            byte[] buffer = new byte[bufferLength];
            long absStartPos = fs.getPDStartPos() + fs.getAnchor().mainVolumeExtent.location + ead.location;
            int bytesRead = fs.readBytes(absStartPos * (long)bs, buffer, 0, bufferLength);
            if ((long)bytesRead != ead.length) {
                throw new IOException("Failed to read " + ead.length + " bytes at the beginning of sector " + absStartPos + ". Actually read " + bytesRead + " bytes.");
            }
            int offset = 0;
            byte[] nextFragment = buffer;
            boolean first = true;
            boolean noMoreData = false;
            while (true) {
                FileIdentifierDescriptor fid;
                try {
                    fid = new FileIdentifierDescriptor(nextFragment);
                }
                catch (InvalidDescriptor ex) {
                    throw new IOException(ex.getMessage());
                }
                if ((offset += fid.getConsumption().intValue()) >= bufferLength) {
                    noMoreData = true;
                } else {
                    nextFragment = UDFUtil.getRemainingBytes(buffer, offset);
                }
                if (first) {
                    first = false;
                    continue;
                }
                this.fids.add(fid);
                if (noMoreData || nextFragment.length <= 40 || UDFUtil.getUInt16(nextFragment, 0) != 257) continue block2;
            }
        }
    }
}

