/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.CharSpec;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.DString;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ExtentAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.RegId;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.Timestamp;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public class PrimaryVolumeDescriptor
extends UDFDescriptor {
    public Long volumeDescriptorSeq;
    public Long primaryVolumeDescriptorNum;
    public DString volumeIdentifier;
    public Integer volumeSeq;
    public Integer maxVolumeSeq;
    public Integer interchangeLevel;
    public Integer maxInterchangeLevel;
    public Long charsetList;
    public Long maxCharsetList;
    public DString volumeSetIdentifier;
    public CharSpec descriptorCharset;
    public CharSpec explanatoryCharset;
    public ExtentAD volumeAbstract;
    public ExtentAD volumeCopyrightNotice;
    public RegId appIdentifier;
    public Timestamp recordDateTime;
    public RegId implIdentifier;
    public byte[] implUse;
    public Long predecessorVDSeq;
    public Integer flags;
    public final int LEN_VD_SEQ = 4;
    public final int LEN_PRIM_VD_NUM = 4;
    public final int LEN_VOL_ID = 32;
    public final int LEN_VOL_SEQ = 2;
    public final int LEN_MAX_VOL_SEQ = 2;
    public final int LEN_INTERCH_LVL = 2;
    public final int LEN_MAX_INTERCH_LVL = 2;
    public final int LEN_CHARSET_LIST = 4;
    public final int LEN_MAX_CHARSET_LIST = 4;
    public final int LEN_VOL_SET_ID = 128;
    public final int LEN_DESCRIPTOR_CHAR = 64;
    public final int LEN_EXPLAN_CHAR = 64;
    public final int LEN_VOL_ABSTRACT = 8;
    public final int LEN_VOL_COPYRIGHT = 8;
    public final int LEN_APP_ID = 32;
    public final int LEN_RECORD_DT = 12;
    public final int LEN_IMPL_ID = 32;
    public final int LEN_IMPL_USE = 64;
    public final int LEN_PRE_VD_SEQ = 4;
    public final int LEN_FLAGS = 2;
    public final int LEN_RESERVED = 22;
    public final int BP_VD_SEQ = 16;
    public final int BP_PRIM_VD_NUM = 20;
    public final int BP_VOL_ID = 24;
    public final int BP_VOL_SEQ = 56;
    public final int BP_MAX_VOL_SEQ = 58;
    public final int BP_INTERCH_LVL = 60;
    public final int BP_MAX_INTERCH_LVL = 62;
    public final int BP_CHARSET_LIST = 64;
    public final int BP_MAX_CHARSET_LIST = 68;
    public final int BP_VOL_SET_ID = 72;
    public final int BP_DESCRIPTOR_CHAR = 200;
    public final int BP_EXPLAN_CHAR = 264;
    public final int BP_VOL_ABSTRACT = 328;
    public final int BP_VOL_COPYRIGHT = 336;
    public final int BP_APP_ID = 344;
    public final int BP_RECORD_DT = 376;
    public final int BP_IMPL_ID = 388;
    public final int BP_IMPL_USE = 420;
    public final int BP_PRE_VD_SEQ = 484;
    public final int BP_FLAGS = 488;
    public final int BP_RESERVED = 490;
    public final int EP_VD_SEQ = 20;
    public final int EP_PRIM_VD_NUM = 24;
    public final int EP_VOL_ID = 56;
    public final int EP_VOL_SEQ = 58;
    public final int EP_MAX_VOL_SEQ = 60;
    public final int EP_INTERCH_LVL = 62;
    public final int EP_MAX_INTERCH_LVL = 64;
    public final int EP_CHARSET_LIST = 68;
    public final int EP_MAX_CHARSET_LIST = 72;
    public final int EP_VOL_SET_ID = 200;
    public final int EP_DESCRIPTOR_CHAR = 264;
    public final int EP_EXPLAN_CHAR = 328;
    public final int EP_VOL_ABSTRACT = 336;
    public final int EP_VOL_COPYRIGHT = 344;
    public final int EP_APP_ID = 376;
    public final int EP_RECORD_DT = 388;
    public final int EP_IMPL_ID = 420;
    public final int EP_IMPL_USE = 484;
    public final int EP_PRE_VD_SEQ = 488;
    public final int EP_FLAGS = 490;
    public final int EP_RESERVED = 512;
    public final int MINIMUM_LENGTH = 512;

    public PrimaryVolumeDescriptor() {
    }

    public PrimaryVolumeDescriptor(byte[] bytes) throws InvalidDescriptor {
        super(bytes);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 1;
    }

    @Override
    public void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 512) {
            throw new InvalidDescriptor("Primary volume descriptor too short");
        }
        this.deserializeTag(bytes);
        this.volumeDescriptorSeq = UDFUtil.getUInt32(bytes, 16);
        this.primaryVolumeDescriptorNum = UDFUtil.getUInt32(bytes, 20);
        byte[] fragment = UDFUtil.getBytes(bytes, 24, 32);
        this.volumeIdentifier = new DString(fragment);
        this.volumeSeq = UDFUtil.getUInt16(bytes, 56);
        this.maxVolumeSeq = UDFUtil.getUInt16(bytes, 58);
        this.interchangeLevel = UDFUtil.getUInt16(bytes, 60);
        this.maxInterchangeLevel = UDFUtil.getUInt16(bytes, 62);
        this.charsetList = UDFUtil.getUInt32(bytes, 64);
        this.maxCharsetList = UDFUtil.getUInt32(bytes, 68);
        fragment = UDFUtil.getBytes(bytes, 72, 128);
        this.volumeSetIdentifier = new DString(fragment);
        fragment = UDFUtil.getBytes(bytes, 200, 64);
        this.descriptorCharset = new CharSpec(fragment);
        fragment = UDFUtil.getBytes(bytes, 264, 64);
        this.explanatoryCharset = new CharSpec(fragment);
        fragment = UDFUtil.getBytes(bytes, 328, 8);
        this.volumeAbstract = new ExtentAD(fragment);
        fragment = UDFUtil.getBytes(bytes, 336, 8);
        this.volumeCopyrightNotice = new ExtentAD(fragment);
        fragment = UDFUtil.getBytes(bytes, 344, 32);
        this.appIdentifier = new RegId(fragment);
        fragment = UDFUtil.getBytes(bytes, 376, 12);
        this.recordDateTime = new Timestamp(fragment);
        fragment = UDFUtil.getBytes(bytes, 388, 32);
        this.implIdentifier = new RegId(fragment);
        this.implUse = UDFUtil.getBytes(bytes, 420, 64);
        this.predecessorVDSeq = UDFUtil.getUInt32(bytes, 484);
        this.flags = UDFUtil.getUInt16(bytes, 488);
    }
}

