/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptorTag;
import java.util.ArrayList;
import java.util.List;

public class DescriptorTag {
    private static List<Integer> D_TYPES = new ArrayList<Integer>();
    public Integer identifier;
    public Integer version;
    public Integer checksum;
    public Integer serialNumber;
    public Integer crc;
    public Integer crcLength;
    public Long location;
    public final int LEN_IDENTIFIER = 2;
    public final int LEN_VERSION = 2;
    public final int LEN_CHECKSUM = 1;
    public final int LEN_RESERVED = 1;
    public final int LEN_SERIAL_NUMBER = 2;
    public final int LEN_CRC = 2;
    public final int LEN_CRC_LENGTH = 2;
    public final int LEN_LOCATION = 4;
    public final int BP_IDENTIFIER = 0;
    public final int BP_VERSION = 2;
    public final int BP_CHECKSUM = 4;
    public final int BP_RESERVED = 5;
    public final int BP_SERIAL_NUMBER = 6;
    public final int BP_CRC = 8;
    public final int BP_CRC_LENGTH = 10;
    public final int BP_LOCATION = 12;
    public final int MINIMUM_LENGTH = 16;

    public DescriptorTag(byte[] bytes) throws InvalidDescriptorTag {
        this.deserialize(bytes);
    }

    public void deserialize(byte[] bytes) throws InvalidDescriptorTag {
        if (bytes.length < 16) {
            throw new InvalidDescriptorTag("descriptor tag too short");
        }
        this.identifier = UDFUtil.getUInt16(bytes, 0);
        if (!D_TYPES.contains(this.identifier)) {
            throw new InvalidDescriptorTag("Unknown tag identifier: " + this.identifier);
        }
        this.version = UDFUtil.getUInt16(bytes, 2);
        this.checksum = UDFUtil.getUInt8(bytes, 4);
        this.serialNumber = UDFUtil.getUInt16(bytes, 6);
        this.crc = UDFUtil.getUInt16(bytes, 8);
        this.crcLength = UDFUtil.getUInt16(bytes, 10);
        this.location = UDFUtil.getUInt32(bytes, 12);
    }

    static {
        D_TYPES.add(1);
        D_TYPES.add(2);
        D_TYPES.add(3);
        D_TYPES.add(4);
        D_TYPES.add(5);
        D_TYPES.add(6);
        D_TYPES.add(7);
        D_TYPES.add(8);
        D_TYPES.add(9);
        D_TYPES.add(256);
        D_TYPES.add(257);
        D_TYPES.add(258);
        D_TYPES.add(259);
        D_TYPES.add(260);
        D_TYPES.add(261);
        D_TYPES.add(262);
        D_TYPES.add(263);
        D_TYPES.add(264);
        D_TYPES.add(265);
        D_TYPES.add(266);
    }
}

