/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.LBAddr;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidICBTag;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidLBAddr;

public class ICBTag {
    public Long priorEntryNum;
    public Integer strategyType;
    public byte[] strategyParam;
    public Integer maxEntries;
    public Integer fileType;
    public LBAddr parentICBLocation;
    public Integer flags;
    public final int LEN_PRI_ENT_NUM = 4;
    public final int LEN_STG_TYPE = 2;
    public final int LEN_STG_PARAM = 2;
    public final int LEN_MAX_ENTRIES = 2;
    public final int LEN_RESERVED = 1;
    public final int LEN_FILE_TYPE = 1;
    public final int LEN_P_ICB_LOC = 6;
    public final int LEN_FLAGS = 2;
    public final int BP_PRI_ENT_NUM = 0;
    public final int BP_STG_TYPE = 4;
    public final int BP_STG_PARAM = 6;
    public final int BP_MAX_ENTRIES = 8;
    public final int BP_RESERVED = 10;
    public final int BP_FILE_TYPE = 11;
    public final int BP_P_ICB_LOC = 12;
    public final int BP_FLAGS = 18;
    public final int EP_PRI_ENT_NUM = 4;
    public final int EP_STG_TYPE = 6;
    public final int EP_STG_PARAM = 8;
    public final int EP_MAX_ENTRIES = 10;
    public final int EP_RESERVED = 11;
    public final int EP_FILE_TYPE = 12;
    public final int EP_P_ICB_LOC = 18;
    public final int EP_FLAGS = 20;
    public final int MINIMUM_LENGTH = 20;

    public ICBTag(byte[] bytes) throws InvalidICBTag {
        this.deserialize(bytes);
    }

    public void deserialize(byte[] bytes) throws InvalidICBTag {
        if (bytes.length < 20) {
            throw new InvalidICBTag("ICB tag too short");
        }
        this.priorEntryNum = UDFUtil.getUInt32(bytes, 0);
        this.strategyType = UDFUtil.getUInt16(bytes, 4);
        if (this.strategyType != 4) {
            throw new InvalidICBTag("Unsupported ICB strategy: " + this.strategyType);
        }
        this.strategyParam = UDFUtil.getBytes(bytes, 6, 2);
        this.maxEntries = UDFUtil.getUInt16(bytes, 8);
        this.fileType = UDFUtil.getUInt8(bytes, 11);
        byte[] fragment = UDFUtil.getBytes(bytes, 12, 6);
        try {
            this.parentICBLocation = new LBAddr(fragment);
        }
        catch (InvalidLBAddr ex) {
            throw new InvalidICBTag(ex.getMessage());
        }
        this.flags = UDFUtil.getUInt16(bytes, 18);
    }
}

