/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.LBAddr;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidLBAddr;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidLongAD;

public class LongAD {
    public Long length;
    public LBAddr location;
    public byte[] implUse;
    public final int LEN_LENGTH = 4;
    public final int LEN_LOCATION = 6;
    public final int LEN_IMPL_USE = 6;
    public final int BP_LENGTH = 0;
    public final int BP_LOCATION = 4;
    public final int BP_IMPL_USE = 10;
    public final int EP_LOCATION = 8;
    public final int EP_IMPL_USE = 16;
    public final int MINIMUM_LENGTH = 16;

    public LongAD(byte[] bytes) throws InvalidLongAD {
        this.deserialize(bytes);
    }

    public void deserialize(byte[] bytes) throws InvalidLongAD {
        if (bytes.length < 16) {
            throw new InvalidLongAD("long allocation descriptor too short");
        }
        this.length = UDFUtil.getUInt32(bytes, 0);
        byte[] lbAddrBytes = UDFUtil.getBytes(bytes, 4, 6);
        try {
            this.location = new LBAddr(lbAddrBytes);
        }
        catch (InvalidLBAddr ex) {
            throw new InvalidLongAD(ex.getMessage());
        }
        this.implUse = UDFUtil.getBytes(bytes, 10, 6);
    }
}

