/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import com.threerings.getdown.Log;
import com.threerings.getdown.data.EnvConfig;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.launcher.Getdown;
import com.threerings.getdown.launcher.h;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

public class GetdownApp {
    public static void main(String[] stringArray) {
        try {
            GetdownApp.start(stringArray);
            return;
        }
        catch (Exception exception) {
            Log.log.warning("main() failed.", exception);
            return;
        }
    }

    public static Getdown start(String[] object) throws Exception {
        ArrayList<EnvConfig.Note> arrayList2 = new ArrayList<EnvConfig.Note>();
        if ((object = EnvConfig.create((String[])object, arrayList2)) == null) {
            if (!arrayList2.isEmpty()) {
                for (EnvConfig.Note note : arrayList2) {
                    System.err.println(note.message);
                }
            } else {
                System.err.println("Usage: java -jar getdown.jar [app_dir] [app_id] [app args]");
            }
            System.exit(-1);
        }
        if (!SysProps.noLogRedir()) {
            File file = new File(((EnvConfig)object).appDir, "launcher.log");
            try {
                PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)), true);
                System.setOut(printStream);
                System.setErr(printStream);
            }
            catch (IOException iOException) {
                Log.log.warning("Unable to redirect output to '" + file + "': " + iOException, new Object[0]);
            }
        }
        boolean bl = false;
        for (EnvConfig.Note note : arrayList2) {
            switch (note.level) {
                case INFO: {
                    Log.log.info(note.message, new Object[0]);
                    break;
                }
                case WARN: {
                    Log.log.warning(note.message, new Object[0]);
                    break;
                }
                case ERROR: {
                    Log.log.error(note.message, new Object[0]);
                    bl = true;
                }
            }
        }
        if (bl) {
            System.exit(-1);
        }
        Log.log.info("------------------ VM Info ------------------", new Object[0]);
        Log.log.info("-- OS Name: " + System.getProperty("os.name"), new Object[0]);
        Log.log.info("-- OS Arch: " + System.getProperty("os.arch"), new Object[0]);
        Log.log.info("-- OS Vers: " + System.getProperty("os.version"), new Object[0]);
        Log.log.info("-- Java Vers: " + System.getProperty("java.version"), new Object[0]);
        Log.log.info("-- Java Home: " + System.getProperty("java.home"), new Object[0]);
        Log.log.info("-- User Name: " + System.getProperty("user.name"), new Object[0]);
        Log.log.info("-- User Home: " + System.getProperty("user.home"), new Object[0]);
        Log.log.info("-- Cur dir: " + System.getProperty("user.dir"), new Object[0]);
        Log.log.info("---------------------------------------------", new Object[0]);
        h h2 = new h((EnvConfig)object);
        h2.start();
        return h2;
    }
}

