/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.ExtentAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.RegId;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.Timestamp;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public class LogicalVolumeIntegrityDescriptor
extends UDFDescriptor {
    Timestamp recordingDateAndTime;
    Long integrityType;
    ExtentAD nextIntegrityExtent;
    byte[] logicalVolumeContentsUse;
    Long numberOfPartitions;
    Long lengthOfImplementationUse;
    byte[] freeSpaceTable;
    byte[] sizeTable;
    RegId implementationId;
    Long numberOfFiles;
    Long numberOfDirectories;
    Integer minReadVersion;
    Integer minWriteVersion;
    Integer maxWriteersion;
    byte[] implementationUse;
    public static final int MINUMUM_LENGTH = 80;

    public LogicalVolumeIntegrityDescriptor() {
    }

    public LogicalVolumeIntegrityDescriptor(byte[] bytes) throws InvalidDescriptor {
        super(bytes);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 9;
    }

    @Override
    public void deserialize(byte[] bytes) throws InvalidDescriptor {
        if (bytes.length < 80) {
            throw new InvalidDescriptor("LogicalVolumeIntegrityDescriptor descriptor too short");
        }
        this.deserializeTag(bytes);
        this.recordingDateAndTime = new Timestamp(this.getBytes(bytes, 12));
        this.integrityType = this.getUInt32(bytes);
        this.nextIntegrityExtent = new ExtentAD(this.getBytes(bytes, 8));
        this.logicalVolumeContentsUse = this.getBytes(bytes, 32);
        this.numberOfPartitions = this.getUInt32(bytes);
        this.lengthOfImplementationUse = this.getUInt32(bytes);
        this.freeSpaceTable = this.getBytes(bytes, this.numberOfPartitions.intValue() * 4);
        this.sizeTable = this.getBytes(bytes, this.numberOfPartitions.intValue() * 4);
        this.implementationId = new RegId(this.getBytes(bytes, 32));
        this.numberOfFiles = this.getUInt32(bytes);
        this.numberOfDirectories = this.getUInt32(bytes);
        this.minReadVersion = this.getUInt16(bytes);
        this.minWriteVersion = this.getUInt16(bytes);
        this.maxWriteersion = this.getUInt16(bytes);
        this.implementationUse = this.getBytes(bytes, this.lengthOfImplementationUse.intValue() - 46);
    }
}

