/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.DescriptorTag;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import com.github.stephenc.javaisotools.loopfs.util.LittleEndian;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public abstract class UDFDescriptor {
    public DescriptorTag tag;
    public final int TAG_LENGTH = 16;
    public int currentPos = 16;

    public UDFDescriptor() {
    }

    public UDFDescriptor(byte[] bytes) throws InvalidDescriptor {
        this.deserialize(bytes);
        this.verifyTagIdentifier();
    }

    public abstract int getExpectedTagIdentifier();

    public abstract void deserialize(byte[] var1) throws InvalidDescriptor;

    public void verifyTagIdentifier() throws InvalidDescriptor {
        Integer tagId = this.tag.identifier;
        if (tagId.intValue() != this.getExpectedTagIdentifier()) {
            throw new InvalidDescriptor("Unexpected tag identifier: " + tagId.toString());
        }
    }

    public void deserializeTag(byte[] bytes) throws InvalidDescriptor {
        this.tag = new DescriptorTag(bytes);
    }

    public int getUInt8(byte[] block) {
        int i = LittleEndian.getUInt8((byte[])block, (int)this.currentPos);
        ++this.currentPos;
        return i;
    }

    public int getUInt16(byte[] block) {
        int i = LittleEndian.getUInt16((byte[])block, (int)this.currentPos);
        this.currentPos += 2;
        return i;
    }

    public long getUInt32(byte[] block) {
        long i = LittleEndian.getUInt32((byte[])block, (int)this.currentPos);
        this.currentPos += 4;
        return i;
    }

    public BigInteger getUInt64(byte[] block) {
        byte[] fragment = this.getBytes(block, 8);
        ArrayUtils.reverse((byte[])fragment);
        return new BigInteger(fragment);
    }

    public byte[] getBytes(byte[] bytes, int length) {
        byte[] b = Arrays.copyOfRange(bytes, this.currentPos, this.currentPos + length);
        this.currentPos += length;
        return b;
    }
}

