/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.LBAddr;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidLBAddr;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidLongAD;
import java.nio.charset.StandardCharsets;

public class LongAD {
    public Long length;
    public LBAddr location;
    public byte[] implUse;
    public static final int LENGTH = 16;

    public LongAD(byte[] bytes) throws InvalidLongAD {
        this.deserialize(bytes);
    }

    public void deserialize(byte[] bytes) throws InvalidLongAD {
        if (bytes.length < 16) {
            throw new InvalidLongAD("long allocation descriptor too short");
        }
        this.length = UDFUtil.getUInt32(bytes, 0);
        byte[] lbAddrBytes = UDFUtil.getBytes(bytes, 4, 6);
        try {
            this.location = new LBAddr(lbAddrBytes);
        }
        catch (InvalidLBAddr ex) {
            throw new InvalidLongAD(ex.getMessage());
        }
        this.implUse = UDFUtil.getBytes(bytes, 10, 6);
    }

    public String toString() {
        return "LongAD [length=" + this.length + ", location=" + this.location + ", implUse=" + new String(this.implUse, StandardCharsets.UTF_8).trim() + "]";
    }
}

